/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.alert.Alert;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.Wizard;
import oracle.ewt.wizard.WizardDialog;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardValidateListener;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.BEQAddress;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.IPCAddress;
import oracle.net.asst.addr.NMPAddress;
import oracle.net.asst.addr.SPXAddress;
import oracle.net.asst.addr.TCPAddress;
import oracle.net.asst.addr.TCPSAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.servicewizard.BEQWizardPanel;
import oracle.net.asst.servicewizard.ConnectWizardPanel;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.servicewizard.IPCWizardPanel;
import oracle.net.asst.servicewizard.NMPWizardPanel;
import oracle.net.asst.servicewizard.NextTimePanel;
import oracle.net.asst.servicewizard.ProtocolWizardPanel;
import oracle.net.asst.servicewizard.SIDWizardPanel;
import oracle.net.asst.servicewizard.SPXWizardPanel;
import oracle.net.asst.servicewizard.ServiceNameWizardPanel;
import oracle.net.asst.servicewizard.TCPSWizardPanel;
import oracle.net.asst.servicewizard.TCPWizardPanel;
import oracle.net.asst.servicewizard.TestConnDialog;
import oracle.net.common.NetProperties;
import oracle.net.common.netObject.AddressList;
import oracle.net.common.netObject.NetService;

public final class ServiceWizard
implements ActionListener,
WizardListener,
WizardValidateListener {
    private static final int ALERTX = 150;
    private static final int ALERTY = 150;
    private static final int TSTDLGX = 150;
    private static final int TSTDLGY = 150;
    private static final int EXIT_USER_CANCEL = -1;
    private static final int EXIT_NORMAL = 0;
    private static final int EXIT_ERROR = 1;
    private NetService m_netService;
    private AddressList m_addressList;
    private String m_protocol;
    private Vector m_addrVect;
    private Vector m_availProtVect;
    private NetProperties m_property;
    private NetStrings m_netStrings;
    private String m_defaultProtocol = "TCP";
    private Alert m_alert;
    private BufferedFrame m_theFrame;
    private Wizard m_theWizard;
    private WizardDialog m_theDialog;
    private BufferedFrame m_callerFrame;
    private ServiceNameWizardPanel m_serviceNameWizPan;
    private ProtocolWizardPanel m_protocolWizPan;
    private TCPWizardPanel m_TCPWizPan;
    private TCPSWizardPanel m_TCPSWizPan;
    private SPXWizardPanel m_SPXWizPan;
    private NMPWizardPanel m_NMPWizPan;
    private BEQWizardPanel m_BEQWizPan;
    private IPCWizardPanel m_IPCWizPan;
    private SIDWizardPanel m_SIDWizPan;
    private ConnectWizardPanel m_connectWizPan;
    private NextTimePanel m_nextTimePan;
    private String m_titleString;
    private String m_welcomeString;
    private String m_page1String;
    private String m_page2String;
    private String m_page3String;
    private String m_page4String;
    private String m_page5String;
    private String m_finishString;
    private WizardPage m_serviceNameWizPg;
    private WizardPage m_protocolWizPg;
    private WizardPage m_TCPWizPg;
    private WizardPage m_TCPSWizPg;
    private WizardPage m_SPXWizPg;
    private WizardPage m_NMPWizPg;
    private WizardPage m_BEQWizPg;
    private WizardPage m_IPCWizPg;
    private WizardPage m_SIDWizPg;
    private WizardPage m_connectWizPg;
    private WizardPage m_nextTimeWizPg;
    private char[] m_illegalChars;

    public ServiceWizard(BufferedFrame bufferedFrame, Vector vector, String string, char[] cArray) {
        this.m_callerFrame = bufferedFrame;
        this.m_illegalChars = cArray;
        try {
            this.m_netStrings = new NetStrings();
        }
        catch (Exception exception) {
            System.out.println("ServiceWizard.<init>: Message Resource exception." + exception);
            exception.printStackTrace();
        }
        this.m_addrVect = vector == null ? new Vector() : vector;
        try {
            this.m_property = NetProperties.getInstance();
        }
        catch (Exception exception) {
            System.out.println("ServiceWizard.<init>: Network Properties loading exception." + exception);
            exception.printStackTrace();
        }
        this.setupAvailProtocols();
        this.m_theFrame = new BufferedFrame();
        this.m_theWizard = new Wizard();
        this.m_theWizard.addWizardListener((WizardListener)this);
        this.m_theWizard.setMustFinish(true);
        this.m_theWizard.setHelpAvailable(false);
        this.m_theWizard.setCanApply(false);
        this.setupInitPanels(string);
        this.setupAddressPanels();
        this.m_welcomeString = this.m_netStrings.getString("SNWTitleWelcome");
        this.m_page1String = this.m_netStrings.getString("SNWTitlePage1");
        this.m_page2String = this.m_netStrings.getString("SNWTitlePage2");
        this.m_page3String = this.m_netStrings.getString("SNWTitlePage3");
        this.m_page4String = this.m_netStrings.getString("SNWTitlePage4");
        this.m_page5String = this.m_netStrings.getString("SNWTitlePage5");
        this.m_finishString = this.m_netStrings.getString("SNWTitleFinish");
        this.m_theDialog = new WizardDialog((BaseWizard)this.m_theWizard, (Frame)bufferedFrame);
        this.m_theDialog.setPreferredSize(600, 360);
        this.m_theDialog.setSize(600, 360);
        this.m_theDialog.setResizable(false);
        this.m_titleString = new String(this.m_netStrings.getString("SNWWizardTitle"));
        this.m_theDialog.setTitle(String.valueOf(this.m_titleString) + this.m_welcomeString);
        this.centerOnScreen(bufferedFrame, (Component)this.m_theDialog);
    }

    public void go() {
        this.m_protocolWizPan.setProtocol2(this.m_defaultProtocol);
        this.m_theDialog.runDialog();
        this.m_theDialog.dispose();
    }

    public void wizardValidatePage(WizardEvent wizardEvent) {
        WizardPage wizardPage = wizardEvent.getPage();
        if (wizardPage == this.m_serviceNameWizPg) {
            String string = this.m_serviceNameWizPan.getService();
            if (string.equals("")) {
                this.blankAlert();
                ((Cancelable)wizardEvent).cancel();
                return;
            }
            if (this.isDuplicate(string)) {
                this.dupAlert(string);
                ((Cancelable)wizardEvent).cancel();
                return;
            }
        } else if (wizardPage == this.m_protocolWizPg) {
            this.m_protocol = this.m_protocolWizPan.getProtocol();
            if (this.m_protocol.equals(TCPSAddress.TCPS_PROTOCOL)) {
                this.enableTCPS();
            }
            if (this.m_protocol.equals(TCPAddress.TCP_PROTOCOL)) {
                this.enableTCP();
            }
            if (this.m_protocol.equals(SPXAddress.SPX_PROTOCOL)) {
                this.enableSPX();
            }
            if (this.m_protocol.equals(NMPAddress.NMP_PROTOCOL)) {
                this.enableNMP();
            }
            if (this.m_protocol.equals(BEQAddress.BEQ_PROTOCOL)) {
                this.enableBEQ();
            }
            if (this.m_protocol.equals(IPCAddress.IPC_PROTOCOL)) {
                this.enableIPC();
                return;
            }
        } else if (wizardPage == this.m_TCPWizPg) {
            if (!this.m_TCPWizPan.areDataValid()) {
                this.blankAlert();
                ((Cancelable)wizardEvent).cancel();
                return;
            }
        } else if (wizardPage == this.m_TCPSWizPg) {
            if (!this.m_TCPSWizPan.areDataValid()) {
                this.blankAlert();
                ((Cancelable)wizardEvent).cancel();
                return;
            }
        } else if (wizardPage == this.m_SPXWizPg) {
            if (!this.m_SPXWizPan.areDataValid()) {
                this.blankAlert();
                ((Cancelable)wizardEvent).cancel();
                return;
            }
        } else if (wizardPage == this.m_NMPWizPg) {
            if (!this.m_NMPWizPan.areDataValid()) {
                this.blankAlert();
                ((Cancelable)wizardEvent).cancel();
                return;
            }
        } else if (wizardPage == this.m_IPCWizPg) {
            if (!this.m_IPCWizPan.areDataValid()) {
                this.blankAlert();
                ((Cancelable)wizardEvent).cancel();
                return;
            }
        } else if (wizardPage == this.m_SIDWizPg) {
            NetValidate netValidate = new NetValidate(this.m_callerFrame);
            String string = this.m_SIDWizPan.getService();
            if (this.m_SIDWizPan.isBackCompat() && !NetValidate.validateSID(string)) {
                netValidate.showDialog(this.m_netStrings.getString("SNCSID"));
                ((Cancelable)wizardEvent).cancel();
                return;
            }
            if (!NetValidate.validateServiceName(string)) {
                netValidate.showDialog(this.m_netStrings.getString("SNCServiceName"));
                ((Cancelable)wizardEvent).cancel();
                return;
            }
            this.buildAddress();
        }
    }

    public void wizardSelectionChanged(WizardEvent wizardEvent) {
        WizardPage wizardPage = wizardEvent.getPage();
        String string = "";
        if (wizardPage == this.m_serviceNameWizPg) {
            string = this.m_page1String;
        } else if (wizardPage == this.m_protocolWizPg) {
            string = this.m_page2String;
        } else if (wizardPage == this.m_TCPWizPg || wizardPage == this.m_SPXWizPg || wizardPage == this.m_NMPWizPg || wizardPage == this.m_IPCWizPg || wizardPage == this.m_TCPSWizPg) {
            string = this.m_page3String;
        } else if (wizardPage == this.m_SIDWizPg) {
            string = this.m_page4String;
        } else if (wizardPage == this.m_connectWizPg) {
            string = this.m_page5String;
        } else if (wizardPage == this.m_nextTimeWizPg) {
            string = this.m_finishString;
        }
        if (this.m_theDialog != null) {
            this.m_theDialog.setTitle(String.valueOf(this.m_titleString) + string);
        }
    }

    public void wizardApplyState(WizardEvent wizardEvent) {
    }

    public void wizardCanceled(WizardEvent wizardEvent) {
        this.m_netService = null;
        this.m_theDialog.setVisible(false);
        this.m_theDialog.dispose();
    }

    public void wizardFinished(WizardEvent wizardEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        ((Component)object).setEnabled(false);
        if (object instanceof LWButton && actionEvent.getActionCommand().compareTo(ConnectWizardPanel.ACTION_TEST) == 0) {
            WizardPage wizardPage = this.m_theWizard.getSelectedPage();
            boolean bl = wizardPage.getCanAdvance();
            wizardPage.setCanAdvance(false);
            TestConnDialog testConnDialog = new TestConnDialog(this.m_theFrame, this.m_netStrings, this.m_netService);
            this.centerOnScreen(this.m_theFrame, (Component)((Object)testConnDialog));
            ((Dialog)((Object)testConnDialog)).show();
            wizardPage.setCanAdvance(bl);
            String string = System.getProperty("os.name");
            if (string.startsWith("Windows")) {
                this.m_theDialog.toFront();
            }
        }
        ((Component)object).setEnabled(true);
    }

    public NetService getTheAddress() {
        return this.m_netService;
    }

    private boolean isDuplicate(String string) {
        Enumeration enumeration = this.m_addrVect.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equalsIgnoreCase(enumeration.nextElement().toString())) continue;
            return true;
        }
        return false;
    }

    void dupAlert(String string) {
        Toolkit.getDefaultToolkit().beep();
        Object[] objectArray = new Object[]{string};
        this.m_alert = new Alert((Frame)this.m_theFrame, MessageFormat.format(this.m_netStrings.getString("SNWDuplicate"), objectArray), 0, 1);
        this.m_alert.runAlert();
        this.m_alert.dispose();
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            this.m_theDialog.toFront();
        }
    }

    void blankAlert() {
        Toolkit.getDefaultToolkit().beep();
        this.m_alert = new Alert((Frame)this.m_theFrame, this.m_netStrings.getString("SNWSupplyAll"), 0, 1);
        this.m_alert.runAlert();
        this.m_alert.dispose();
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.m_theDialog.toFront();
        }
    }

    private void enableAddressPanels() {
        if (this.m_netService != null) {
            this.m_SIDWizPan.setParams(this.m_netService);
            this.m_addressList = this.m_netService.getFirstDescription().getAddressList();
            Address address = this.m_addressList.getAddressAt(0);
            this.m_protocolWizPan.setProtocol(address);
            String string = address.getProtocol();
            if (string.equals(TCPAddress.TCP_PROTOCOL)) {
                this.m_TCPWizPan.setParams(address);
                this.m_TCPSWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (string.equals(TCPSAddress.TCPS_PROTOCOL)) {
                this.m_TCPSWizPan.setParams(address);
                this.m_TCPWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (string.equals(SPXAddress.SPX_PROTOCOL)) {
                this.m_SPXWizPan.setParams(address);
                this.m_TCPSWizPan.setParams(null);
                this.m_TCPWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (string.equals(NMPAddress.NMP_PROTOCOL)) {
                this.m_NMPWizPan.setParams(address);
                this.m_TCPSWizPan.setParams(null);
                this.m_TCPWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
                this.m_IPCWizPan.setParams(null);
            }
            if (string.equals(IPCAddress.IPC_PROTOCOL)) {
                this.m_IPCWizPan.setParams(address);
                this.m_TCPSWizPan.setParams(null);
                this.m_TCPWizPan.setParams(null);
                this.m_NMPWizPan.setParams(null);
                this.m_SPXWizPan.setParams(null);
            }
        } else {
            this.m_protocolWizPan.setProtocol(null);
            this.m_SIDWizPan.setParams(null);
        }
        this.m_protocolWizPg.setEnabled(true);
        this.m_protocolWizPg.setVisible(true);
        this.m_SIDWizPg.setEnabled(true);
        this.m_SIDWizPg.setVisible(true);
        this.m_connectWizPg.setEnabled(true);
        this.m_connectWizPg.setVisible(true);
    }

    private void disableAddressPanels() {
        this.m_protocolWizPg.setEnabled(false);
        this.m_protocolWizPg.setVisible(false);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
        this.m_SIDWizPg.setEnabled(false);
        this.m_SIDWizPg.setVisible(false);
        this.m_connectWizPg.setEnabled(false);
        this.m_connectWizPg.setVisible(false);
    }

    private void enableTCP() {
        this.m_TCPWizPg.setEnabled(true);
        this.m_TCPWizPg.setVisible(true);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableTCPS() {
        this.m_TCPSWizPg.setEnabled(true);
        this.m_TCPSWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableSPX() {
        this.m_SPXWizPg.setEnabled(true);
        this.m_SPXWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableNMP() {
        this.m_NMPWizPg.setEnabled(true);
        this.m_NMPWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableBEQ() {
        this.m_BEQWizPg.setEnabled(true);
        this.m_BEQWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
    }

    private void enableIPC() {
        this.m_IPCWizPg.setEnabled(true);
        this.m_IPCWizPg.setVisible(true);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
    }

    private void centerOnScreen(BufferedFrame bufferedFrame, Component component) {
        Toolkit toolkit = bufferedFrame.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = component.getSize();
        component.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    void buildAddress() {
        try {
            String string = this.m_serviceNameWizPan.getService();
            String string2 = this.m_SIDWizPan.getService();
            Address address = this.getGeneratedAddress(string2);
            this.m_netService = new NetService(string, string2, address, this.m_SIDWizPan.isBackCompat());
            String string3 = this.m_SIDWizPan.getSRVR();
            if (string3 != null) {
                this.m_netService.getFirstDescription().getConnectData().setSRVR(string3);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Address getGeneratedAddress(String string) throws CreateAddressException {
        if (this.m_protocol.equals(TCPAddress.TCP_PROTOCOL)) {
            return this.m_TCPWizPan.getAddress();
        }
        if (this.m_protocol.equals(TCPSAddress.TCPS_PROTOCOL)) {
            return this.m_TCPSWizPan.getAddress();
        }
        if (this.m_protocol.equals(SPXAddress.SPX_PROTOCOL)) {
            return this.m_SPXWizPan.getAddress();
        }
        if (this.m_protocol.equals(NMPAddress.NMP_PROTOCOL)) {
            return this.m_NMPWizPan.getAddress();
        }
        if (this.m_protocol.equals(BEQAddress.BEQ_PROTOCOL)) {
            return this.m_BEQWizPan.getAddress();
        }
        if (this.m_protocol.equals(IPCAddress.IPC_PROTOCOL)) {
            return this.m_IPCWizPan.getAddress();
        }
        throw new IllegalArgumentException("ServiceWizard: Illegal protocol \"" + this.m_protocol + "\" on FINISH.");
    }

    private void setupAvailProtocols() {
        this.m_availProtVect = new Vector();
        String string = new String("");
        try {
            string = this.m_property.getProperty("TCP");
            if (string != null && string.toUpperCase().equals("YES")) {
                this.m_availProtVect.addElement(TCPAddress.TCP_PROTOCOL);
            }
            if ((string = this.m_property.getProperty("TCPS")) != null && string.toUpperCase().equals("YES")) {
                this.m_availProtVect.addElement(TCPSAddress.TCPS_PROTOCOL);
            }
            if ((string = this.m_property.getProperty("SPX")) != null && string.toUpperCase().equals("YES")) {
                this.m_availProtVect.addElement(SPXAddress.SPX_PROTOCOL);
            }
            if ((string = this.m_property.getProperty("NMP")) != null && string.toUpperCase().equals("YES")) {
                this.m_availProtVect.addElement(NMPAddress.NMP_PROTOCOL);
            }
            if ((string = this.m_property.getProperty("BEQ")) != null && string.toUpperCase().equals("YES")) {
                this.m_availProtVect.addElement(BEQAddress.BEQ_PROTOCOL);
            }
            if ((string = this.m_property.getProperty("IPC")) != null && string.toUpperCase().equals("YES")) {
                this.m_availProtVect.addElement(IPCAddress.IPC_PROTOCOL);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.m_availProtVect.addElement(TCPAddress.TCP_PROTOCOL);
        }
    }

    private void setupInitPanels(String string) {
        this.m_serviceNameWizPan = new ServiceNameWizardPanel(this.m_netStrings, string, this.m_illegalChars);
        this.m_serviceNameWizPg = new FocusingWizardPage((Component)((Object)this.m_serviceNameWizPan), this.m_netStrings.getString("SNWNewServiceTle"));
        this.m_theWizard.addPage(this.m_serviceNameWizPg);
        this.m_serviceNameWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_connectWizPan = new ConnectWizardPanel(this.m_netStrings, this);
        this.m_connectWizPg = new FocusingWizardPage((Component)((Object)this.m_connectWizPan), this.m_netStrings.getString("SNWConnTle"));
        this.m_theWizard.addPage(this.m_connectWizPg);
        this.m_connectWizPg.addWizardValidateListener((WizardValidateListener)this);
    }

    private void setupAddressPanels() {
        this.m_protocolWizPan = new ProtocolWizardPanel(this.m_netStrings, this.m_availProtVect);
        this.m_protocolWizPg = new FocusingWizardPage((Component)((Object)this.m_protocolWizPan), this.m_netStrings.getString("SNWProtTle"));
        this.m_theWizard.addPage(this.m_protocolWizPg, this.m_connectWizPg);
        this.m_protocolWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_protocolWizPg.setEnabled(true);
        this.m_protocolWizPg.setVisible(true);
        this.m_TCPWizPan = new TCPWizardPanel(this.m_netStrings);
        this.m_TCPWizPg = new FocusingWizardPage((Component)((Object)this.m_TCPWizPan), new String("TCP LWContainer"));
        this.m_theWizard.addPage(this.m_TCPWizPg, this.m_connectWizPg);
        this.m_TCPWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_TCPWizPg.setEnabled(false);
        this.m_TCPWizPg.setVisible(false);
        this.m_TCPSWizPan = new TCPSWizardPanel(this.m_netStrings);
        this.m_TCPSWizPg = new FocusingWizardPage((Component)((Object)this.m_TCPSWizPan), new String("TCPS LWContainer"));
        this.m_theWizard.addPage(this.m_TCPSWizPg, this.m_connectWizPg);
        this.m_TCPSWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_TCPSWizPg.setEnabled(false);
        this.m_TCPSWizPg.setVisible(false);
        this.m_SPXWizPan = new SPXWizardPanel(this.m_netStrings);
        this.m_SPXWizPg = new FocusingWizardPage((Component)((Object)this.m_SPXWizPan), new String("SPX LWContainer"));
        this.m_theWizard.addPage(this.m_SPXWizPg, this.m_connectWizPg);
        this.m_SPXWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_SPXWizPg.setEnabled(false);
        this.m_SPXWizPg.setVisible(false);
        this.m_NMPWizPan = new NMPWizardPanel(this.m_netStrings);
        this.m_NMPWizPg = new FocusingWizardPage((Component)((Object)this.m_NMPWizPan), new String("NMP LWContainer"));
        this.m_theWizard.addPage(this.m_NMPWizPg, this.m_connectWizPg);
        this.m_NMPWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_NMPWizPg.setEnabled(false);
        this.m_NMPWizPg.setVisible(false);
        this.m_BEQWizPan = new BEQWizardPanel(this.m_netStrings);
        this.m_BEQWizPg = new FocusingWizardPage((Component)((Object)this.m_BEQWizPan), new String("BEQ LWContainer"));
        this.m_theWizard.addPage(this.m_BEQWizPg, this.m_connectWizPg);
        this.m_BEQWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_BEQWizPg.setEnabled(false);
        this.m_BEQWizPg.setVisible(false);
        this.m_IPCWizPan = new IPCWizardPanel(this.m_netStrings);
        this.m_IPCWizPg = new FocusingWizardPage((Component)((Object)this.m_IPCWizPan), new String("IPC LWContainer"));
        this.m_theWizard.addPage(this.m_IPCWizPg, this.m_connectWizPg);
        this.m_IPCWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_IPCWizPg.setEnabled(false);
        this.m_IPCWizPg.setVisible(false);
        this.m_SIDWizPan = new SIDWizardPanel(this.m_netStrings);
        this.m_SIDWizPg = new FocusingWizardPage((Component)((Object)this.m_SIDWizPan), this.m_netStrings.getString("SNWSIDTle"));
        this.m_theWizard.addPage(this.m_SIDWizPg, this.m_connectWizPg);
        this.m_SIDWizPg.addWizardValidateListener((WizardValidateListener)this);
        this.m_SIDWizPg.setEnabled(true);
        this.m_SIDWizPg.setVisible(true);
    }

    private void conditionalExit(int n) {
    }

    private class FocusingWizardPage
    extends WizardPage {
        public FocusingWizardPage(Component component, String string) {
            super(component, string);
            ServiceWizard.this = ServiceWizard.this;
        }

        public Component getInitialFocus() {
            return ((GenericWizardPanel)((Object)this.getContent())).getFocusComponent();
        }
    }
}

