/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.servicewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addr.TCPSAddress;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.servicewizard.EditTextField;
import oracle.net.asst.servicewizard.GenericWizardPanel;
import oracle.net.asst.uniword.UniWordWrapper;

public class TCPSWizardPanel
extends GenericWizardPanel
implements KeyListener {
    public static final String DEFAULT_PORT = new String("1521");
    private EditTextField m_hostField;
    private EditTextField m_portField;

    public TCPSWizardPanel(NetStrings netStrings) {
        super(netStrings);
        this.setImage("images/ProtocolInfo.gif");
        this.m_contentPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        LWLabel lWLabel = new LWLabel(this.m_netStrings.getString("SNWTCPSPanTitle"));
        TextWrapper textWrapper = UniWordWrapper.getTextWrapper();
        MultiLineLabel multiLineLabel = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWTCPPanHostMsg"));
        multiLineLabel.setAlignment(1);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(textWrapper, this.m_netStrings.getString("SNWTCPPanPortMsg"));
        multiLineLabel2.setAlignment(1);
        LWLabel lWLabel2 = new LWLabel(this.m_netStrings.getString("SNWTCPPanHostLbl"));
        LWLabel lWLabel3 = new LWLabel(this.m_netStrings.getString("SNWTCPPanPortLbl"));
        this.m_hostField = new EditTextField("");
        this.m_portField = new EditTextField(DEFAULT_PORT);
        ((Component)((Object)this.m_hostField)).addKeyListener(this);
        ((Component)((Object)this.m_portField)).addKeyListener(this);
        this.m_contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_contentPanel.add((Component)lWLabel, gridBagConstraints);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.m_contentPanel.add((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        multiLineLabel2.setPreferredAspectRatio(4.5f);
        this.m_contentPanel.add((Component)multiLineLabel2, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        this.m_contentPanel.add((Component)lWLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.m_contentPanel.add((Component)lWLabel3, gridBagConstraints);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.m_contentPanel.add((Component)((Object)this.m_hostField), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.m_contentPanel.add((Component)((Object)this.m_portField), gridBagConstraints);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        char c = keyEvent.getKeyChar();
        if (component.equals(this.m_portField)) {
            if (c == '\b') {
                return;
            }
            if (Character.isDigit(c)) {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
        if (component.equals(this.m_hostField)) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                return;
            }
            if (c == '.') {
                return;
            }
            if (c == '\b') {
                return;
            }
            keyEvent.setKeyChar('\u0000');
        }
    }

    public boolean areDataValid() {
        String string = this.m_hostField.getText();
        String string2 = this.m_portField.getText();
        if (string.equals("")) {
            return false;
        }
        try {
            int n = Integer.parseInt(string2);
            if (n < 0 || n > 65536) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public Component getFocusComponent() {
        return this.m_hostField;
    }

    public void setParams(Address address) {
        if (address != null) {
            this.m_hostField.setText(address._getParameter("HOST"));
            this.m_portField.setText(address._getParameter("PORT"));
            return;
        }
        this.m_hostField.setText("");
        this.m_portField.setText(DEFAULT_PORT);
    }

    public Address getAddress() throws CreateAddressException {
        AddressFactory addressFactory = AddressFactory.getFactory();
        String string = "(ADDRESS=(PROTOCOL=" + TCPSAddress.TCPS_PROTOCOL + ")" + "(HOST=" + this.m_hostField.getText() + ")" + "(PORT=" + this.m_portField.getText() + "))";
        return addressFactory.createAddress(string);
    }
}

