/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.dataStore;

import java.util.Vector;
import oracle.net.common.NetGetEnv;
import oracle.net.common.dataStore.DataStoreException;
import oracle.net.common.dataStore.FileDataStore;
import oracle.net.common.dataStore.NetServiceHandler;
import oracle.net.common.netObject.NetObject;
import oracle.net.common.netObject.NetService;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.SOExceptionConfig;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileNetServiceHandler
extends NetServiceHandler {
    private static final String netServiceFileBase = "tnsnames.ora";
    private Config config;
    private FileDataStore fds;

    FileNetServiceHandler(FileDataStore fileDataStore) throws DataStoreException {
        super(true);
        this.fds = fileDataStore;
        try {
            this.config = new Config(NetGetEnv.getOracleHome(), 1, new String[]{null, null});
            this.config.setFilename(1, String.valueOf(fileDataStore.getAdminDir()) + netServiceFileBase);
        }
        catch (ConfigException configException) {
            throw new DataStoreException(configException);
        }
        this.config.netConfigUsesLDAP(false);
    }

    public void save() throws DataStoreException {
        this.config.setFilename(1, String.valueOf(this.fds.getAdminDir()) + netServiceFileBase);
        if (!this.removeLog.isEmpty()) {
            try {
                int n = this.removeLog.size();
                int n2 = 0;
                while (n2 < n) {
                    ServiceAlias.delete((Config)this.config, (String)this.removeLog.elementAt(n2).toString());
                    ++n2;
                }
            }
            catch (Exception exception) {
                throw new DataStoreException("Exception while saving ServiceAlias to: " + this.fds.getAdminDir() + netServiceFileBase);
            }
        }
        if (!this.changeLog.isEmpty()) {
            try {
                ServiceAlias serviceAlias = null;
                SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
                Vector<SchemaObjectConfig> vector = new Vector<SchemaObjectConfig>();
                int[] nArray = new int[]{2, 3};
                NetService netService = null;
                int n = this.changeLog.size();
                int n3 = 0;
                while (n3 < n) {
                    String string = this.changeLog.elementAt(n3).toString();
                    netService = (NetService)this.table.get(string);
                    if (netService == null) {
                        throw new DataStoreException("Exception saving NetService, " + string + " to: " + this.fds.getAdminDir() + netServiceFileBase + ". Internal data error: elem not found");
                    }
                    serviceAlias = new ServiceAlias(this.config, string);
                    vector.removeAllElements();
                    vector.addElement(schemaObjectConfigFactory.create(netService.toDescriptionString(), string, nArray));
                    serviceAlias.setEndpoints(vector);
                    serviceAlias.save(this.config, true);
                    ++n3;
                }
                this.changeLog.removeAllElements();
                this.removeLog.removeAllElements();
                return;
            }
            catch (Exception exception) {
                throw new DataStoreException("Exception while saving NetService to: " + this.fds.getAdminDir() + netServiceFileBase + ". " + exception.getMessage());
            }
        }
    }

    public void load() throws DataStoreException {
        this.table.clear();
        this.changeLog.removeAllElements();
        this.removeLog.removeAllElements();
        try {
            String[] stringArray = ServiceAlias.enum((Config)this.config, null, (boolean)false);
            int n = 0;
            while (n < stringArray.length) {
                this.table.put(stringArray[n], "NOT_LOADED");
                ++n;
            }
            return;
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    protected NetObject getElementFromDataStore(String string) throws DataStoreException {
        try {
            ServiceAlias serviceAlias = new ServiceAlias(this.config, string);
            return new NetService("(" + string + "=" + serviceAlias.toString() + ")");
        }
        catch (ServiceAliasException serviceAliasException) {
            if (serviceAliasException.errno == 8 && ((SOExceptionConfig)serviceAliasException.source).errno == 4) {
                throw new DataStoreException(4);
            }
            throw new DataStoreException(serviceAliasException);
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }

    public String[] enumDomains() throws DataStoreException {
        try {
            return ServiceAlias.enumDomains((Config)this.config);
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }

    public String[] enum(String string) throws DataStoreException {
        try {
            if (string.equals(".")) {
                return ServiceAlias.enum((Config)this.config, (String)ServiceAlias.NULL_DOMAIN, (boolean)false);
            }
            return ServiceAlias.enum((Config)this.config, (String)string, (boolean)false);
        }
        catch (ServiceAliasException serviceAliasException) {
            throw new DataStoreException(serviceAliasException);
        }
    }
}

