/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common.netObject;

import oracle.net.common.netObject.AttributeException;
import oracle.net.common.netObject.AttributeList;
import oracle.net.common.netObject.NetObjectException;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public final class ConnectData {
    private String cdataRemainder;
    private boolean supported = true;
    private boolean backCompat = false;
    private AttributeList attribList = new AttributeList();
    private NVNavigator nvnavigator = new NVNavigator();

    public ConnectData(NVPair nVPair) throws NetObjectException {
        nVPair = this.attribList.findPair(nVPair, "CONNECT_DATA");
        if (nVPair == null) {
            throw new NetObjectException("ConnectData.ConnectData(): No Connect_Data information found.");
        }
        this.validatePair(nVPair);
        try {
            NVPair nVPair2 = this.attribList.findPair(nVPair, "INSTANCE_NAME");
            if (nVPair2 != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "HANDLER_NAME")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "RDB_DATABASE")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "ORACLE_HOME")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "GLOBAL_NAME")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "SRVR")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "SERVICE_NAME")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
            if ((nVPair2 = this.attribList.findPair(nVPair, "SID")) != null) {
                this.attribList.addAttrib(nVPair2);
            }
        }
        catch (AttributeException attributeException) {
            throw new NetObjectException("AddressList.<init>: Unable to create addressList." + attributeException);
        }
        this.cdataRemainder = this.readAdditionalConnectData(nVPair);
        this.backCompat = this.checkBackCompat();
    }

    public boolean isBackCompat() {
        return this.backCompat;
    }

    public void setBackCompat(boolean bl) {
        this.backCompat = bl;
    }

    public String toNVString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(CONNECT_DATA=");
        try {
            if (this.backCompat || !this.supported) {
                if (this.attribList.contains("SID")) {
                    stringBuffer.append(this.attribList.toNVString("SID"));
                }
            } else {
                if (this.attribList.contains("SERVICE_NAME")) {
                    stringBuffer.append(this.attribList.toNVString("SERVICE_NAME"));
                }
                if (this.attribList.contains("HANDLER_NAME")) {
                    stringBuffer.append(this.attribList.toNVString("HANDLER_NAME"));
                }
                if (this.attribList.contains("INSTANCE_NAME")) {
                    stringBuffer.append(this.attribList.toNVString("INSTANCE_NAME"));
                }
            }
            if (this.attribList.contains("GLOBAL_NAME")) {
                stringBuffer.append(this.attribList.toNVString("GLOBAL_NAME"));
            }
            if (this.attribList.contains("ORACLE_HOME")) {
                stringBuffer.append(this.attribList.toNVString("ORACLE_HOME"));
            }
            if (this.attribList.contains("RDB_DATABASE")) {
                stringBuffer.append(this.attribList.toNVString("RDB_DATABASE"));
            }
            if (this.attribList.contains("SRVR")) {
                stringBuffer.append(this.attribList.toNVString("SRVR"));
            }
        }
        catch (AttributeException attributeException) {
            System.err.println(attributeException);
        }
        stringBuffer.append(this.cdataRemainder);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setSID(String string) throws AttributeException {
        if (this.attribList.contains("SID")) {
            this.attribList.setValue("SID", string);
            return;
        }
        this.attribList.addAttrib("SID", string);
    }

    public String getSID() {
        try {
            return this.attribList.getValue("SID");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setSRVR(String string) throws AttributeException {
        if (this.attribList.contains("SRVR")) {
            this.attribList.setValue("SRVR", string);
            return;
        }
        this.attribList.addAttrib("SRVR", string);
    }

    public String getSRVR() {
        try {
            return this.attribList.getValue("SRVR");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setSERVICE_NAME(String string) throws AttributeException {
        if (this.attribList.contains("SERVICE_NAME")) {
            this.attribList.setValue("SERVICE_NAME", string);
            return;
        }
        this.attribList.addAttrib("SERVICE_NAME", string);
    }

    public String getSERVICE_NAME() {
        try {
            return this.attribList.getValue("SERVICE_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setINSTANCE_NAME(String string) throws AttributeException {
        if (this.attribList.contains("INSTANCE_NAME")) {
            this.attribList.setValue("INSTANCE_NAME", string);
            return;
        }
        this.attribList.addAttrib("INSTANCE_NAME", string);
    }

    public String getINSTANCE_NAME() {
        try {
            return this.attribList.getValue("INSTANCE_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setHANDLER_NAME(String string) throws AttributeException {
        if (this.attribList.contains("HANDLER_NAME")) {
            this.attribList.setValue("HANDLER_NAME", string);
            return;
        }
        this.attribList.addAttrib("HANDLER_NAME", string);
    }

    public String getHANDLER_NAME() {
        try {
            return this.attribList.getValue("HANDLER_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setRDB_DATABASE(String string) throws AttributeException {
        if (this.attribList.contains("RDB_DATABASE")) {
            this.attribList.setValue("RDB_DATABASE", string);
            return;
        }
        this.attribList.addAttrib("RDB_DATABASE", string);
    }

    public String getRDB_DATABASE() {
        try {
            return this.attribList.getValue("RDB_DATABASE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setORACLE_HOME(String string) throws AttributeException {
        if (this.attribList.contains("ORACLE_HOME")) {
            this.attribList.setValue("ORACLE_HOME", string);
            return;
        }
        this.attribList.addAttrib("ORACLE_HOME", string);
    }

    public String getORACLE_HOME() {
        try {
            return this.attribList.getValue("ORACLE_HOME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setGLOBAL_NAME(String string) throws AttributeException {
        if (this.attribList.contains("GLOBAL_NAME")) {
            this.attribList.setValue("GLOBAL_NAME", string);
            return;
        }
        this.attribList.addAttrib("GLOBAL_NAME", string);
    }

    public String getGLOBAL_NAME() {
        try {
            return this.attribList.getValue("GLOBAL_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public boolean isSupported() {
        return this.supported;
    }

    private boolean checkBackCompat() {
        if (this.attribList.contains("SID")) {
            if (this.attribList.contains("SERVICE_NAME")) {
                this.supported = false;
                return false;
            }
            return true;
        }
        return false;
    }

    private void validatePair(NVPair nVPair) throws NetObjectException {
        if (this.attribList.findPair(nVPair, "SID") == null && this.attribList.findPair(nVPair, "SERVICE_NAME") == null) {
            throw new NetObjectException("ConnectData.validatePair(): No SID or SERVICE_NAME information in CONNECT_DATA");
        }
    }

    private String readAdditionalConnectData(NVPair nVPair) {
        String string = "";
        int n = 0;
        while (n < nVPair.getListSize()) {
            NVPair nVPair2 = nVPair.getListElement(n);
            String string2 = nVPair2.getName().toUpperCase();
            if (!(string2.equals("SID") || string2.equals("SERVICE_NAME") || string2.equals("HANDLER_NAME") || string2.equals("INSTANCE_NAME") || string2.equals("GLOBAL_NAME") || string2.equals("ORACLE_HOME") || string2.equals("RDB_DATABASE") || string2.equals("SRVR"))) {
                string = String.valueOf(string) + nVPair2.toString();
            }
            ++n;
        }
        return string;
    }
}

