/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.io.PrintStream;
import java.util.Vector;

public final class NVPair {
    public static int RHS_NONE;
    public static int RHS_ATOM;
    public static int RHS_LIST;
    public static int LIST_REGULAR;
    public static int LIST_COMMASEP;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    private String _linesep = System.getProperty("line.separator");

    public NVPair(String string) {
        this._name = string;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String string, String string2) {
        this(string);
        this._rhsType = RHS_ATOM;
        this._atom = string2;
        this._list = null;
    }

    public NVPair(String string, NVPair nVPair) {
        this(string);
        this.addListElement(nVPair);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public NVPair getParent() {
        return this._parent;
    }

    private void _setParent(NVPair nVPair) {
        this._parent = nVPair;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public int getListType() {
        return this._listType;
    }

    public void setListType(int n) {
        this._listType = n;
    }

    public String getAtom() {
        return this._atom;
    }

    public void setAtom(String string) {
        this._rhsType = RHS_ATOM;
        this._atom = string;
        this._list = null;
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public NVPair getListElement(int n) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(n);
    }

    public void addListElement(NVPair nVPair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(nVPair);
        nVPair._parent = this;
    }

    public void removeListElement(int n) {
        if (this._list != null) {
            this._list.removeElementAt(n);
            if ((this._list == null ? 0 : this._list.size()) == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    private String space(int n) {
        String string = new String("");
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    public String trimValueToString() {
        String string = this.valueToString().trim();
        return string.substring(1, string.length() - 1);
    }

    public String valueToString() {
        String string;
        block4: {
            block5: {
                block3: {
                    string = "";
                    if (this._rhsType != RHS_ATOM) break block3;
                    string = String.valueOf(string) + this._atom;
                    break block4;
                }
                if (this._rhsType != RHS_LIST) break block4;
                if (this._listType != LIST_REGULAR) break block5;
                int n = 0;
                while (n < (this._list == null ? 0 : this._list.size())) {
                    string = String.valueOf(string) + (this._list == null ? null : (NVPair)this._list.elementAt(n)).toString();
                    ++n;
                }
                break block4;
            }
            if (this._listType != LIST_COMMASEP) break block4;
            int n = 0;
            while (n < (this._list == null ? 0 : this._list.size())) {
                NVPair nVPair = this._list == null ? null : (NVPair)this._list.elementAt(n);
                string = String.valueOf(string) + nVPair._name;
                if (n != (this._list == null ? 0 : this._list.size()) - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
        }
        return string;
    }

    public String toString() {
        String string = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            string = String.valueOf(string) + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                int n = 0;
                while (n < (this._list == null ? 0 : this._list.size())) {
                    string = String.valueOf(string) + (this._list == null ? null : (NVPair)this._list.elementAt(n)).toString();
                    ++n;
                }
            } else if (this._listType == LIST_COMMASEP) {
                string = String.valueOf(string) + " (";
                int n = 0;
                while (n < (this._list == null ? 0 : this._list.size())) {
                    NVPair nVPair = this._list == null ? null : (NVPair)this._list.elementAt(n);
                    string = String.valueOf(string) + nVPair._name;
                    if (n != (this._list == null ? 0 : this._list.size()) - 1) {
                        string = String.valueOf(string) + ", ";
                    }
                    ++n;
                }
                string = String.valueOf(string) + ")";
            }
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public String toString(int n, boolean bl) {
        String string = "";
        String string2 = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + this.space(n * 2) + "(" + this._name + " = " : String.valueOf(string) + this.space(n * 2) + "(" + this._name + " =" + this._linesep;
                int n2 = 0;
                while (n2 < (this._list == null ? 0 : this._list.size())) {
                    string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + (this._list == null ? null : (NVPair)this._list.elementAt(n2)).toString(n + 1, false) : String.valueOf(string) + (this._list == null ? null : (NVPair)this._list.elementAt(n2)).toString(n + 1, true);
                    ++n2;
                }
                string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + ")" + this._linesep : (n == 0 ? String.valueOf(string) + ")" : (n == 1 ? String.valueOf(string) + this.space(n * 2) + ")" : String.valueOf(string) + this.space(n * 2) + ")" + this._linesep));
            } else if (this._listType == LIST_COMMASEP) {
                string = String.valueOf(string) + "(" + this._name + "=" + " (";
                int n3 = 0;
                while (n3 < (this._list == null ? 0 : this._list.size())) {
                    NVPair nVPair = this._list == null ? null : (NVPair)this._list.elementAt(n3);
                    string = String.valueOf(string) + nVPair._name;
                    if (n3 != (this._list == null ? 0 : this._list.size()) - 1) {
                        string = String.valueOf(string) + ", ";
                    }
                    ++n3;
                }
                string = String.valueOf(string) + ")" + ")";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (n == 0) {
                if (string2.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    string = String.valueOf(string) + "(" + this._atom + ")";
                } else {
                    string = String.valueOf(string) + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (string2.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                string = String.valueOf(string) + this._atom + this._linesep;
            } else if (!bl) {
                string = String.valueOf(string) + "(" + this._name + " = " + this._atom + ")";
            } else {
                string = String.valueOf(string) + this.space(n * 2) + "(" + this._name + " = " + this._atom + ")";
                string = String.valueOf(string) + this._linesep;
            }
        }
        return string;
    }

    public String modifyCommentString(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\\': {
                    if (string.charAt(n + 1) != '(' && string.charAt(n + 1) != '=' && string.charAt(n + 1) != ')' && string.charAt(n + 1) != ',' && string.charAt(n + 1) != '\\') break;
                }
            }
            int n2 = ++n;
            ++n;
            string2 = String.valueOf(string2) + string.charAt(n2);
        }
        return string2;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintStream printStream) {
        if (this._rhsType == RHS_ATOM) {
            printStream.println("          (" + this._name + " = " + this._atom + ")");
            return;
        }
        if (this._rhsType == RHS_LIST) {
            int n = 0;
            while (n < (this._list == null ? 0 : this._list.size())) {
                (this._list == null ? null : (NVPair)this._list.elementAt(n)).println(printStream);
                ++n;
            }
        }
    }

    static {
        RHS_ATOM = 1;
        RHS_LIST = 2;
        LIST_REGULAR = 3;
        LIST_COMMASEP = 4;
    }
}

