/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import oracle.net.util.CommandEvent;
import oracle.net.util.CommandEventMulticaster;
import oracle.net.util.CommandListener;
import oracle.net.util.ICommand;
import oracle.net.util.ThreadedCommandPool;

public abstract class Command
implements ICommand,
Runnable {
    private static ThreadedCommandPool m_commandPool = null;
    private CommandListener m_listeners = null;

    public Command(CommandListener listener) {
        if (listener != null) {
            this.addCommandListener(listener);
        }
    }

    public synchronized void addCommandListener(CommandListener listener) {
        this.m_listeners = CommandEventMulticaster.add(this.m_listeners, listener);
    }

    public synchronized void removeCommandListener(CommandListener listener) {
        this.m_listeners = CommandEventMulticaster.remove(this.m_listeners, listener);
    }

    public abstract void execute();

    public void executeThreaded() {
        if (m_commandPool == null) {
            m_commandPool = new ThreadedCommandPool();
        }
        m_commandPool.submit(this);
    }

    public void executeThreaded(String threadName) {
        m_commandPool.submit((ICommand)this, threadName);
    }

    public void run() {
        this.execute();
    }

    public void onCommandExecuted(CommandEvent evt) {
        if (this.m_listeners != null) {
            this.m_listeners.commandExecuted(evt);
        }
    }

    public void onCommandFailed(CommandEvent evt) {
        if (this.m_listeners != null) {
            this.m_listeners.commandFailed(evt);
        }
    }
}

