/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import oracle.net.util.CommandThreadAdvise;
import oracle.net.util.ICommand;

class CommandThread
extends Thread {
    String m_threadName;
    boolean m_done = false;
    CommandThreadAdvise m_advise = null;
    ICommand m_command = null;

    protected CommandThread(CommandThreadAdvise advise) {
        super("virgin CommandThread");
        this.m_advise = advise;
        this.start();
    }

    protected void execute(ICommand command, String threadName) {
        this.m_command = command;
        this.m_threadName = threadName;
        this.resume();
    }

    protected void done() {
        this.m_done = true;
        this.resume();
    }

    public void run() {
        while (!this.m_done) {
            if (this.m_command == null) {
                this.suspend();
                continue;
            }
            if (this.m_threadName != null) {
                this.setName(this.m_threadName);
            }
            try {
                this.m_command.execute();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_threadName = null;
            this.setName("Idle CommandThread");
            ICommand executedCommand = this.m_command;
            this.m_command = null;
            this.m_advise.commandExecuted(this, executedCommand);
        }
    }
}

