/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.util.Vector;
import oracle.net.util.ICommand;
import oracle.net.util.ThreadedCommandPool;

public class ThreadedCommandQueue {
    private boolean m_done = false;
    private Vector m_commandQueue = new Vector();
    private ThreadedCommandPool m_commandPool = null;
    private boolean m_executingCommand = false;

    public ThreadedCommandQueue() {
    }

    public ThreadedCommandQueue(String threadName) {
    }

    public synchronized void queueCommand(ICommand cmd) {
        this.queueCommand(cmd, 5);
    }

    public synchronized void queueCommand(ICommand cmd, int priority) {
        if (this.m_commandPool == null) {
            this.m_commandPool = ThreadedCommandPool.getDefaultThreadedCommandPool();
        }
        this.m_commandQueue.addElement(new ThreadedCommandQueueCommand(cmd, priority));
        this.pumpQueue();
    }

    protected synchronized void pumpQueue() {
        if (!(this.m_done || this.m_executingCommand || this.m_commandQueue.isEmpty())) {
            this.m_executingCommand = true;
            ThreadedCommandQueueCommand cmd = (ThreadedCommandQueueCommand)this.m_commandQueue.firstElement();
            this.m_commandQueue.removeElementAt(0);
            this.m_commandPool.submit((ICommand)cmd, cmd.getPriority());
        }
    }

    public synchronized void done() {
        this.m_done = true;
    }

    public void execute(ICommand command) {
        try {
            command.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_executingCommand = false;
        this.pumpQueue();
    }

    class ThreadedCommandQueueCommand
    implements ICommand {
        private ICommand m_command = null;
        private int m_priority;

        protected ThreadedCommandQueueCommand(ICommand command, int priority) {
            this.m_command = command;
            this.m_priority = priority;
        }

        public void execute() {
            ThreadedCommandQueue.this.execute(this.m_command);
        }

        public int getPriority() {
            return this.m_priority;
        }

        public String toString() {
            return this.m_command.toString();
        }
    }
}

