/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util.encoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.encoders.CharacterDecoder;

public class BASE64Decoder
extends CharacterDecoder {
    private static final int BUFFSIZE = 256;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];
    byte[] m_encodedData = null;
    int m_numEncodedChars;

    int bytesPerAtom() {
        return 4;
    }

    int bytesPerLine() {
        return 72;
    }

    void decodeAtom(InputStream inStream, OutputStream outStream, int rem) throws IOException {
        throw new IOException("This can never happen");
    }

    public void decodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        int i;
        byte[] inbuff = new byte[256];
        this.decodeBegin();
        while (-1 != (i = inStream.read(inbuff, 0, 256))) {
            this.decodeData(outStream, inbuff, i);
        }
        this.decodeEnd(outStream);
    }

    public void decodeBegin() {
        this.m_encodedData = new byte[4];
        this.m_numEncodedChars = 0;
    }

    public void decodeData(OutputStream outStream, byte[] data, int length) throws IOException {
        int validBytes = 0;
        for (int i = 0; i < length; ++i) {
            this.m_encodedData[this.m_numEncodedChars] = pem_convert_array[data[i] & 0xFF];
            if (this.m_encodedData[this.m_numEncodedChars] != -1 || data[i] == 61) {
                ++this.m_numEncodedChars;
            }
            if (this.m_numEncodedChars != 4) continue;
            validBytes = 3;
            if (this.m_encodedData[3] == -1) {
                --validBytes;
                if (this.m_encodedData[2] == -1) {
                    --validBytes;
                }
            }
            this.m_encodedData[0] = (byte)((this.m_encodedData[0] & 0x3F) << 2 | (this.m_encodedData[1] & 0x30) >>> 4);
            this.m_encodedData[1] = (byte)((this.m_encodedData[1] & 0xF) << 4 | (this.m_encodedData[2] & 0x3C) >>> 2);
            this.m_encodedData[2] = (byte)((this.m_encodedData[2] & 3) << 6 | this.m_encodedData[3] & 0x3F);
            outStream.write(this.m_encodedData, 0, validBytes);
            this.m_encodedData[3] = 0;
            this.m_encodedData[2] = 0;
            this.m_encodedData[1] = 0;
            this.m_encodedData[0] = 0;
            this.m_numEncodedChars = 0;
        }
    }

    public void decodeEnd(OutputStream outStream) throws IOException {
    }

    static {
        for (int i = 0; i < 255; ++i) {
            BASE64Decoder.pem_convert_array[i] = -1;
        }
        for (int i = 0; i < pem_array.length; ++i) {
            BASE64Decoder.pem_convert_array[BASE64Decoder.pem_array[i]] = (byte)i;
        }
    }
}

