/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util.encoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.encoders.CharacterDecoder;

public class QuotedPrintableDecoder
extends CharacterDecoder {
    private static final byte[] hexToDecimalLookup = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int RAW = 1;
    private static final int EQUALS = 2;
    private static final int OCTET = 3;
    private static final int SOFTBREAK = 4;
    private static final int SPACE = 5;
    private byte m_ucOctet;
    private int m_state;
    private StringBuffer m_whitespace = new StringBuffer();
    private static final int BUFFSIZE = 256;

    int bytesPerAtom() {
        return 0;
    }

    int bytesPerLine() {
        return 78;
    }

    void decodeAtom(InputStream inStream, OutputStream outStream, int rem) throws IOException {
        throw new IOException("QuotedPrintableDecoder: No such thing as atom");
    }

    public void decodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        int i;
        byte[] inbuff = new byte[256];
        this.decodeBegin();
        while (-1 != (i = inStream.read(inbuff, 0, 256))) {
            this.decodeData(outStream, inbuff, i);
        }
        this.decodeEnd(outStream);
    }

    public void decodeBegin() {
        this.m_state = 1;
        this.m_whitespace.setLength(0);
    }

    public void decodeData(OutputStream outStream, byte[] data, int length) throws IOException {
        this.decodeByteArray(outStream, data, length);
    }

    public void decodeEnd(OutputStream outStream) throws IOException {
    }

    void decodeByteArray(OutputStream oStream, byte[] inbuff, int buffLength) throws IOException {
        int offset = 0;
        while (buffLength > 0) {
            switch (this.m_state) {
                case 1: {
                    int startingOffset = offset;
                    while (buffLength > 0 && inbuff[offset] != 61 && inbuff[offset] != 32 && inbuff[offset] != 9) {
                        ++offset;
                        --buffLength;
                    }
                    oStream.write(inbuff, startingOffset, offset - startingOffset);
                    if (buffLength > 0 && inbuff[offset] == 61) {
                        this.m_state = 2;
                        break;
                    }
                    if (buffLength <= 0 || inbuff[offset] != 32 && inbuff[offset] != 9) break;
                    --offset;
                    ++buffLength;
                    this.m_whitespace.setLength(0);
                    this.m_state = 5;
                    break;
                }
                case 2: {
                    if (inbuff[offset] == 13) {
                        this.m_state = 4;
                        break;
                    }
                    if (inbuff[offset] == 10) {
                        this.m_state = 1;
                        break;
                    }
                    this.m_state = 3;
                    this.m_ucOctet = inbuff[offset];
                    break;
                }
                case 4: {
                    if (inbuff[offset] == 10) {
                        this.m_state = 1;
                        break;
                    }
                    --offset;
                    ++buffLength;
                    break;
                }
                case 3: {
                    this.m_ucOctet = (byte)(hexToDecimalLookup[this.m_ucOctet] * 16 + hexToDecimalLookup[inbuff[offset]]);
                    oStream.write(this.m_ucOctet);
                    this.m_state = 1;
                    break;
                }
                case 5: {
                    if (inbuff[offset] == 32 || inbuff[offset] == 9) {
                        this.m_whitespace.append((char)inbuff[offset]);
                        break;
                    }
                    if (inbuff[offset] != 13) {
                        oStream.write(this.m_whitespace.toString().getBytes(), 0, this.m_whitespace.length());
                    }
                    if (inbuff[offset] == 61) {
                        this.m_state = 2;
                        break;
                    }
                    oStream.write(inbuff[offset]);
                    this.m_state = 1;
                    break;
                }
            }
            ++offset;
            --buffLength;
        }
    }
}

