/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util.encoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.encoders.CharacterEncoder;

public class UUEncoder
extends CharacterEncoder {
    private static char[] s_uu = new char[]{'`', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', ' '};
    private String m_bufferName;
    private int mode;
    private static final int UULINELEN = 45;
    private static final int MAXENCODELINELEN = 90;

    public UUEncoder() {
        this.m_bufferName = "encoder.buf";
        this.mode = 644;
    }

    public UUEncoder(String fname) {
        this.m_bufferName = fname;
        this.mode = 644;
    }

    public UUEncoder(String fname, int newMode) {
        this.m_bufferName = fname;
        this.mode = newMode;
    }

    int bytesPerAtom() {
        return 3;
    }

    int bytesPerLine() {
        return 45;
    }

    void encodeAtom(OutputStream outStream, byte[] data, int offset, int len) throws IOException {
        throw new IOException("This should never get called");
    }

    void encodeLinePrefix(OutputStream outStream, int length) throws IOException {
        outStream.write((length & 0x3F) + 32);
    }

    void encodeLineSuffix(OutputStream outStream) throws IOException {
        outStream.write(13);
        outStream.write(10);
    }

    void encodeBufferPrefix(OutputStream outStream) throws IOException {
        outStream.write(13);
        outStream.write(10);
        outStream.write(new String(String.valueOf(String.valueOf("begin ").concat(String.valueOf(this.mode))).concat(String.valueOf(" "))).getBytes());
        if (this.m_bufferName != null) {
            outStream.write(this.m_bufferName.getBytes());
            outStream.write(13);
            outStream.write(10);
        } else {
            outStream.write("encoder.bin".getBytes());
            outStream.write(13);
            outStream.write(10);
        }
        outStream.flush();
    }

    void encodeBufferSuffix(OutputStream outStream) throws IOException {
        outStream.write("`\r\nend\r\n".getBytes());
        outStream.flush();
    }

    public void encodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        int numBytes;
        byte[] tmpbuffer = new byte[45];
        this.encodeBufferPrefix(outStream);
        while ((numBytes = this.readFully(inStream, tmpbuffer)) != -1) {
            this.EncodeLine(outStream, tmpbuffer, numBytes);
            if (numBytes == 45) continue;
        }
        this.encodeBufferSuffix(outStream);
    }

    protected void EncodeLine(OutputStream outStream, byte[] pbuf, int numbytes) throws IOException {
        char c = s_uu[numbytes & 0x3F];
        outStream.write(c);
        for (int i = 0; i < numbytes; ++i) {
            byte b1 = pbuf[i];
            byte b2 = 0;
            byte b3 = 0;
            if (i < numbytes - 1) {
                b2 = pbuf[i + 1];
            }
            if (i < numbytes - 2) {
                b3 = pbuf[i + 2];
            }
            c = s_uu[b1 >>> 2 & 0x3F];
            outStream.write(c);
            c = s_uu[(b1 << 4 & 0x30 | b2 >>> 4 & 0xF) & 0x3F];
            outStream.write(c);
            if (++i >= numbytes) break;
            c = s_uu[(b2 << 2 & 0x3C | b3 >>> 6 & 3) & 0x3F];
            outStream.write(c);
            if (++i >= numbytes) break;
            c = s_uu[b3 & 0x3F];
            outStream.write(c);
        }
        outStream.write("\r\n".getBytes());
    }
}

