/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ber;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.IntRef;
import oracle.sumatra.net.ber.BERElement;
import oracle.sumatra.net.ber.BERException;

public class BERBoolean
extends BERElement {
    private boolean m_value;

    public BERBoolean(boolean bl) {
        super((byte)1);
        this.m_value = bl;
    }

    public BERBoolean(byte by, boolean bl) {
        super(by);
        this.m_value = bl;
    }

    public BERBoolean(InputStream inputStream, byte by, IntRef intRef) throws BERException {
        super(by);
        int n;
        BERElement.readDefLength(inputStream, intRef);
        try {
            n = inputStream.read();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (n == -1) {
            throw new BERException("Found end of input while parsing BER data");
        }
        byte by2 = (byte)n;
        this.m_value = by2 != 0;
        intRef.set(intRef.get() + 1);
    }

    public int getEncodedLength() {
        return 3;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getTag());
        BERElement.writeDefLength(outputStream, 1);
        outputStream.write(this.m_value ? 1 : 0);
    }

    public boolean getValue() {
        return this.m_value;
    }
}

