/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ber;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.IntRef;
import oracle.sumatra.net.ber.BERBoolean;
import oracle.sumatra.net.ber.BERConstruct;
import oracle.sumatra.net.ber.BEREnumerated;
import oracle.sumatra.net.ber.BERException;
import oracle.sumatra.net.ber.BERInteger;
import oracle.sumatra.net.ber.BEROctetString;
import oracle.sumatra.net.ber.BERSequence;
import oracle.sumatra.net.ber.BERSet;
import oracle.sumatra.net.ber.BERTag;

public abstract class BERElement {
    private byte m_tag;
    public static final byte UNIVERSAL = 0;
    public static final byte APPLICATION = 64;
    public static final byte CONTEXT = -128;
    public static final byte PRIVATE = -64;
    public static final byte PRIMITIVE = 0;
    public static final byte CONSTRUCTED = 32;
    public static final byte BOOLEAN = 1;
    public static final byte INTEGER = 2;
    public static final byte OCTETSTRING = 4;
    public static final byte NULL = 5;
    public static final byte ENUMERATED = 10;
    public static final byte NUMERICSTRING = 18;
    public static final byte PRINTABLESTRING = 19;
    public static final byte TELETEXSTRING = 20;
    public static final byte VIDEOTEXSTRING = 21;
    public static final byte IA5STRING = 22;
    public static final byte UTCTIME = 23;
    public static final byte VISIBLESTRING = 26;
    public static final byte GENERALSTRING = 27;
    public static final byte CHARACTERSTRING = 28;
    public static final byte UNDEFINED = -1;
    public static final byte SEQUENCE = 16;
    public static final byte SET = 17;
    protected static final String m_exceptionMsg = "Found end of input while parsing BER data";

    public BERElement() {
    }

    public BERElement(byte by) {
        this.m_tag = by;
    }

    public abstract int getEncodedLength();

    public abstract void write(OutputStream var1) throws IOException;

    protected static int readElementFactory(InputStream inputStream, BERConstruct bERConstruct) throws BERException {
        boolean bl;
        int n;
        IntRef intRef = new IntRef(0);
        BERElement bERElement = null;
        try {
            n = inputStream.read();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (n == -1) {
            throw new BERException(m_exceptionMsg);
        }
        byte by = (byte)n;
        byte by2 = (byte)(by & 0xC0);
        byte by3 = (byte)(by & 0x1F);
        boolean bl2 = bl = (by & 0x20) > 0;
        if (by2 == 0) {
            switch (by3) {
                case 1: {
                    bERElement = new BERBoolean(inputStream, by, intRef);
                    break;
                }
                case 2: {
                    bERElement = new BERInteger(inputStream, by, intRef);
                    break;
                }
                case 10: {
                    bERElement = new BEREnumerated(inputStream, by, intRef);
                    break;
                }
                case 4: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 26: 
                case 27: 
                case 28: {
                    bERElement = new BEROctetString(inputStream, by, intRef);
                    break;
                }
                case 16: {
                    bERElement = new BERSequence(inputStream, by, intRef);
                    break;
                }
                case 17: {
                    bERElement = new BERSet(inputStream, by, intRef);
                    break;
                }
                default: {
                    if (bl) {
                        bERElement = new BERTag(inputStream, by, intRef);
                        break;
                    }
                    int n2 = BERElement.readDefLength(inputStream, intRef);
                    try {
                        inputStream.skip(n2);
                    }
                    catch (IOException iOException) {
                        throw new BERException(m_exceptionMsg);
                    }
                    intRef.set(intRef.get() + n2);
                    break;
                }
            }
        } else {
            bERElement = new BERTag(inputStream, by, intRef);
        }
        if (bERElement != null) {
            bERConstruct.addChildElement(bERElement);
        }
        return 1 + intRef.get();
    }

    static int getDefLength(int n) {
        if (n < 128) {
            return 1;
        }
        if (n < 256) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        if (n < 0x1000000) {
            return 4;
        }
        return 5;
    }

    static int readDefLength(InputStream inputStream, IntRef intRef) throws BERException {
        int n;
        try {
            n = inputStream.read();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (n == -1) {
            throw new BERException(m_exceptionMsg);
        }
        int n2 = n;
        int n3 = 1;
        int n4 = n2;
        if ((n2 & 0x80) == 128) {
            int n5 = n2 & 0x7F;
            n3 += n5;
            n4 = 0;
            int n6 = 0;
            while (n6 < n5) {
                try {
                    n = inputStream.read();
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n == -1) {
                    throw new BERException(m_exceptionMsg);
                }
                n2 = (byte)n;
                n4 <<= 8;
                n4 |= (short)n2 & 0xFF;
                ++n6;
            }
        }
        intRef.set(n3);
        return n4;
    }

    static void writeDefLength(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write(n);
            return;
        }
        if (n < 256) {
            outputStream.write(129);
            outputStream.write(n & 0xFF);
            return;
        }
        if (n < 65536) {
            outputStream.write(130);
            outputStream.write((n & 0xFF00) >> 8);
            outputStream.write(n & 0xFF);
            return;
        }
        if (n < 0x1000000) {
            outputStream.write(131);
            outputStream.write((n & 0xFF0000) >> 16);
            outputStream.write((n & 0xFF00) >> 8);
            outputStream.write(n & 0xFF);
            return;
        }
        outputStream.write(132);
        outputStream.write((n & 0xFF000000) >> 24);
        outputStream.write((n & 0xFF0000) >> 16);
        outputStream.write((n & 0xFF00) >> 8);
        outputStream.write(n & 0xFF);
    }

    public void setTag(byte by) {
        this.m_tag = by;
    }

    public byte getTag() {
        return this.m_tag;
    }
}

