/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ldap;

import java.io.ByteArrayOutputStream;
import oracle.sumatra.net.ber.BEROctetString;
import oracle.sumatra.net.ber.BERSequence;
import oracle.sumatra.net.ber.BERSet;

public class LDAPAttribute {
    BERSequence m_sequence;
    private BEROctetString m_type;
    String m_attributeType;
    private String[] m_attributeValues;
    private ByteArrayOutputStream[] m_attributeNoUTF8Values;

    public LDAPAttribute(BERSequence bERSequence) {
        this.m_sequence = bERSequence;
        BEROctetString bEROctetString = (BEROctetString)bERSequence.getChildElement(0);
        this.m_attributeType = bEROctetString.getValue();
        BERSet bERSet = (BERSet)bERSequence.getChildElement(1);
        this.m_attributeValues = new String[bERSet.getChildElementCount()];
        this.m_attributeNoUTF8Values = new ByteArrayOutputStream[bERSet.getChildElementCount()];
        int n = 0;
        while (n < bERSet.getChildElementCount()) {
            this.m_attributeValues[n] = ((BEROctetString)bERSet.getChildElement(n)).getValue();
            this.m_attributeNoUTF8Values[n] = ((BEROctetString)bERSet.getChildElement(n)).getNoUTF8Value();
            ++n;
        }
    }

    public LDAPAttribute(String string) {
        this.m_sequence = new BERSequence();
        this.m_sequence.addChildElement(new BEROctetString(string));
    }

    public LDAPAttribute(String string, String string2) {
        this.m_sequence = new BERSequence();
        this.m_sequence.addChildElement(new BEROctetString(string));
        BERSet bERSet = new BERSet();
        this.m_sequence.addChildElement(bERSet);
        bERSet.addChildElement(new BEROctetString(string2));
    }

    public LDAPAttribute(String string, ByteArrayOutputStream byteArrayOutputStream) {
        this.m_sequence = new BERSequence();
        this.m_sequence.addChildElement(new BEROctetString(string));
        BERSet bERSet = new BERSet();
        this.m_sequence.addChildElement(bERSet);
        bERSet.addChildElement(new BEROctetString(byteArrayOutputStream));
    }

    public LDAPAttribute(String string, String[] stringArray) {
        this.m_sequence = new BERSequence();
        this.m_sequence.addChildElement(new BEROctetString(string));
        BERSet bERSet = new BERSet();
        this.m_sequence.addChildElement(bERSet);
        int n = 0;
        while (n < stringArray.length) {
            bERSet.addChildElement(new BEROctetString(stringArray[n]));
            ++n;
        }
    }

    public String getType() {
        return this.m_attributeType;
    }

    public String[] getValues() {
        return this.m_attributeValues;
    }

    public ByteArrayOutputStream[] getNoUTF8Values() {
        return this.m_attributeNoUTF8Values;
    }

    public BERSequence getBERSequence() {
        return this.m_sequence;
    }
}

