/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ldap;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.util.Command;
import oracle.net.util.CommandEvent;
import oracle.net.util.CommandListener;
import oracle.net.util.NetCommand;
import oracle.net.util.NetException;
import oracle.sumatra.net.ldap.ILDAPRequest;
import oracle.sumatra.net.ldap.LDAPAbandonRequest;

public class LDAPCommand
extends Command
implements NetCommand {
    private OutputStream m_strm;
    private ILDAPRequest m_request;
    private Object m_userParm;
    private NetException m_error;
    private int m_state;

    public LDAPCommand(ILDAPRequest iLDAPRequest, OutputStream outputStream, CommandListener commandListener, Object object) {
        super(commandListener);
        this.m_request = iLDAPRequest;
        this.m_strm = outputStream;
        this.m_userParm = object;
    }

    public LDAPCommand abandon() {
        LDAPCommand lDAPCommand = null;
        if (this.getState() != 4 && this.getState() != 3) {
            lDAPCommand = new LDAPCommand(new LDAPAbandonRequest(this.m_request.getMsgId()), this.m_strm, null, null);
        }
        return lDAPCommand;
    }

    public ILDAPRequest getRequest() {
        return this.m_request;
    }

    public void execute() {
        try {
            this.m_request.write(this.m_strm);
            this.m_strm.flush();
            this.onCommandExecuted(new CommandEvent((Command)this));
            return;
        }
        catch (IOException iOException) {
            this.m_error = new NetException((Exception)iOException);
            this.onCommandFailed(new CommandEvent((Command)this));
            return;
        }
    }

    public boolean canCancel() {
        return this.getState() != 4 && this.getState() != 3;
    }

    public boolean cancel() {
        return this.abandon() != null;
    }

    public int getState() {
        return this.m_state;
    }

    public NetException getError() {
        return this.m_error;
    }

    public Object getUserParm() {
        return this.m_userParm;
    }
}

