/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ldap;

import oracle.sumatra.net.ber.BERBoolean;
import oracle.sumatra.net.ber.BEREnumerated;
import oracle.sumatra.net.ber.BERInteger;
import oracle.sumatra.net.ber.BERModule;
import oracle.sumatra.net.ber.BEROctetString;
import oracle.sumatra.net.ber.BERSequence;
import oracle.sumatra.net.ber.BERTag;
import oracle.sumatra.net.ldap.ILDAPFilter;
import oracle.sumatra.net.ldap.ILDAPRequest;
import oracle.sumatra.net.ldap.LDAPCommand;
import oracle.sumatra.net.ldap.LDAPEvent;
import oracle.sumatra.net.ldap.LDAPMessage;
import oracle.sumatra.net.ldap.LDAPSearchEntry;
import oracle.sumatra.net.ldap.LDAPSearchResponse;
import oracle.sumatra.net.ldap.LDAPSession;

public class LDAPSearchRequest
extends LDAPMessage
implements ILDAPRequest {
    public static final int BASE_OBJECT = 0;
    public static final int SINGLE_LEVEL = 1;
    public static final int WHOLE_SUBTREE = 2;
    public static final int NEVER_DEREF_ALIASES = 0;
    public static final int DEREF_IN_SEARCHING = 1;
    public static final int DEREF_FINDING_BASE_OBJ = 2;
    public static final int DEREF_ALWAYS = 3;
    public static final byte APPLICATION = 3;

    public LDAPSearchRequest(String string, int n, int n2, int n3, int n4, boolean bl, ILDAPFilter iLDAPFilter, String[] stringArray) {
        BERSequence bERSequence = new BERSequence(99);
        bERSequence.addChildElement(new BEROctetString(string));
        bERSequence.addChildElement(new BEREnumerated(n));
        bERSequence.addChildElement(new BEREnumerated(n2));
        bERSequence.addChildElement(new BERInteger(n3));
        bERSequence.addChildElement(new BERInteger(n4));
        bERSequence.addChildElement(new BERBoolean(bl));
        bERSequence.addChildElement(iLDAPFilter.getBERElement());
        BERSequence bERSequence2 = new BERSequence();
        bERSequence.addChildElement(bERSequence2);
        int n5 = 0;
        while (n5 < stringArray.length) {
            bERSequence2.addChildElement(new BEROctetString(stringArray[n5]));
            ++n5;
        }
        this.setProtocolOp(bERSequence);
    }

    public void commandFailed(LDAPSession lDAPSession, LDAPCommand lDAPCommand, ILDAPRequest iLDAPRequest) {
        if (lDAPSession.m_listeners != null) {
            lDAPSession.m_listeners.searched(new LDAPEvent(lDAPSession, new LDAPSearchResponse(80, "", lDAPCommand.getError().toString(), iLDAPRequest.getMsgId()), lDAPCommand.getUserParm()));
        }
    }

    public void onResponse(LDAPSession lDAPSession, BERModule bERModule, LDAPCommand lDAPCommand) {
        if (lDAPSession.m_listeners != null) {
            BERSequence bERSequence = (BERSequence)bERModule.getChildElement(0);
            BERTag bERTag = (BERTag)bERSequence.getChildElement(1);
            switch (bERTag.getTagNumber()) {
                case 5: {
                    lDAPSession.m_listeners.searched(new LDAPEvent(lDAPSession, new LDAPSearchResponse(bERModule), lDAPCommand.getUserParm()));
                    return;
                }
                case 4: {
                    lDAPSession.m_listeners.searchFoundEntry(new LDAPEvent(lDAPSession, new LDAPSearchEntry(bERModule), lDAPCommand.getUserParm()));
                    return;
                }
            }
        }
    }
}

