/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ldap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import oracle.net.util.Command;
import oracle.net.util.CommandEvent;
import oracle.net.util.CommandListener;
import oracle.net.util.ICommand;
import oracle.net.util.ThreadedCommandPool;
import oracle.net.util.ThreadedCommandQueue;
import oracle.sumatra.net.ber.BERInteger;
import oracle.sumatra.net.ber.BERModule;
import oracle.sumatra.net.ber.BERSequence;
import oracle.sumatra.net.ber.BERTag;
import oracle.sumatra.net.ldap.ILDAPRequest;
import oracle.sumatra.net.ldap.IParseResponseAdvise;
import oracle.sumatra.net.ldap.LDAPAbandonRequest;
import oracle.sumatra.net.ldap.LDAPBindRequest;
import oracle.sumatra.net.ldap.LDAPCommand;
import oracle.sumatra.net.ldap.LDAPConnectCommand;
import oracle.sumatra.net.ldap.LDAPDisconnectCommand;
import oracle.sumatra.net.ldap.LDAPEvent;
import oracle.sumatra.net.ldap.LDAPEventMulticaster;
import oracle.sumatra.net.ldap.LDAPListener;
import oracle.sumatra.net.ldap.LDAPUnbindRequest;
import oracle.sumatra.net.ldap.ParseResponseCommand;

public class LDAPSession
implements CommandListener,
IParseResponseAdvise {
    protected LDAPListener m_listeners;
    private Socket m_socket;
    private Hashtable m_sentCommands = new Hashtable();
    private BufferedOutputStream m_ostrm;
    private ThreadedCommandQueue m_commandThread;
    private ThreadedCommandPool m_commandPool;
    private ParseResponseCommand m_parseCommand;
    private String m_host;
    private int m_port;
    private PropertyChangeSupport m_propertyChangeSupport;

    public LDAPSession() {
        this("host", 389);
    }

    public LDAPSession(String string) {
        this(string, 389);
    }

    public LDAPSession(String string, int n) {
        this.m_host = string;
        this.m_port = n;
        this.m_propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void setHost(String string) {
        String string2 = this.m_host;
        this.m_host = string;
        this.m_propertyChangeSupport.firePropertyChange("Host", string2, string);
    }

    public String getHost() {
        return this.m_host;
    }

    public void setPort(int n) {
        int n2 = this.m_port;
        this.m_port = n;
        this.m_propertyChangeSupport.firePropertyChange("Port", new Integer(n2), new Integer(n));
    }

    public int getPort() {
        return this.m_port;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addLDAPListener(LDAPListener lDAPListener) {
        this.m_listeners = LDAPEventMulticaster.add(this.m_listeners, lDAPListener);
    }

    public void removeLDAPListener(LDAPListener lDAPListener) {
        this.m_listeners = LDAPEventMulticaster.remove(this.m_listeners, lDAPListener);
    }

    public boolean isConnected() {
        return this.m_socket != null;
    }

    public void connect() {
        this.m_commandThread = new ThreadedCommandQueue();
        LDAPConnectCommand lDAPConnectCommand = new LDAPConnectCommand(this.m_host, this.m_port, this);
        this.m_commandThread.queueCommand((ICommand)lDAPConnectCommand);
    }

    public void disconnect() throws IOException {
        LDAPDisconnectCommand lDAPDisconnectCommand = new LDAPDisconnectCommand(this.m_socket, this);
        this.m_commandThread.queueCommand((ICommand)lDAPDisconnectCommand);
    }

    public LDAPCommand send(ILDAPRequest iLDAPRequest, Object object) throws IOException {
        if (iLDAPRequest instanceof LDAPBindRequest) {
            this.m_parseCommand = new ParseResponseCommand(new BufferedInputStream(this.m_socket.getInputStream()), this);
            if (this.m_commandPool == null) {
                this.m_commandPool = ThreadedCommandPool.getDefaultThreadedCommandPool();
            }
            this.m_commandPool.submit((ICommand)this.m_parseCommand);
            this.m_ostrm = new BufferedOutputStream(this.m_socket.getOutputStream());
        }
        LDAPCommand lDAPCommand = new LDAPCommand(iLDAPRequest, this.m_ostrm, this, object);
        if (!(iLDAPRequest instanceof LDAPUnbindRequest) && !(iLDAPRequest instanceof LDAPAbandonRequest)) {
            this.m_sentCommands.put(new Integer(iLDAPRequest.getMsgId()), lDAPCommand);
        }
        this.m_commandThread.queueCommand((ICommand)lDAPCommand);
        return lDAPCommand;
    }

    public void commandExecuted(CommandEvent commandEvent) {
        Command command = commandEvent.getCommandSource();
        if (command instanceof LDAPConnectCommand) {
            LDAPConnectCommand lDAPConnectCommand = (LDAPConnectCommand)command;
            this.m_socket = lDAPConnectCommand.getSocket();
            if (this.m_listeners != null) {
                this.m_listeners.connected(new LDAPEvent(this));
                return;
            }
        } else if (command instanceof LDAPDisconnectCommand) {
            if (this.m_commandThread != null) {
                this.m_commandThread.done();
                this.m_commandThread = null;
            }
            if (this.m_parseCommand != null) {
                this.m_parseCommand.done();
                this.m_parseCommand = null;
            }
            this.m_ostrm = null;
            this.m_socket = null;
        }
    }

    public void commandFailed(CommandEvent commandEvent) {
        Command command = commandEvent.getCommandSource();
        if (command instanceof LDAPConnectCommand) {
            LDAPConnectCommand lDAPConnectCommand = (LDAPConnectCommand)command;
            if (this.m_listeners != null) {
                this.m_listeners.connectFailed(new LDAPEvent(this, lDAPConnectCommand.getError()));
                return;
            }
        } else {
            LDAPCommand lDAPCommand = (LDAPCommand)command;
            ILDAPRequest iLDAPRequest = lDAPCommand.getRequest();
            this.m_sentCommands.remove(new Integer(iLDAPRequest.getMsgId()));
            iLDAPRequest.commandFailed(this, lDAPCommand, iLDAPRequest);
        }
    }

    public void onException(Exception exception) {
    }

    public void onResponse(BERModule bERModule) {
        BERSequence bERSequence = (BERSequence)bERModule.getChildElement(0);
        BERInteger bERInteger = (BERInteger)bERSequence.getChildElement(0);
        BERTag bERTag = (BERTag)bERSequence.getChildElement(1);
        LDAPCommand lDAPCommand = null;
        Integer n = new Integer((int)bERInteger.getValue());
        lDAPCommand = (LDAPCommand)((Object)this.m_sentCommands.get(n));
        if (bERTag.getTagNumber() != 4) {
            this.m_sentCommands.remove(n);
        }
        ILDAPRequest iLDAPRequest = lDAPCommand.getRequest();
        iLDAPRequest.onResponse(this, bERModule, lDAPCommand);
    }
}

