/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.srcviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.xml.srcviewer.Offset;
import oracle.xml.srcviewer.XMLStyledDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLSourceView
extends JPanel
implements Serializable {
    private SimpleAttributeSet sas1;
    private static final boolean DEBUG = false;
    protected JTextPane jTextPane;
    protected JScrollPane jScrollPane;
    protected Document inputDOMDocument;
    protected XMLStyledDocument xmlStyledDocument;

    public XMLSourceView() {
        this.setBackground(Color.white);
        this.getJScrollPane_().getViewport().add(this.getJTextPane());
        this.getJTextPane().setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane_(), "Center");
        this.xmlStyledDocument = new XMLStyledDocument();
    }

    public Font getAttributeNameFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeNameSimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getAttributeNameForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeNameSimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public Font getAttributeValueFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeValueSimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getAttributeValueForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeValueSimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public Font getCDATAFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getCDATASimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getCDATAForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getCDATASimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public Font getCommentDataFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getCommentDataSimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getCommentDataForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getCommentDataSimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    private JScrollPane getJScrollPane_() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(22, 32);
        }
        return this.jScrollPane;
    }

    public JTextPane getJTextPane() {
        if (this.jTextPane == null) {
            this.jTextPane = new JTextPane();
        }
        return this.jTextPane;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public Node getNodeAtOffset(int i) throws BadLocationException {
        if (this.inputDOMDocument == null || this.xmlStyledDocument == null) {
            throw new IllegalArgumentException("Null document");
        }
        Node node = this.xmlStyledDocument.getNode(i);
        if (node != null) {
            return node;
        }
        throw new BadLocationException("", i);
    }

    public Font getPCDATAFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getPCDATASimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getPCDATAForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getPCDATASimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public Font getPIDataFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getPIDataSimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getPIDataForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getPIDataSimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public Font getPINameFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getPINameSimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getPINameForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getPINameSimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public String getText() {
        return this.xmlStyledDocument.getContentString();
    }

    public String getEditedText() {
        return this.getJTextPane().getText();
    }

    public Font getSymbolFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getSymbolSimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getSymbolForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getSymbolSimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public Font getTagFont() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getTagSimpleAttrSet();
        return XMLSourceView.fontGet(sas);
    }

    public Color getTagForeground() {
        SimpleAttributeSet sas = this.xmlStyledDocument.getTagSimpleAttrSet();
        return StyleConstants.getForeground(sas);
    }

    public void selectNodeAt(int i) throws BadLocationException {
        if (this.inputDOMDocument == null || this.xmlStyledDocument == null) {
            throw new IllegalArgumentException("Null document");
        }
        this.setSelectedNode(this.getNodeAtOffset(i));
    }

    public void setAttributeNameFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeNameSimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setAttributeNameSimpleAttrSet(sas);
    }

    public void setAttributeNameForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeNameSimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setAttributeNameSimpleAttrSet(sas);
    }

    public void setAttributeValueFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeValueSimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setAttributeValueSimpleAttrSet(sas);
    }

    public void setAttributeValueForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getAttributeValueSimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setAttributeValueSimpleAttrSet(sas);
    }

    public void setBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        this.getJTextPane().setBackground(color);
        super.setBackground(color);
    }

    public void setCDATAFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getCDATASimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setCDATASimpleAttrSet(sas);
    }

    public void setCDATAForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getCDATASimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setCDATASimpleAttrSet(sas);
    }

    public void setCommentDataFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getCommentDataSimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setCommentDataSimpleAttrSet(sas);
    }

    public void setCommentDataForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getCommentDataSimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setCommentDataSimpleAttrSet(sas);
    }

    public void setEditable(boolean edit) {
        this.getJTextPane().setEditable(edit);
    }

    public boolean isEditable() {
        return this.getJTextPane().isEditable();
    }

    public void setXMLDocument(Document document) {
        this.inputDOMDocument = document;
        if (this.inputDOMDocument != null) {
            XMLStyledDocument tempDoc = new XMLStyledDocument(this.inputDOMDocument);
            tempDoc.tagSAS = this.xmlStyledDocument.tagSAS;
            tempDoc.attributeNameSAS = this.xmlStyledDocument.attributeNameSAS;
            tempDoc.attributeValueSAS = this.xmlStyledDocument.attributeValueSAS;
            tempDoc.commentDataSAS = this.xmlStyledDocument.commentDataSAS;
            tempDoc.piNameSAS = this.xmlStyledDocument.piNameSAS;
            tempDoc.piDataSAS = this.xmlStyledDocument.piDataSAS;
            tempDoc.pcdataSAS = this.xmlStyledDocument.pcdataSAS;
            tempDoc.cdataSAS = this.xmlStyledDocument.cdataSAS;
            tempDoc.symbolSAS = this.xmlStyledDocument.symbolSAS;
            this.xmlStyledDocument = tempDoc;
        }
        this.getJTextPane().setDocument(this.xmlStyledDocument);
    }

    public void setPCDATAFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getPCDATASimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setPCDATASimpleAttrSet(sas);
    }

    public void setPCDATAForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getPCDATASimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setPCDATASimpleAttrSet(sas);
    }

    public void setPIDataFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getPIDataSimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setPIDataSimpleAttrSet(sas);
    }

    public void setPIDataForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getPIDataSimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setPIDataSimpleAttrSet(sas);
    }

    public void setPINameFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getPINameSimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setPINameSimpleAttrSet(sas);
    }

    public void setPINameForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getPINameSimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setPINameSimpleAttrSet(sas);
    }

    public void setSelectedNode(Node node) {
        if (node == null) {
            return;
        }
        this.getJTextPane().setCaretPosition(0);
        this.getJTextPane().moveCaretPosition(0);
        Offset offset = this.xmlStyledDocument.getOffset(node);
        if (offset != null) {
            this.getJTextPane().setCaretPosition(offset.getStartOffset());
            this.getJTextPane().moveCaretPosition(offset.getEndOffset());
        }
    }

    public void setSymbolFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getSymbolSimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setSymbolSimpleAttrSet(sas);
    }

    public void setSymbolForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getSymbolSimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setSymbolSimpleAttrSet(sas);
    }

    public void setTagFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getTagSimpleAttrSet();
        XMLSourceView.fontSet(sas, font);
        this.xmlStyledDocument.setTagSimpleAttrSet(sas);
    }

    public void setTagForeground(Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SimpleAttributeSet sas = this.xmlStyledDocument.getTagSimpleAttrSet();
        StyleConstants.setForeground(sas, color);
        this.xmlStyledDocument.setTagSimpleAttrSet(sas);
    }

    public static Font fontGet(AttributeSet attributeset) {
        String s = StyleConstants.getFontFamily(attributeset);
        int i = StyleConstants.getFontSize(attributeset);
        int j = 0;
        if (StyleConstants.isBold(attributeset)) {
            j |= 1;
        }
        if (StyleConstants.isItalic(attributeset)) {
            j |= 2;
        }
        return new Font(s, j, i);
    }

    public static void fontSet(MutableAttributeSet mutableattributeset, Font font) {
        StyleConstants.setFontFamily(mutableattributeset, font.getFamily());
        StyleConstants.setFontSize(mutableattributeset, font.getSize());
        StyleConstants.setBold(mutableattributeset, font.isBold());
        StyleConstants.setItalic(mutableattributeset, font.isItalic());
    }
}

