/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.srcviewer;

import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StringContent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import oracle.xml.srcviewer.BranchOffset;
import oracle.xml.srcviewer.LeafOffset;
import oracle.xml.srcviewer.Offset;
import oracle.xml.srcviewer.SViewConstants;
import oracle.xml.srcviewer.XMLHandler;
import oracle.xml.srcviewer.XMLTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class XMLStyledDocument
extends DefaultStyledDocument
implements Serializable,
XMLHandler,
SViewConstants {
    protected SimpleAttributeSet tagSAS;
    protected SimpleAttributeSet attributeNameSAS;
    protected SimpleAttributeSet attributeValueSAS;
    protected SimpleAttributeSet commentDataSAS;
    protected SimpleAttributeSet piNameSAS;
    protected SimpleAttributeSet piDataSAS;
    protected SimpleAttributeSet pcdataSAS;
    protected SimpleAttributeSet cdataSAS;
    protected SimpleAttributeSet symbolSAS;
    private Hashtable nodeBranchOffset;
    private String content;
    private BranchOffset rootDocumentOffset;
    private Vector tagOffsets;
    private Vector attributeNameOffsets;
    private Vector attributeValueOffsets;
    private Vector commentDataOffsets;
    private Vector piNameOffsets;
    private Vector piDataOffsets;
    private Vector pcdataOffsets;
    private Vector cdataOffsets;
    private Vector ignorableWhiteSpaceOffsets;
    private Vector symbolOffsets;
    private StringBuffer xmlContentBuffer;
    private Stack stack;
    private BranchOffset currentParentOffsets;
    private BranchOffset currentChildOffsets;
    private int previousOffset;
    private Node currentNode;

    protected XMLStyledDocument() {
        super(new StyleContext());
        this.content = "";
        this.initAttrib();
        this.initOffsets();
        try {
            this.insertString(0, this.content, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected XMLStyledDocument(Document document) {
        this.initAttrib();
        this.initOffsets();
        XMLTokenizer xmltokenizer = new XMLTokenizer();
        xmltokenizer.setXMLHandler(this);
        xmltokenizer.tokenize(document);
        this.format();
    }

    protected void setDocument(Document document) {
        try {
            this.remove(0, this.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initOffsets();
        XMLTokenizer xmltokenizer = new XMLTokenizer();
        xmltokenizer.setXMLHandler(this);
        xmltokenizer.tokenize(document);
        this.format();
    }

    protected void initAttrib() {
        this.tagSAS = new SimpleAttributeSet();
        this.attributeNameSAS = new SimpleAttributeSet();
        this.attributeValueSAS = new SimpleAttributeSet();
        this.piNameSAS = new SimpleAttributeSet();
        this.piDataSAS = new SimpleAttributeSet();
        this.pcdataSAS = new SimpleAttributeSet();
        this.cdataSAS = new SimpleAttributeSet();
        this.commentDataSAS = new SimpleAttributeSet();
        this.symbolSAS = new SimpleAttributeSet();
        StyleConstants.setForeground(this.tagSAS, Color.blue);
        StyleConstants.setBold(this.tagSAS, true);
        StyleConstants.setBold(this.attributeNameSAS, true);
        StyleConstants.setForeground(this.attributeValueSAS, Color.red);
        StyleConstants.setBold(this.piNameSAS, true);
        StyleConstants.setForeground(this.piDataSAS, Color.pink);
        StyleConstants.setForeground(this.cdataSAS, Color.red);
        StyleConstants.setForeground(this.commentDataSAS, new Color(50, 128, 0));
        StyleConstants.setItalic(this.commentDataSAS, true);
    }

    protected void format() {
        this.formatTags();
        this.formatAttributeNames();
        this.formatAttributeValues();
        this.formatCommentData();
        this.formatPINames();
        this.formatPIData();
        this.formatPCDATA();
        this.formatCDATA();
        this.formatSymbols();
    }

    protected void formatAttributeNames() {
        Offset[] aoffset = this.getAttributeNameOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.attributeNameSAS, true);
            }
        }
    }

    protected void formatAttributeValues() {
        Offset[] aoffset = this.getAttributeValueOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.attributeValueSAS, true);
            }
        }
    }

    protected void formatCDATA() {
        Offset[] aoffset = this.getCDATAOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.cdataSAS, true);
            }
        }
    }

    protected void formatCommentData() {
        Offset[] aoffset = this.getCommentDataOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.commentDataSAS, true);
            }
        }
    }

    protected void formatPCDATA() {
        Offset[] aoffset = this.getPCDATAOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.pcdataSAS, true);
            }
        }
    }

    protected void formatPIData() {
        Offset[] aoffset = this.getPIDataOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.piDataSAS, true);
            }
        }
    }

    protected void formatPINames() {
        Offset[] aoffset = this.getPINameOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.piNameSAS, true);
            }
        }
    }

    protected void formatSymbols() {
        Offset[] aoffset = this.getSymbolOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.symbolSAS, true);
            }
        }
    }

    protected void formatTags() {
        Offset[] aoffset = this.getTagOffset();
        if (aoffset != null) {
            for (int i = 0; i < aoffset.length; ++i) {
                int j = aoffset[i].getStartOffset();
                int k = aoffset[i].getEndOffset() - j;
                this.setCharacterAttributes(j, k, this.tagSAS, true);
            }
        }
    }

    public SimpleAttributeSet getAttributeNameSimpleAttrSet() {
        return this.attributeNameSAS;
    }

    SimpleAttributeSet getAttributeValueSimpleAttrSet() {
        return this.attributeValueSAS;
    }

    SimpleAttributeSet getCDATASimpleAttrSet() {
        return this.cdataSAS;
    }

    SimpleAttributeSet getCommentDataSimpleAttrSet() {
        return this.commentDataSAS;
    }

    SimpleAttributeSet getPCDATASimpleAttrSet() {
        return this.pcdataSAS;
    }

    SimpleAttributeSet getPIDataSimpleAttrSet() {
        return this.piDataSAS;
    }

    SimpleAttributeSet getPINameSimpleAttrSet() {
        return this.piNameSAS;
    }

    SimpleAttributeSet getSymbolSimpleAttrSet() {
        return this.symbolSAS;
    }

    SimpleAttributeSet getTagSimpleAttrSet() {
        return this.tagSAS;
    }

    void setAttributeNameSimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.attributeNameSAS = simpleattributeset;
        this.formatAttributeNames();
    }

    void setAttributeValueSimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.attributeValueSAS = simpleattributeset;
        this.formatAttributeValues();
    }

    void setCDATASimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.cdataSAS = simpleattributeset;
        this.formatCDATA();
    }

    void setCommentDataSimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.commentDataSAS = simpleattributeset;
        this.formatCommentData();
    }

    void setPCDATASimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.pcdataSAS = simpleattributeset;
        this.formatPCDATA();
    }

    void setPIDataSimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.piDataSAS = simpleattributeset;
        this.formatPIData();
    }

    void setPINameSimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.piNameSAS = simpleattributeset;
        this.formatPINames();
    }

    void setSymbolSimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.symbolSAS = simpleattributeset;
        this.formatSymbols();
    }

    void setTagSimpleAttrSet(SimpleAttributeSet simpleattributeset) {
        this.tagSAS = simpleattributeset;
        this.formatTags();
    }

    void setDocumentData(Hashtable hashtable, String s, BranchOffset branchrange, Vector vector, Vector vector1, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Vector vector7, Vector vector8, Vector vector9) {
        this.nodeBranchOffset = hashtable;
        this.content = s;
        this.rootDocumentOffset = branchrange;
        this.tagOffsets = vector;
        this.attributeNameOffsets = vector1;
        this.attributeValueOffsets = vector2;
        this.commentDataOffsets = vector8;
        this.piNameOffsets = vector3;
        this.piDataOffsets = vector4;
        this.pcdataOffsets = vector5;
        this.cdataOffsets = vector6;
        this.ignorableWhiteSpaceOffsets = vector7;
        this.symbolOffsets = vector9;
        this.getAttributeNameOffset();
        this.getAttributeValueOffset();
        this.getCDATAOffset();
        this.getCommentDataOffset();
        this.getIgnorableWhiteSpaceOffset();
        this.getPCDATAOffset();
        this.getPIDataOffset();
        this.getPINameOffset();
    }

    Offset[] getAttributeNameOffset() {
        return this.getAOffset(this.attributeNameOffsets);
    }

    Offset[] getAttributeValueOffset() {
        return this.getAOffset(this.attributeValueOffsets);
    }

    Offset[] getCDATAOffset() {
        return this.getAOffset(this.cdataOffsets);
    }

    Offset[] getCommentDataOffset() {
        return this.getAOffset(this.commentDataOffsets);
    }

    public String getContentString() {
        return this.content;
    }

    StringContent getStringContent() {
        StringContent sc = new StringContent(this.content.length());
        try {
            sc.insertString(0, this.content);
        }
        catch (Exception e) {
            StringContent stringContent = null;
            return stringContent;
        }
        return sc;
    }

    public Document getDOMDocument() {
        return (Document)this.rootDocumentOffset.getUserObject();
    }

    Offset[] getIgnorableWhiteSpaceOffset() {
        return this.getAOffset(this.ignorableWhiteSpaceOffsets);
    }

    Node getNode(int i) {
        BranchOffset branchrange = this.rootDocumentOffset.getSubBranchOffsetAt(i);
        if (branchrange != null) {
            return (Node)branchrange.getUserObject();
        }
        return null;
    }

    Offset[] getPCDATAOffset() {
        return this.getAOffset(this.pcdataOffsets);
    }

    Offset[] getPIDataOffset() {
        return this.getAOffset(this.piDataOffsets);
    }

    Offset[] getPINameOffset() {
        return this.getAOffset(this.piNameOffsets);
    }

    Offset getOffset(Node node) {
        Offset rg = (Offset)this.nodeBranchOffset.get(node);
        return (Offset)this.nodeBranchOffset.get(node);
    }

    Offset[] getAOffset(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] aoffset = new Offset[vector.size()];
        vector.copyInto(aoffset);
        return aoffset;
    }

    Offset[] getSymbolOffset() {
        return this.getAOffset(this.symbolOffsets);
    }

    Offset[] getTagOffset() {
        return this.getAOffset(this.tagOffsets);
    }

    private void create_() {
        this.content = this.xmlContentBuffer.toString();
        try {
            this.insertString(0, this.content, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rootDocumentOffset = this.currentChildOffsets;
    }

    public synchronized void handleNode(Node node, int i) {
        this.currentNode = node;
    }

    public synchronized void handleXMLDocumentPosition(int i, int j) {
        switch (i) {
            case 2: {
                this.xmlContentBuffer.append("\n");
                this.create_();
                return;
            }
            case 17: 
            case 19: {
                this.stack.push(this.currentParentOffsets);
                this.currentParentOffsets = this.currentChildOffsets;
                return;
            }
            case 18: 
            case 20: {
                this.currentChildOffsets = this.currentParentOffsets;
                this.currentParentOffsets = (BranchOffset)this.stack.pop();
                return;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.currentChildOffsets = new BranchOffset(this.currentNode);
                if (this.currentParentOffsets != null) {
                    this.currentParentOffsets.addSuboffset(this.currentChildOffsets);
                }
                this.nodeBranchOffset.put(this.currentNode, this.currentChildOffsets);
                return;
            }
        }
    }

    public synchronized void handleXMLToken(String s, int i, int j) {
        this.xmlContentBuffer.append(s);
        LeafOffset leafoffset = new LeafOffset(this.previousOffset, j);
        this.currentChildOffsets.addSuboffset(leafoffset);
        this.previousOffset = j;
        switch (i) {
            case 1: 
            case 2: 
            case 3: {
                if (this.tagOffsets == null) {
                    this.tagOffsets = new Vector();
                }
                this.tagOffsets.addElement(leafoffset);
                return;
            }
            case 4: {
                if (this.attributeNameOffsets == null) {
                    this.attributeNameOffsets = new Vector();
                }
                this.attributeNameOffsets.addElement(leafoffset);
                return;
            }
            case 5: {
                if (this.attributeValueOffsets == null) {
                    this.attributeValueOffsets = new Vector();
                }
                this.attributeValueOffsets.addElement(leafoffset);
                return;
            }
            case 7: {
                if (this.piNameOffsets == null) {
                    this.piNameOffsets = new Vector();
                }
                this.piNameOffsets.addElement(leafoffset);
                return;
            }
            case 8: {
                if (this.piDataOffsets == null) {
                    this.piDataOffsets = new Vector();
                }
                this.piDataOffsets.addElement(leafoffset);
                return;
            }
            case 9: {
                if (this.pcdataOffsets == null) {
                    this.pcdataOffsets = new Vector();
                }
                this.pcdataOffsets.addElement(leafoffset);
                return;
            }
            case 10: {
                if (this.cdataOffsets == null) {
                    this.cdataOffsets = new Vector();
                }
                this.cdataOffsets.addElement(leafoffset);
                return;
            }
            case 11: {
                if (this.ignorableWhiteSpaceOffsets == null) {
                    this.ignorableWhiteSpaceOffsets = new Vector();
                }
                this.ignorableWhiteSpaceOffsets.addElement(leafoffset);
                return;
            }
            case 6: {
                if (this.commentDataOffsets == null) {
                    this.commentDataOffsets = new Vector();
                }
                this.commentDataOffsets.addElement(leafoffset);
                return;
            }
        }
        if (this.symbolOffsets == null) {
            this.symbolOffsets = new Vector();
        }
        this.symbolOffsets.addElement(leafoffset);
    }

    protected void initOffsets() {
        this.stack = new Stack();
        this.nodeBranchOffset = new Hashtable();
        this.currentChildOffsets = null;
        this.currentParentOffsets = null;
        this.previousOffset = 0;
        this.xmlContentBuffer = new StringBuffer();
        this.tagOffsets = null;
        this.attributeNameOffsets = null;
        this.attributeValueOffsets = null;
        this.commentDataOffsets = null;
        this.piNameOffsets = null;
        this.piDataOffsets = null;
        this.pcdataOffsets = null;
        this.cdataOffsets = null;
        this.ignorableWhiteSpaceOffsets = null;
    }

    private void print(LeafOffset leafoffset, int i) {
        for (int j = 0; j < i; ++j) {
            System.out.print("\t");
        }
        System.out.println(leafoffset);
    }

    private void recursePrint(BranchOffset branchoffset, int i) {
        for (int j = 0; j < i; ++j) {
            System.out.print("\t");
        }
        Node node = (Node)branchoffset.getUserObject();
        System.out.println(String.valueOf(String.valueOf(branchoffset).concat(String.valueOf(" userObj nodetype:"))).concat(String.valueOf(node.getNodeType())));
        Enumeration enumeration = branchoffset.suboffsets();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (obj instanceof BranchOffset) {
                    this.recursePrint((BranchOffset)obj, i + 1);
                    continue;
                }
                this.print((LeafOffset)obj, i + 1);
            }
        }
    }
}

