/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.srcviewer;

import oracle.xml.srcviewer.SViewConstants;
import oracle.xml.srcviewer.XMLHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class XMLTokenizer
implements SViewConstants {
    private XMLHandler tokenHandler;
    private Node currentNode;
    private String currentXMLToken = "";
    private int currentXMLTokenType;
    private int currentXMLDocumentPosition;
    private int currentOffset;
    private int currentTreeTraversalDepth;
    private DocumentType dtd;

    private DocumentType findDTD(Node node) {
        do {
            if (node.getNodeType() != 9) continue;
            return ((Document)node).getDoctype();
        } while ((node = node.getParentNode()) != null);
        return null;
    }

    public synchronized void tokenize(Node node) {
        this.init(node);
        this.traverseTree(node);
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public int getCurrentTreeTraversalDepth() {
        return this.currentTreeTraversalDepth;
    }

    public String getCurrentXMLToken() {
        return this.currentXMLToken;
    }

    public int getCurrentXMLTokenType() {
        return this.currentXMLTokenType;
    }

    private void handleAttribute(Attr attr) {
        this.setCurrentNode(attr);
        this.setCurrentXMLDocumentPosition(5);
        this.setCurrentXMLToken(" ", 12);
        this.setCurrentXMLToken(attr.getName(), 4);
        this.setCurrentXMLToken("=", 12);
        this.setCurrentXMLToken(String.valueOf(String.valueOf("\"").concat(String.valueOf(attr.getValue()))).concat(String.valueOf("\"")), 5);
        this.setCurrentXMLDocumentPosition(6);
    }

    private void handleComment(Comment comment) {
        this.setCurrentNode(comment);
        this.setCurrentXMLDocumentPosition(15);
        this.setCurrentXMLToken(String.valueOf(this.getTab()).concat(String.valueOf("<!--")), 12);
        this.setCurrentXMLToken(comment.getData(), 6);
        this.setCurrentXMLToken("-->", 12);
        this.setCurrentXMLDocumentPosition(16);
    }

    private void handleDocument(Document document) {
        this.setCurrentNode(document);
        this.setCurrentXMLDocumentPosition(1);
        NodeList nodelist = document.getChildNodes();
        if (nodelist != null && nodelist.getLength() > 0) {
            ++this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(19);
            int i = nodelist.getLength();
            for (int j = 0; j < i; ++j) {
                Node node = nodelist.item(j);
                this.traverseTree(node);
            }
            --this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(20);
        }
        this.setCurrentNode(document);
        this.setCurrentXMLDocumentPosition(2);
    }

    private void handleElement(Element element) {
        this.setCurrentNode(element);
        this.setCurrentXMLDocumentPosition(3);
        boolean flag = this.isEmptyElement(element);
        this.setCurrentXMLToken(String.valueOf(this.getTab()).concat(String.valueOf("<")), 12);
        if (flag) {
            this.setCurrentXMLToken(element.getTagName(), 3);
        } else {
            this.setCurrentXMLToken(element.getTagName(), 1);
        }
        NamedNodeMap namednodemap = element.getAttributes();
        if (namednodemap != null && namednodemap.getLength() > 0) {
            this.setCurrentXMLDocumentPosition(17);
            int i = namednodemap.getLength();
            for (int j = 0; j < i; ++j) {
                this.handleAttribute((Attr)namednodemap.item(j));
            }
            this.setCurrentXMLDocumentPosition(18);
        }
        this.setCurrentNode(element);
        if (flag) {
            this.setCurrentNode(element);
            this.setCurrentXMLToken("/>", 12);
            this.setCurrentXMLDocumentPosition(4);
            return;
        }
        this.setCurrentXMLToken(">", 12);
        NodeList nodelist = element.getChildNodes();
        if (nodelist != null && nodelist.getLength() > 0) {
            ++this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(19);
            int k = nodelist.getLength();
            for (int l = 0; l < k; ++l) {
                this.traverseTree(nodelist.item(l));
            }
            --this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(20);
        }
        this.setCurrentNode(element);
        this.setCurrentXMLToken(String.valueOf(this.getTab()).concat(String.valueOf("</")), 12);
        this.setCurrentXMLToken(element.getTagName(), 2);
        this.setCurrentXMLToken(">", 12);
        this.setCurrentXMLDocumentPosition(4);
    }

    private void handlePI(ProcessingInstruction processinginstruction) {
        this.setCurrentNode(processinginstruction);
        this.setCurrentXMLDocumentPosition(13);
        this.setCurrentXMLToken("<?", 12);
        this.setCurrentXMLToken(processinginstruction.getTarget(), 7);
        this.setCurrentXMLToken(" ", 12);
        this.setCurrentXMLToken(processinginstruction.getData(), 8);
        this.setCurrentXMLToken("?>", 12);
        this.setCurrentXMLDocumentPosition(14);
    }

    private void handleText(Text text) {
        int i;
        this.setCurrentNode(text);
        String s = text.getNodeValue();
        StringBuffer sb = new StringBuffer(s);
        int offset = 0;
        int len = sb.length();
        while ((len = sb.length()) > 0) {
            if (sb.charAt(len - 1) == '\n') {
                sb.setLength(len - 1);
                break;
            }
            if (sb.charAt(len - 1) != ' ') break;
            sb.setLength(len - 1);
        }
        block1: do {
            len = sb.length();
            char[] textChars = new char[len];
            sb.getChars(0, len, textChars, 0);
            for (i = offset; i < len; ++i) {
                if (textChars[i] == '&') {
                    sb.insert(i + 1, "#38;");
                    offset = i + 1;
                    continue block1;
                }
                if (textChars[i] != '<') continue;
                sb.setCharAt(i, '&');
                sb.insert(i + 1, "#60;");
                offset = i + 1;
                continue block1;
            }
        } while (i < len);
        s = sb.toString();
        if (text instanceof CDATASection) {
            this.setCurrentXMLDocumentPosition(9);
            this.setCurrentXMLToken(String.valueOf(this.getTab()).concat(String.valueOf("<![CDATA[")), 12);
            this.setCurrentXMLToken(s, 10);
            this.setCurrentXMLToken("]]>", 12);
            this.setCurrentXMLDocumentPosition(10);
            return;
        }
        if (s.trim().equals("")) {
            this.setCurrentXMLDocumentPosition(11);
            this.setCurrentXMLToken(s, 11);
            this.setCurrentXMLDocumentPosition(12);
            return;
        }
        this.setCurrentXMLDocumentPosition(7);
        this.setCurrentXMLToken(s, 9);
        this.setCurrentXMLDocumentPosition(8);
    }

    private void init(Node node) {
        this.currentTreeTraversalDepth = 0;
        this.currentOffset = 0;
        this.currentXMLToken = "";
        this.currentXMLDocumentPosition = 0;
        this.currentXMLTokenType = 0;
        this.dtd = this.findDTD(node);
    }

    private boolean isEmptyElement(Element element) {
        return !element.hasChildNodes();
    }

    private void setCurrentNode(Node node) {
        this.currentNode = node;
        if (this.tokenHandler != null) {
            this.tokenHandler.handleNode(this.currentNode, this.currentTreeTraversalDepth);
        }
    }

    private void setCurrentXMLDocumentPosition(int i) {
        this.currentXMLDocumentPosition = i;
        if (this.tokenHandler != null) {
            this.tokenHandler.handleXMLDocumentPosition(this.currentXMLDocumentPosition, this.currentOffset);
        }
    }

    private void setCurrentXMLToken(String s, int i) {
        this.currentXMLToken = s;
        this.currentXMLTokenType = i;
        this.currentOffset += s.length();
        if (this.tokenHandler != null) {
            this.tokenHandler.handleXMLToken(this.currentXMLToken, this.currentXMLTokenType, this.currentOffset);
        }
    }

    public synchronized void setXMLHandler(XMLHandler xmltokenhandler) {
        this.tokenHandler = xmltokenhandler;
    }

    private void traverseTree(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                this.handleDocument((Document)node);
                return;
            }
            case 1: {
                this.handleElement((Element)node);
                return;
            }
            case 3: {
                this.handleText((Text)node);
                return;
            }
            case 4: {
                this.handleText((Text)node);
                return;
            }
            case 7: {
                this.handlePI((ProcessingInstruction)node);
                return;
            }
            case 8: {
                this.handleComment((Comment)node);
                return;
            }
            case 2: {
                this.handleAttribute((Attr)node);
                return;
            }
        }
    }

    private String getTab() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (int i = 0; i < this.currentTreeTraversalDepth - 1; ++i) {
            sb.append("   ");
        }
        return sb.toString();
    }
}

