/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.transviewer.ConnectData;

class FilePanel
extends JPanel
implements Serializable {
    Vector actionListeners;
    XYLayout xYLayout1 = new XYLayout();
    JButton newButton = new JButton();
    JButton openButton = new JButton();
    JLabel fileNameLabel = new JLabel();
    JButton saveButton = new JButton();
    JButton saveasButton = new JButton();
    JTextField fileTextField = new JTextField();
    JButton browseButton = new JButton();
    JLabel statusTextLabel = new JLabel();
    String fileText = "";
    ConnectData conData = new ConnectData();
    XMLDocument xmlDoc = null;
    String defaultFilter = "";
    String defaultDescription = "";
    JLabel BufferNameLB = new JLabel();
    JLabel BufferStatusLB = new JLabel();
    Locale eLocale;
    Locale defaultLocale = new Locale("en", "US");
    static String eFilename = "oracle.xml.transviewer.mesg.UserInterface";
    ResourceBundle resBundle;
    String fileName = "untitled.xml";
    String newFileName = "untitled.xml";
    String FileNameLabel = "File Name:";
    String OpenButtonText = "Open";
    String NewButtonText = "New";
    String SaveButtonText = "Save";
    String SaveAsButtonText = "Save As";
    String BrowseButtonText = "Browse";
    String XMLBufferText = "XML Buffer: ";
    String EmptyText = "Empty";
    String SavedText = " saved";
    String ErrorSavingText = "Error saving the file";

    private void loadText() {
        try {
            this.eLocale = this.getLocale();
        }
        catch (IllegalComponentStateException cse) {
            this.eLocale = this.defaultLocale;
        }
        try {
            this.resBundle = ResourceBundle.getBundle(eFilename, this.eLocale);
            this.fileName = this.resBundle.getString("T200");
            this.newFileName = this.resBundle.getString("T200");
            this.FileNameLabel = this.resBundle.getString("T201");
            this.OpenButtonText = this.resBundle.getString("T202");
            this.NewButtonText = this.resBundle.getString("T203");
            this.SaveButtonText = this.resBundle.getString("T204");
            this.SaveAsButtonText = this.resBundle.getString("T205");
            this.BrowseButtonText = this.resBundle.getString("T206");
            this.XMLBufferText = this.resBundle.getString("T207");
            this.EmptyText = this.resBundle.getString("T208");
            this.SavedText = this.resBundle.getString("T209");
            this.ErrorSavingText = this.resBundle.getString("T210");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FilePanel(ConnectData conData) {
        this.conData = conData;
        this.loadText();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.newButton.setText(this.NewButtonText);
        this.openButton.setText(this.OpenButtonText);
        this.saveButton.setText(this.SaveButtonText);
        this.saveasButton.setText(this.SaveAsButtonText);
        this.browseButton.setText(this.BrowseButtonText);
        this.fileNameLabel.setText(this.FileNameLabel);
        this.BufferNameLB.setText(this.XMLBufferText);
        this.BufferStatusLB.setText(this.EmptyText);
        this.xYLayout1.setHeight(297);
        this.xYLayout1.setWidth(506);
        this.newButton.setFont(new Font("Dialog", 0, 12));
        this.newButton.setBounds(new Rectangle(0, 0, 59, 25));
        this.openButton.setFont(new Font("Dialog", 0, 12));
        this.newButton.addActionListener(new 1());
        this.openButton.addActionListener(new 2());
        this.fileNameLabel.setForeground(Color.black);
        this.fileNameLabel.setFont(new Font("Dialog", 0, 12));
        this.saveButton.setFont(new Font("Dialog", 0, 12));
        this.saveButton.addActionListener(new 3());
        this.saveasButton.setFont(new Font("Dialog", 0, 12));
        this.saveasButton.addActionListener(new 4());
        this.browseButton.setFont(new Font("Dialog", 0, 12));
        this.BufferNameLB.setFont(new Font("Dialog", 0, 12));
        this.BufferStatusLB.setForeground(Color.white);
        this.BufferStatusLB.setFont(new Font("Dialog", 0, 12));
        this.BufferStatusLB.setBackground(Color.black);
        this.BufferNameLB.setBackground(new Color(46, 204, 204));
        this.BufferNameLB.setForeground(Color.darkGray);
        this.browseButton.addActionListener(new 5());
        this.fileTextField.addActionListener(new 6());
        this.setLayout((LayoutManager)this.xYLayout1);
        this.add((Component)this.newButton, new XYConstraints(8, 59, 91, 20));
        this.add((Component)this.openButton, new XYConstraints(102, 59, 93, 20));
        this.add((Component)this.fileNameLabel, new XYConstraints(7, 9, 66, 20));
        this.add((Component)this.saveButton, new XYConstraints(198, 59, 85, 20));
        this.add((Component)this.saveasButton, new XYConstraints(285, 59, 85, 20));
        this.add((Component)this.fileTextField, new XYConstraints(75, 9, 210, 20));
        this.add((Component)this.browseButton, new XYConstraints(289, 9, 80, 20));
        this.add((Component)this.statusTextLabel, new XYConstraints(8, 107, 360, 20));
        this.add((Component)this.BufferNameLB, new XYConstraints(8, 89, 88, -1));
        this.add((Component)this.BufferStatusLB, new XYConstraints(99, 89, 399, -1));
    }

    void setFilterAttributes(String ext, String desc) {
        this.defaultFilter = ext;
        this.defaultDescription = desc;
    }

    ConnectData getConnectData() {
        this.conData.xmlFileName = this.fileTextField.getText();
        return this.conData;
    }

    String chooseFile(int mode) {
        String fileName = "";
        JFileChooser chooser = new JFileChooser();
        int retval = chooser.showOpenDialog(this);
        switch (retval) {
            case 0: {
                fileName = chooser.getSelectedFile().toString();
                break;
            }
            case 1: {
                fileName = null;
                break;
            }
            case -1: {
                fileName = null;
            }
        }
        return fileName;
    }

    String saveFile(int mode) {
        String fileName = "";
        JFileChooser chooser = new JFileChooser();
        int retval = chooser.showSaveDialog(this);
        switch (retval) {
            case 0: {
                fileName = chooser.getSelectedFile().toString();
                break;
            }
            case 1: {
                fileName = null;
                break;
            }
            case -1: {
                fileName = null;
            }
        }
        return fileName;
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    void browseButton_actionPerformed(ActionEvent e) {
        this.fileName = this.chooseFile(2);
        if (this.fileName != null) {
            this.fileTextField.setText(this.fileName);
            this.conData.xmlFileName = this.fileName;
            this.fireActionPerformed(new ActionEvent(this, 1, "fileopen"));
        }
    }

    void newButton_actionPerformed(ActionEvent e) {
        this.fileName = null;
        this.conData.xmlFileName = null;
        this.conData.xmlText = "<?xml version='1.0'?><enter/>";
        this.conData.dataSourceString = "Loaded with new file";
        this.fireActionPerformed(new ActionEvent(this, 1, "fileopen"));
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.conData.xmlFileName = this.fileName = this.fileTextField.getText();
        this.conData.xmlText = null;
        this.conData.dataSourceString = String.valueOf("Loaded, filename=").concat(String.valueOf(this.conData.xmlFileName));
        this.fireActionPerformed(new ActionEvent(this, 1, "fileopen"));
    }

    void saveButton_actionPerformed(ActionEvent e) {
        this.conData.xmlFileName = this.fileName = this.fileTextField.getText();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName));
            writer.write(this.conData.xmlText);
            writer.flush();
            writer.close();
            this.statusTextLabel.setText(String.valueOf(this.fileName).concat(String.valueOf(" saved")));
        }
        catch (Exception ex1) {
            this.statusTextLabel.setText(String.valueOf("Error saving the file ").concat(String.valueOf(ex1.toString())));
        }
        this.fileTextField.setText(this.fileName);
    }

    void saveasButton_actionPerformed(ActionEvent e) {
        this.fileName = this.saveFile(2);
        if (this.fileName != null) {
            this.conData.xmlFileName = this.fileName;
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName));
                writer.write(this.fileText);
                writer.flush();
                writer.close();
                this.statusTextLabel.setText(String.valueOf(String.valueOf(this.fileName).concat(String.valueOf(" "))).concat(String.valueOf(this.SavedText)));
            }
            catch (Exception ex1) {
                this.statusTextLabel.setText(String.valueOf(String.valueOf(this.ErrorSavingText).concat(String.valueOf(" "))).concat(String.valueOf(ex1.toString())));
            }
            this.fileTextField.setText(this.fileName);
        }
    }

    void fileTextField_actionPerformed(ActionEvent e) {
        this.conData.xmlFileName = this.fileName = this.fileTextField.getText();
        this.conData.xmlText = null;
        this.fireActionPerformed(new ActionEvent(this, 1, "fileopen"));
    }

    class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FilePanel.this.fileTextField_actionPerformed(e);
        }

        6() {
        }
    }

    class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FilePanel.this.browseButton_actionPerformed(e);
        }

        5() {
        }
    }

    class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FilePanel.this.saveasButton_actionPerformed(e);
        }

        4() {
        }
    }

    class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FilePanel.this.saveButton_actionPerformed(e);
        }

        3() {
        }
    }

    class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FilePanel.this.openButton_actionPerformed(e);
        }

        2() {
        }
    }

    class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FilePanel.this.newButton_actionPerformed(e);
        }

        1() {
        }
    }
}

