/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.srcviewer.XMLSourceView;
import oracle.xml.transviewer.ConnectData;
import oracle.xml.transviewer.DBPanel;
import oracle.xml.transviewer.FilePanel;
import oracle.xml.transviewer.HTMLPanel;
import oracle.xml.treeviewer.XMLTreeView;
import org.w3c.dom.Document;

class RESPanel
extends JPanel
implements ComponentListener {
    ConnectData conData = new ConnectData();
    JTabbedPane tabxml = new JTabbedPane(3);
    XMLTreeView xmlTreeView = new XMLTreeView();
    XMLSourceView xmlSourceView = new XMLSourceView();
    HTMLPanel htmlView = new HTMLPanel("");
    FilePanel filePanel = new FilePanel(this.conData);
    DBPanel dbPanel = new DBPanel(this.conData);
    XMLDocument resDoc;
    URL xmlUrl = null;
    DOMParser parser;
    Locale eLocale;
    Locale defaultLocale = new Locale("en", "US");
    static String eFilename = "oracle.xml.transviewer.mesg.UserInterface";
    ResourceBundle resBundle;
    String TransBufferText = "Trans Buffer:";
    String EmptyText = "Empty";
    String DBTagText = "DB  ";
    String FileTagText = "File  ";
    String TreeViewTagText = "Tree View";
    String SourceViewTagText = "Source View";
    String HTMLTagText = "HTML View";
    String ErrorTagText = "Error  ";
    String ParseSuccText = "Parsing successfull";
    String ParseFailedText = "Warning: Parse failed. ";

    private void loadText() {
        try {
            this.eLocale = this.getLocale();
        }
        catch (IllegalComponentStateException cse) {
            this.eLocale = this.defaultLocale;
        }
        try {
            this.resBundle = ResourceBundle.getBundle(eFilename, this.eLocale);
            this.EmptyText = this.resBundle.getString("T101");
            this.DBTagText = this.resBundle.getString("T103");
            this.FileTagText = this.resBundle.getString("T104");
            this.TreeViewTagText = this.resBundle.getString("T105");
            this.SourceViewTagText = this.resBundle.getString("T106");
            this.ErrorTagText = this.resBundle.getString("T108");
            this.ParseSuccText = this.resBundle.getString("T109");
            this.ParseFailedText = this.resBundle.getString("T110");
            this.TransBufferText = this.resBundle.getString("T111");
            this.HTMLTagText = this.resBundle.getString("T112");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RESPanel() {
        this.loadText();
        this.init();
        this.dbPanel.BufferNameLB.setText(this.TransBufferText);
        this.dbPanel.BufferStatusLB.setText(this.EmptyText);
        this.filePanel.BufferNameLB.setText(this.TransBufferText);
        this.filePanel.BufferStatusLB.setText(this.EmptyText);
    }

    void init() {
        this.setBackground(Color.gray);
        this.tabxml.addTab(this.DBTagText, this.dbPanel);
        this.tabxml.addTab(this.FileTagText, this.filePanel);
        this.tabxml.addTab(this.TreeViewTagText, this.xmlTreeView);
        this.tabxml.addTab(this.SourceViewTagText, this.xmlSourceView);
        this.tabxml.addTab(this.HTMLTagText, this.htmlView);
        this.tabxml.setSelectedIndex(4);
        this.filePanel.addActionListener(new 1());
        this.dbPanel.addActionListener(new 2());
        this.tabxml.addChangeListener(new 3());
        this.addComponentListener(this);
        this.setPreferredSize(new Dimension(300, 400));
        this.tabxml.setPreferredSize(new Dimension(300, 400));
        this.add(this.tabxml);
        this.doLayout();
        this.show();
    }

    public void componentResized(ComponentEvent e) {
        Dimension dim = this.getSize();
        --dim.width;
        --dim.height;
        this.tabxml.setPreferredSize(dim);
        this.updateUI();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    void setDocument(Document doc) {
        this.dbPanel.BufferStatusLB.setText(this.conData.dataSourceString);
        this.filePanel.BufferStatusLB.setText(this.conData.dataSourceString);
        this.xmlTreeView.setXMLDocument(doc);
        this.xmlSourceView.setXMLDocument(doc);
        StringWriter strwtr = new StringWriter();
        try {
            ((XMLDocument)doc).print(new PrintWriter(strwtr));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.htmlView.setText(strwtr.toString());
        this.conData.xmlText = strwtr.toString();
    }

    void disableSave() {
        this.filePanel.openButton.setEnabled(false);
        this.filePanel.newButton.setEnabled(false);
        this.filePanel.saveasButton.setEnabled(false);
    }

    void disableDBSubmit() {
        this.dbPanel.SubmitBT.setEnabled(false);
    }

    void disableDBLoad() {
        this.dbPanel.loadBT.setEnabled(false);
    }

    boolean sqlSubmited(ActionEvent e) {
        this.dbPanel.BufferStatusLB.setText(this.conData.dataSourceString);
        this.filePanel.BufferStatusLB.setText(this.conData.dataSourceString);
        String text = this.conData.xmlText;
        this.parser = new DOMParser();
        try {
            this.parser.setPreserveWhitespace(false);
            this.parser.parse((InputStream)new StringBufferInputStream(text));
            this.resDoc = this.parser.getDocument();
            this.xmlTreeView.setXMLDocument((Document)this.resDoc);
            this.xmlSourceView.setXMLDocument((Document)this.resDoc);
            StringWriter strwtr = new StringWriter();
            try {
                this.resDoc.print(new PrintWriter(strwtr));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.htmlView.setText(strwtr.toString());
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, true);
            this.tabxml.setEnabledAt(3, true);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setSelectedIndex(4);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.resDoc = new XMLDocument();
            this.xmlTreeView.setXMLDocument((Document)this.resDoc);
            this.xmlSourceView.setXMLDocument((Document)this.resDoc);
            this.htmlView.setText(this.conData.xmlText);
            this.filePanel.statusTextLabel.setText(String.valueOf(String.valueOf(this.ParseFailedText).concat(String.valueOf(" "))).concat(String.valueOf(ex.toString())));
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, false);
            this.tabxml.setEnabledAt(3, false);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setSelectedIndex(4);
            boolean bl = false;
            return bl;
        }
    }

    boolean fileSelected(ActionEvent e) {
        this.dbPanel.BufferStatusLB.setText(this.conData.dataSourceString);
        this.filePanel.BufferStatusLB.setText(this.conData.dataSourceString);
        String fileName = this.conData.xmlFileName;
        this.filePanel.statusTextLabel.setText("");
        this.parser = new DOMParser();
        try {
            this.parser.setPreserveWhitespace(false);
            if (this.conData.xmlText == null) {
                this.xmlUrl = RESPanel.createURL(fileName);
                this.parser.setBaseURL(this.xmlUrl);
                this.parser.parse(this.xmlUrl);
            } else {
                this.parser.parse((Reader)new StringReader(this.conData.xmlText));
            }
            this.resDoc = this.parser.getDocument();
            this.xmlTreeView.setXMLDocument((Document)this.resDoc);
            this.xmlSourceView.setXMLDocument((Document)this.resDoc);
            StringWriter strwtr = new StringWriter();
            try {
                this.resDoc.print(new PrintWriter(strwtr));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.htmlView.setText(strwtr.toString());
            this.conData.xmlText = strwtr.toString();
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, true);
            this.tabxml.setEnabledAt(3, true);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setSelectedIndex(3);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.resDoc = new XMLDocument();
            this.xmlTreeView.setXMLDocument((Document)this.resDoc);
            this.xmlSourceView.setXMLDocument((Document)this.resDoc);
            this.conData.xmlText = this.conData.xmlFileName != null ? this.conData.loadFile(this.conData.xmlFileName) : "";
            this.htmlView.setText(this.conData.xmlText);
            this.filePanel.statusTextLabel.setText(String.valueOf(String.valueOf(this.ParseFailedText).concat(String.valueOf(" "))).concat(String.valueOf(ex.toString())));
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, false);
            this.tabxml.setEnabledAt(3, false);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setSelectedIndex(4);
            boolean bl = false;
            return bl;
        }
    }

    void tabChanged(ChangeEvent e) {
        JTabbedPane tp = (JTabbedPane)e.getSource();
        int ind = tp.getSelectedIndex();
        String tabstr = tp.getTitleAt(ind);
        if (ind == 0) {
            tp.setSelectedIndex(0);
        }
        if (ind == 1) {
            tp.setSelectedIndex(1);
        }
    }

    static URL createURL(String fileName) {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = String.valueOf('/').concat(String.valueOf(path));
                    }
                }
                path = String.valueOf("file://").concat(String.valueOf(path));
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                System.out.println(String.valueOf("Cannot create url for: ").concat(String.valueOf(fileName)));
                System.exit(0);
            }
        }
        return url;
    }

    class 3
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            RESPanel.this.tabChanged(e);
        }

        3() {
        }
    }

    class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            RESPanel.this.sqlSubmited(e);
        }

        2() {
        }
    }

    class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            RESPanel.this.fileSelected(e);
        }

        1() {
        }
    }
}

