/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.srcviewer.XMLSourceView;
import oracle.xml.transviewer.ConnectData;
import oracle.xml.transviewer.DBPanel;
import oracle.xml.transviewer.FilePanel;
import oracle.xml.treeviewer.XMLTreeView;
import org.w3c.dom.Document;

class XSLPanel
extends JPanel
implements ComponentListener {
    ConnectData conData = new ConnectData();
    int mode = 0;
    Color editColor = new Color(224, 224, 255);
    JTabbedPane tabxml = new JTabbedPane(3);
    XMLTreeView xmlTreeView = new XMLTreeView();
    XMLSourceView xmlSourceView = new XMLSourceView();
    XMLSourceView xmlEditorView = new XMLSourceView();
    FilePanel filePanel = new FilePanel(this.conData);
    DBPanel dbPanel = new DBPanel(this.conData);
    JTextPane xmlTextPane = new JTextPane();
    JTextPane errTextPane = new JTextPane();
    XMLDocument xmlDoc = null;
    URL xmlUrl = null;
    DOMParser parser;
    String fileName;
    String xmltext;
    String xmloldtext;
    Locale eLocale;
    Locale defaultLocale = new Locale("en", "US");
    static String eFilename = "oracle.xml.transviewer.mesg.UserInterface";
    ResourceBundle resBundle;
    String XSLBufferText = "XSL Buffer:";
    String EmptyText = "Empty";
    String DBTagText = "DB  ";
    String FileTagText = "File  ";
    String TreeViewTagText = "Tree View";
    String SourceViewTagText = "Source View";
    String EditorTagText = "Editor";
    String ErrorTagText = "Error  ";
    String ParseSuccText = "Parsing successfull";
    String ParseFailedText = "Warning: Parse failed. ";
    String ParseTagText = "Parse";

    private void loadText() {
        try {
            this.eLocale = this.getLocale();
        }
        catch (IllegalComponentStateException cse) {
            this.eLocale = this.defaultLocale;
        }
        try {
            this.resBundle = ResourceBundle.getBundle(eFilename, this.eLocale);
            this.XSLBufferText = this.resBundle.getString("T100");
            this.EmptyText = this.resBundle.getString("T101");
            this.DBTagText = this.resBundle.getString("T103");
            this.FileTagText = this.resBundle.getString("T104");
            this.TreeViewTagText = this.resBundle.getString("T105");
            this.SourceViewTagText = this.resBundle.getString("T106");
            this.EditorTagText = this.resBundle.getString("T107");
            this.ErrorTagText = this.resBundle.getString("T108");
            this.ParseSuccText = this.resBundle.getString("T109");
            this.ParseFailedText = this.resBundle.getString("T110");
            this.ParseTagText = this.resBundle.getString("T113");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XSLPanel() {
        this.loadText();
        this.init();
        this.dbPanel.BufferNameLB.setText(this.XSLBufferText);
        this.dbPanel.BufferStatusLB.setText(this.EmptyText);
        this.filePanel.BufferNameLB.setText(this.XSLBufferText);
        this.filePanel.BufferStatusLB.setText(this.EmptyText);
    }

    void init() {
        this.setBackground(Color.gray);
        this.tabxml.addTab(this.DBTagText, this.dbPanel);
        this.tabxml.addTab(this.FileTagText, this.filePanel);
        this.tabxml.addTab(this.TreeViewTagText, this.xmlTreeView);
        this.tabxml.addTab(this.SourceViewTagText, this.xmlSourceView);
        this.tabxml.addTab(this.EditorTagText, this.xmlEditorView);
        this.tabxml.addTab(this.ErrorTagText, this.errTextPane);
        this.tabxml.setEnabledAt(0, true);
        this.tabxml.setEnabledAt(1, true);
        this.tabxml.setEnabledAt(2, false);
        this.tabxml.setEnabledAt(3, false);
        this.tabxml.setEnabledAt(4, false);
        this.tabxml.setEnabledAt(5, false);
        this.xmlEditorView.setEditable(true);
        this.xmlTextPane = this.xmlEditorView.getJTextPane();
        this.filePanel.addActionListener(new 1());
        this.dbPanel.addActionListener(new 2());
        this.tabxml.addChangeListener(new 3());
        this.addComponentListener(this);
        this.setPreferredSize(new Dimension(300, 400));
        this.tabxml.setPreferredSize(new Dimension(300, 400));
        this.tabxml.setSelectedIndex(0);
        this.add(this.tabxml);
        this.doLayout();
        this.show();
    }

    public void componentResized(ComponentEvent e) {
        Dimension dim = this.getSize();
        --dim.width;
        --dim.height;
        this.tabxml.setPreferredSize(dim);
        this.updateUI();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    XMLDocument getDocument() {
        return this.xmlDoc;
    }

    void disableDBSubmit() {
        this.dbPanel.SubmitBT.setEnabled(false);
    }

    boolean xmlTextPaneChanged() {
        this.xmltext = this.xmlEditorView.getEditedText();
        this.xmloldtext = this.xmlEditorView.getText();
        return this.xmltext.compareTo(this.xmloldtext) != 0;
    }

    boolean sqlSubmited(ActionEvent e) {
        this.dbPanel.BufferStatusLB.setText(this.conData.dataSourceString);
        this.filePanel.BufferStatusLB.setText(this.conData.dataSourceString);
        String text = this.conData.xmlText;
        this.parser = new DOMParser();
        try {
            this.parser.setPreserveWhitespace(false);
            this.parser.parse((InputStream)new StringBufferInputStream(text));
            this.xmlDoc = this.parser.getDocument();
            this.xmlTreeView.setXMLDocument((Document)this.xmlDoc);
            this.xmlSourceView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setBackground(this.editColor);
            this.errTextPane.setText(this.ParseSuccText);
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, true);
            this.tabxml.setEnabledAt(3, true);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setEnabledAt(5, false);
            this.tabxml.setSelectedIndex(3);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.xmlDoc = new XMLDocument();
            this.xmlTreeView.setXMLDocument((Document)this.xmlDoc);
            this.xmlSourceView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setBackground(this.editColor);
            this.xmlTextPane.setText(this.conData.xmlText);
            this.filePanel.statusTextLabel.setText(String.valueOf(String.valueOf(this.ParseFailedText).concat(String.valueOf(" "))).concat(String.valueOf(ex.toString())));
            this.errTextPane.setText(ex.toString());
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, false);
            this.tabxml.setEnabledAt(3, false);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setEnabledAt(5, true);
            this.tabxml.setTitleAt(5, this.ErrorTagText);
            this.tabxml.setSelectedIndex(5);
            boolean bl = false;
            return bl;
        }
    }

    URL getXSLURL() {
        URL xslUrl = null;
        if (this.fileName != null) {
            xslUrl = XSLPanel.createURL(this.fileName);
            return xslUrl;
        }
        return null;
    }

    boolean fileSelected(ActionEvent e) {
        this.dbPanel.BufferStatusLB.setText(this.conData.dataSourceString);
        this.filePanel.BufferStatusLB.setText(this.conData.dataSourceString);
        this.fileName = this.conData.xmlFileName;
        this.filePanel.statusTextLabel.setText("");
        this.parser = new DOMParser();
        try {
            this.parser.setPreserveWhitespace(false);
            if (this.conData.xmlText == null) {
                this.xmlUrl = XSLPanel.createURL(this.fileName);
                this.parser.setBaseURL(this.xmlUrl);
                this.parser.parse(this.xmlUrl);
            } else {
                this.parser.parse((Reader)new StringReader(this.conData.xmlText));
            }
            this.xmlDoc = this.parser.getDocument();
            this.xmlTreeView.setXMLDocument((Document)this.xmlDoc);
            this.xmlSourceView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setXMLDocument((Document)this.xmlDoc);
            this.conData.xmlText = this.xmlSourceView.getText();
            this.xmlEditorView.setBackground(this.editColor);
            this.errTextPane.setText(this.ParseSuccText);
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, true);
            this.tabxml.setEnabledAt(3, true);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setEnabledAt(5, false);
            this.tabxml.setSelectedIndex(3);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.xmlDoc = new XMLDocument();
            this.xmlTreeView.setXMLDocument((Document)this.xmlDoc);
            this.xmlSourceView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setBackground(this.editColor);
            if (this.conData.xmlFileName != null) {
                this.conData.xmlText = this.conData.loadFile(this.conData.xmlFileName);
            }
            this.xmlTextPane.setText(this.conData.xmlText);
            this.filePanel.statusTextLabel.setText(String.valueOf(String.valueOf(this.ParseFailedText).concat(String.valueOf(" "))).concat(String.valueOf(ex.toString())));
            this.errTextPane.setText(ex.toString());
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, false);
            this.tabxml.setEnabledAt(3, false);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setEnabledAt(5, true);
            this.tabxml.setTitleAt(5, this.ErrorTagText);
            this.tabxml.setSelectedIndex(5);
            boolean bl = false;
            return bl;
        }
    }

    boolean parseAndSet() {
        String xmltext;
        this.conData.xmlText = xmltext = this.xmlEditorView.getEditedText();
        if (xmltext == null) {
            return false;
        }
        if (xmltext.length() == 0) {
            return false;
        }
        this.parser = new DOMParser();
        try {
            StringReader in = new StringReader(xmltext);
            this.parser.setPreserveWhitespace(false);
            this.parser.parse((Reader)in);
            this.xmlDoc = this.parser.getDocument();
            this.xmlTreeView.setXMLDocument((Document)this.xmlDoc);
            this.xmlSourceView.setXMLDocument((Document)this.xmlDoc);
            this.xmlEditorView.setXMLDocument((Document)this.xmlDoc);
            this.conData.xmlText = this.xmlSourceView.getText();
            this.filePanel.xmlDoc = this.xmlDoc;
            this.xmlEditorView.setBackground(this.editColor);
            this.errTextPane.setText(this.ParseSuccText);
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, true);
            this.tabxml.setEnabledAt(3, true);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setEnabledAt(5, false);
            this.filePanel.statusTextLabel.setText("");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.errTextPane.setText(ex.toString());
            this.filePanel.statusTextLabel.setText(String.valueOf(String.valueOf(this.ParseFailedText).concat(String.valueOf(" "))).concat(String.valueOf(ex.toString())));
            this.tabxml.setEnabledAt(0, true);
            this.tabxml.setEnabledAt(1, true);
            this.tabxml.setEnabledAt(2, false);
            this.tabxml.setEnabledAt(4, false);
            this.tabxml.setEnabledAt(4, true);
            this.tabxml.setEnabledAt(5, true);
            this.tabxml.setTitleAt(5, this.ErrorTagText);
            boolean bl = false;
            return bl;
        }
    }

    void tabChanged(ChangeEvent e) {
        JTabbedPane tp = (JTabbedPane)e.getSource();
        int ind = tp.getSelectedIndex();
        String tabstr = tp.getTitleAt(ind);
        if (ind == 0) {
            this.conData.xmlText = this.xmlEditorView.getEditedText();
            tp.setSelectedIndex(0);
        }
        if (ind == 1) {
            this.conData.xmlText = this.xmlEditorView.getEditedText();
            tp.setSelectedIndex(1);
        }
        if (ind == 2 && this.xmlTextPaneChanged()) {
            if (this.parseAndSet()) {
                tp.setSelectedIndex(ind);
            } else {
                tp.setSelectedIndex(5);
            }
        }
        if (ind == 3 && this.xmlTextPaneChanged()) {
            if (this.parseAndSet()) {
                tp.setSelectedIndex(ind);
            } else {
                tp.setSelectedIndex(5);
            }
        }
        if (ind == 4) {
            this.tabxml.setTitleAt(5, this.ParseTagText);
            this.tabxml.setEnabledAt(5, true);
        }
        if (ind == 5) {
            if (this.parseAndSet()) {
                tp.setSelectedIndex(ind);
            } else {
                tp.setSelectedIndex(5);
            }
        }
    }

    static URL createURL(String fileName) {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = String.valueOf('/').concat(String.valueOf(path));
                    }
                }
                path = String.valueOf("file://").concat(String.valueOf(path));
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                System.out.println(String.valueOf("Cannot create url for: ").concat(String.valueOf(fileName)));
                System.exit(0);
            }
        }
        return url;
    }

    class 3
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            XSLPanel.this.tabChanged(e);
        }

        3() {
        }
    }

    class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XSLPanel.this.sqlSubmited(e);
        }

        2() {
        }
    }

    class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XSLPanel.this.fileSelected(e);
        }

        1() {
        }
    }
}

