/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.treeviewer;

import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class XMLTreeNode
extends DefaultMutableTreeNode
implements Serializable {
    private boolean firstTime = false;
    private int showLevels;
    private int position;
    private boolean piVisible;
    private boolean commentVisible;
    private boolean elementVisible;
    private boolean pcdataVisible;
    private boolean whitespaceVisible;
    private boolean attributeVisible;

    public XMLTreeNode(Node node, int i) {
        super(node);
        this.showLevels = i;
        this.pcdataVisible = true;
        this.elementVisible = true;
        this.whitespaceVisible = false;
        this.attributeVisible = true;
        this.commentVisible = true;
        this.piVisible = true;
    }

    public boolean isLeaf() {
        NamedNodeMap namednodemap;
        Node node = (Node)this.getUserObject();
        switch (node.getNodeType()) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        if (!node.hasChildNodes() && node.getAttributes() == null) {
            return true;
        }
        if (this.showLevels < 2) {
            return true;
        }
        if (this.attributeVisible && (namednodemap = node.getAttributes()) != null && namednodemap.getLength() > 0) {
            return false;
        }
        NodeList nodelist = node.getChildNodes();
        int i = nodelist.getLength();
        Object obj = null;
        if (nodelist != null) {
            block8: for (int j = 0; j < i; ++j) {
                Node node1 = nodelist.item(j);
                switch (node1.getNodeType()) {
                    default: {
                        break;
                    }
                    case 8: {
                        if (this.commentVisible) break;
                        continue block8;
                    }
                    case 7: {
                        if (!this.piVisible) continue block8;
                        break;
                    }
                    case 3: {
                        Text text = (Text)node1;
                        if (text.getNodeValue().trim().length() != 0 ? !this.pcdataVisible : !this.whitespaceVisible) continue block8;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public String toString() {
        Node node = (Node)this.getUserObject();
        switch (node.getNodeType()) {
            case 8: {
                return this.stripLF(((Comment)node).getNodeValue());
            }
            case 3: {
                return String.valueOf(String.valueOf("\"").concat(String.valueOf(this.stripLF(((Text)node).getNodeValue())))).concat(String.valueOf("\""));
            }
            case 1: {
                return ((Element)node).getTagName();
            }
            case 9: {
                return "[DOCUMENT]";
            }
            case 7: {
                return ((ProcessingInstruction)node).getData();
            }
            case 2: {
                return String.valueOf(String.valueOf(String.valueOf(((Attr)node).getName()).concat(String.valueOf("=\""))).concat(String.valueOf(((Attr)node).getValue()))).concat(String.valueOf("\""));
            }
        }
        return node.getNodeValue();
    }

    private String stripLF(String text) {
        int maxLength = 1000;
        StringBuffer sb = new StringBuffer(text);
        int len = sb.length();
        char[] textChars = new char[len];
        sb.getChars(0, len, textChars, 0);
        for (int i = 0; i < len; ++i) {
            if (textChars[i] != '\n') continue;
            sb.setCharAt(i, ' ');
        }
        if (sb.length() > maxLength) {
            sb.setLength(maxLength);
            sb.append("... (string truncated)");
        }
        return sb.toString();
    }

    public int getChildCount() {
        if (!this.firstTime) {
            this.createTree();
        }
        this.firstTime = true;
        return super.getChildCount();
    }

    protected void addComment(Node node) {
        if (this.commentVisible) {
            this.addXMLNode(node);
        }
    }

    protected void addElement(Node node) {
        if (this.elementVisible) {
            this.addXMLNode(node);
        }
    }

    protected void addPI(Node node) {
        if (this.piVisible) {
            this.addXMLNode(node);
        }
    }

    protected void addText(Node node) {
        if (((Text)node).getData().trim().length() == 0) {
            if (this.whitespaceVisible) {
                this.addXMLNode(node);
                return;
            }
        } else if (this.pcdataVisible) {
            this.addXMLNode(node);
        }
    }

    protected void addXMLNode(Node node) {
        if (this.showLevels > 2) {
            this.insert(new XMLTreeNode(node, this.showLevels), this.position++);
            return;
        }
        this.insert(new XMLTreeNode(node, this.showLevels - 1), this.position++);
    }

    protected void createTree() {
        NamedNodeMap namednodemap;
        Node node = (Node)this.getUserObject();
        if (this.showLevels < 1) {
            return;
        }
        if (this.attributeVisible && (namednodemap = node.getAttributes()) != null) {
            int i = namednodemap.getLength();
            for (int j = 0; j < i; ++j) {
                this.addXMLNode(namednodemap.item(j));
            }
        }
        NodeList nodelist = node.getChildNodes();
        Object obj = null;
        int k = nodelist.getLength();
        if (nodelist != null) {
            block8: for (int l = 0; l < k; ++l) {
                Node node1 = nodelist.item(l);
                switch (node1.getNodeType()) {
                    case 8: {
                        this.addComment(node1);
                        continue block8;
                    }
                    case 3: {
                        this.addText(node1);
                        continue block8;
                    }
                    case 7: {
                        this.addPI(node1);
                        continue block8;
                    }
                    case 1: {
                        this.addElement(node1);
                        continue block8;
                    }
                    case 4: 
                    case 9: {
                        this.addXMLNode(node1);
                    }
                }
            }
        }
    }

    protected void showNodes() {
        this.removeAllChildren();
        this.position = 0;
        this.createTree();
    }
}

