/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.repapi.client.Lenobj;

public final class LengthinBytes {
    public static final Lenobj GetLength(DataInputStream ds) throws IOException {
        short numcolbytes = ds.readByte();
        if (numcolbytes < 0) {
            numcolbytes = (byte)(numcolbytes & 0xF);
            short numlenbytes = (short)(ds.readByte() & 0xF);
            Lenobj lo = new Lenobj(0, 0L, 0L);
            short i = 0;
            while (i < numcolbytes) {
                lo.colbytes |= ((long)ds.readByte() & 0xFFL) << i * 8;
                i = (short)(i + 1);
            }
            short i2 = 0;
            while (i2 < numlenbytes) {
                lo.lenbytes |= ((long)ds.readByte() & 0xFFL) << i2 * 8;
                i2 = (short)(i2 + 1);
            }
            return lo;
        }
        short numlenbytes = (short)(numcolbytes & 0xF);
        Lenobj lo = new Lenobj(0, 0L, 0L);
        short i = 0;
        while (i < numlenbytes) {
            lo.lenbytes |= ((long)ds.readByte() & 0xFFL) << i * 8;
            i = (short)(i + 1);
        }
        return lo;
    }

    public static final long GetLength(DataInputStream ds, byte numlenbytes) throws IOException {
        long length = 0L;
        short i = 0;
        while (i < numlenbytes) {
            length |= ((long)ds.readByte() & 0xFFL) << i * 8;
            i = (short)(i + 1);
        }
        return length;
    }

    public static final Lenobj GetLength(byte[] lbyte, int offset) {
        if (lbyte[offset] < 0) {
            short numcolbytes = (short)(lbyte[offset++] & 0xF);
            short numlenbytes = (short)(lbyte[offset++] & 0xF);
            Lenobj lo = new Lenobj(numcolbytes + numlenbytes + offset, 0L, 0L);
            short i = 0;
            while (i < numcolbytes) {
                lo.colbytes |= ((long)lbyte[offset] & 0xFFL) << i * 8;
                i = (short)(i + 1);
                ++offset;
            }
            short i2 = 0;
            while (i2 < numlenbytes) {
                lo.lenbytes |= ((long)lbyte[offset] & 0xFFL) << i2 * 8;
                i2 = (short)(i2 + 1);
                ++offset;
            }
            return lo;
        }
        short numlenbytes = (short)(lbyte[offset++] & 0xF);
        Lenobj lo = new Lenobj(numlenbytes + offset, 0L, 0L);
        short i = 0;
        while (i < numlenbytes) {
            lo.lenbytes |= ((long)lbyte[offset] & 0xFFL) << i * 8;
            i = (short)(i + 1);
            ++offset;
        }
        return lo;
    }

    public static final Lenobj GetLength(byte[] lbyte, int offset, byte numlenbytes) {
        Lenobj lo = new Lenobj(numlenbytes + offset, 0L, 0L);
        short i = 0;
        while (i < numlenbytes) {
            lo.lenbytes |= ((long)lbyte[offset] & 0xFFL) << i * 8;
            i = (short)(i + 1);
            ++offset;
        }
        return lo;
    }

    public static final byte PutLength(DataOutputStream ds, long number) throws IOException {
        if (number > Integer.MAX_VALUE) {
            ds.write(8);
            ds.write((byte)(number & 0xFFL));
            ds.write((byte)((number & 0xFF00L) >> 8));
            ds.write((byte)((number & 0xFF0000L) >> 16));
            ds.write((byte)((number & 0xFFFFFFFFFF000000L) >> 24));
            ds.write((byte)((number & 0xFF00000000L) >> 32));
            ds.write((byte)((number & 0xFF0000000000L) >> 40));
            ds.write((byte)((number & 0xFF000000000000L) >> 48));
            ds.write((byte)((number & 0xFF00000000000000L) >> 56));
            return 9;
        }
        if (number > 32767L) {
            ds.write(4);
            ds.write((byte)(number & 0xFFL));
            ds.write((byte)((number & 0xFF00L) >> 8));
            ds.write((byte)((number & 0xFF0000L) >> 16));
            ds.write((byte)((number & 0xFFFFFFFFFF000000L) >> 24));
            return 5;
        }
        if (number > 127L) {
            ds.write(2);
            ds.write((byte)(number & 0xFFL));
            ds.write((byte)((number & 0xFF00L) >> 8));
            return 3;
        }
        if (number >= 0L) {
            ds.write(1);
            ds.write((byte)(number & 0xFFL));
            return 2;
        }
        return 0;
    }

    public static final void PutLength(DataOutputStream ds, long number, byte numbytes) throws IOException {
        ds.write((byte)(number & 0xFFL));
        if (numbytes > 1) {
            ds.write((byte)((number & 0xFF00L) >> 8));
            if (numbytes > 2) {
                ds.write((byte)((number & 0xFF0000L) >> 16));
                ds.write((byte)((number & 0xFFFFFFFFFF000000L) >> 24));
                if (numbytes > 4) {
                    ds.write((byte)((number & 0xFF00000000L) >> 32));
                    ds.write((byte)((number & 0xFF0000000000L) >> 40));
                    ds.write((byte)((number & 0xFF000000000000L) >> 48));
                    ds.write((byte)((number & 0xFF00000000000000L) >> 56));
                }
            }
        }
    }

    public static final byte PutLength(byte[] lbyte, int offset, long number) {
        byte retbyte = 0;
        if (number >= 0L) {
            byte by = retbyte;
            retbyte = (byte)(by + 1);
            lbyte[offset + 1 + by] = (byte)(number & 0xFFL);
            if (number > 127L) {
                byte by2 = retbyte;
                retbyte = (byte)(by2 + 1);
                lbyte[offset + 1 + by2] = (byte)((number & 0xFF00L) >> 8);
                if (number > 32767L) {
                    byte by3 = retbyte;
                    retbyte = (byte)(by3 + 1);
                    lbyte[offset + 1 + by3] = (byte)((number & 0xFF0000L) >> 16);
                    byte by4 = retbyte;
                    retbyte = (byte)(by4 + 1);
                    lbyte[offset + 1 + by4] = (byte)((number & 0xFFFFFFFFFF000000L) >> 24);
                    if (number > Integer.MAX_VALUE) {
                        byte by5 = retbyte;
                        retbyte = (byte)(by5 + 1);
                        lbyte[offset + 1 + by5] = (byte)((number & 0xFF00000000L) >> 32);
                        byte by6 = retbyte;
                        retbyte = (byte)(by6 + 1);
                        lbyte[offset + 1 + by6] = (byte)((number & 0xFF0000000000L) >> 40);
                        byte by7 = retbyte;
                        retbyte = (byte)(by7 + 1);
                        lbyte[offset + 1 + by7] = (byte)((number & 0xFF000000000000L) >> 48);
                        byte by8 = retbyte;
                        retbyte = (byte)(by8 + 1);
                        lbyte[offset + 1 + by8] = (byte)((number & 0xFF00000000000000L) >> 56);
                    }
                }
            }
        }
        lbyte[offset] = retbyte;
        return (byte)(retbyte + 1);
    }

    public static final byte PutLength(byte[] lbyte, int offset, long number, byte numbytes) {
        byte retbyte;
        byte by = retbyte = 0;
        retbyte = (byte)(by + 1);
        lbyte[offset + by] = (byte)(number & 0xFFL);
        if (numbytes > 1) {
            byte by2 = retbyte;
            retbyte = (byte)(by2 + 1);
            lbyte[offset + by2] = (byte)((number & 0xFF00L) >> 8);
            if (numbytes > 2) {
                byte by3 = retbyte;
                retbyte = (byte)(by3 + 1);
                lbyte[offset + by3] = (byte)((number & 0xFF0000L) >> 16);
                byte by4 = retbyte;
                retbyte = (byte)(by4 + 1);
                lbyte[offset + by4] = (byte)((number & 0xFFFFFFFFFF000000L) >> 24);
                if (numbytes > 4) {
                    byte by5 = retbyte;
                    retbyte = (byte)(by5 + 1);
                    lbyte[offset + by5] = (byte)((number & 0xFF00000000L) >> 32);
                    byte by6 = retbyte;
                    retbyte = (byte)(by6 + 1);
                    lbyte[offset + by6] = (byte)((number & 0xFF0000000000L) >> 40);
                    byte by7 = retbyte;
                    retbyte = (byte)(by7 + 1);
                    lbyte[offset + by7] = (byte)((number & 0xFF000000000000L) >> 48);
                    byte by8 = retbyte;
                    retbyte = (byte)(by8 + 1);
                    lbyte[offset + by8] = (byte)((number & 0xFF00000000000000L) >> 56);
                }
            }
        }
        return retbyte;
    }
}

