/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.joint;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class RepAPIException
extends Exception {
    private static ResourceBundle bundle = null;
    private RepAPIException nextException = null;
    private static final String errPrefix = new String("REP-");
    public static final int ACCESS_NOT_AVAILABLE = 101;
    public static final int REPAPI_END_PROCESS = 102;
    public static final int REPAPI_START = 103;
    public static final int NULL_MASTER = 104;
    public static final int NULL_MASTER_USER = 105;
    public static final int MASTER_URL_NOT_FOUND = 106;
    public static final int URL_BOUND_TO_MASTER = 107;
    public static final int JDBC_NOT_INSTALLED = 108;
    public static final int INVALID_USER_PASSWORD = 109;
    public static final int INVALID_CONNECT_SYNTAX = 110;
    public static final int BAD_THIN_CONNECT = 111;
    public static final int OLITE_CONNECT_ERROR = 112;
    public static final int ABORT = 113;
    public static final int NO_CONNECTION = 114;
    public static final int MULTIPLE_REPAPI_INSTANCES = 115;
    public static final int NULL_FDS = 116;
    public static final int CREATE_NULL_REFGRP = 201;
    public static final int CREATE_REFGRP_TAB = 202;
    public static final int CREATE_TAB_EXISTS = 203;
    public static final int CREATE_REFGRP_SNAP = 204;
    public static final int DROP_SNAP = 205;
    public static final int DROP_ALL_REFGRP = 206;
    public static final int DROP_REFGRP = 207;
    public static final int CREATE_REFGRP = 208;
    public static final int DROP = 209;
    public static final int CREATE_SERVR = 210;
    public static final int DROP_SERVR = 211;
    public static final int DROP_NO_REFGRP = 212;
    public static final int DROP_METADATA = 213;
    public static final int REFRESH_COMMIT = 301;
    public static final int REFRESH_UPDATE = 302;
    public static final int REFRESH_INSERT = 303;
    public static final int REFRESH_ROLLBACK = 304;
    public static final int SEND_LOB = 305;
    public static final int LAST_REFRSH = 306;
    public static final int LAST_PUSH = 307;
    public static final int REPUSH_FAIL = 308;
    public static final int REF_SEQ = 309;
    public static final int PUSH_TO_MASTER_ROLLBACK = 310;
    public static final int DEFER_PUSH = 311;
    public static final int PUSH_INFO = 312;
    public static final int COMMIT_PUSH = 313;
    public static final int ERROR_PUSH = 314;
    public static final int REFRESH = 315;
    public static final int PUSH = 316;
    public static final int REFRESH_SERVR = 317;
    public static final int PUSH_SERVR = 318;
    public static final int REFGRP_LOCK = 319;
    public static final int DELETE_INSERT = 320;
    public static final int BAD_LOBINFO = 321;
    public static final int DIFFERENT_OFFLINE_MASTER = 401;
    public static final int DIFFERENT_OFFLINE_USER = 402;
    public static final int OFFLINE_WHILE_ONLINE = 403;
    public static final int OFFLINE_FILE_OUTPUT = 404;
    public static final int OFFLINE_OBJECT_WRITE = 405;
    public static final int OFFLINE_CONVERT = 406;
    public static final int SNAP_NOT_FOUND = 501;
    public static final int SNAP_TAB = 502;
    public static final int LAST_TRAN = 503;
    public static final int LIST_SRVR_LOCAL = 504;
    public static final int LIST_ALL_LOCAL = 505;
    public static final int LIST_SRVR = 506;
    public static final int GET_REFGRP = 507;
    public static final int NO_REFGRP = 508;
    public static final int CLIENT_DATABASE_CORRUPTED = 601;
    public static final int VERSION_INCOMPATIBLE = 602;
    public static final int VERSION_UPGRADE = 603;
    public static final int FILE_TYPE_ERROR = 604;
    public static final int NULL_INPUT = 605;
    public static final int GENERIC_ERROR = 606;
    public static final int UNSUPPORTED_DATATYPE = 607;
    public static final int ROLLBACK = 608;
    public static final int GENERIC_SERVER = 609;

    public RepAPIException(int errNo, String[] args, String[] info) {
        super(RepAPIException.msg(errNo, args, info));
    }

    public RepAPIException(String errMsg) {
        super(errMsg);
    }

    public int getErrorNum() {
        String msg = this.getMessage();
        Integer errNum = new Integer(msg.substring(errPrefix.length(), msg.indexOf(58)));
        return errNum;
    }

    public RepAPIException getNextException() {
        return this.nextException;
    }

    public static String msg(int key, String[] args, String[] info) {
        String sbuf;
        int i;
        if (args != null) {
            i = 0;
            while (i < args.length) {
                if (args[i] == null) {
                    args[i] = "null";
                }
                ++i;
            }
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("oracle.repapi.RepApiMessages.RepAPIMessages");
        }
        try {
            sbuf = MessageFormat.format(bundle.getString(String.valueOf(key)), args);
        }
        catch (Exception exception) {
            return "Message [" + key + "] not found in 'RepAPIMessages'.";
        }
        sbuf = String.valueOf(errPrefix) + String.valueOf(key) + ": " + sbuf;
        if (info != null) {
            i = 0;
            while (i < info.length) {
                if (i == 0) {
                    sbuf = String.valueOf(sbuf) + System.getProperty("line.separator");
                }
                if (info[i] == null) {
                    info[i] = "null";
                }
                sbuf = String.valueOf(sbuf) + " [" + info[i].trim() + "]";
                ++i;
            }
        }
        return sbuf;
    }

    public void setNextException(RepAPIException ex) {
        this.nextException = ex;
    }
}

