/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.joint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.GregorianCalendar;
import oracle.repapi.client.LengthinBytes;
import oracle.repapi.client.Lenobj;
import oracle.repapi.client.UDException;
import oracle.repapi.joint.ColumnDelineator;
import oracle.repapi.joint.ResultSet;
import org.omg.CORBA.Any;

public class ResultSetFactory {
    private static final short[] ZLENSHORT = new short[0];
    private static final long[] ZLENLONG = new long[0];
    private static final Any[] ZLENANY = new Any[0];
    private static final int INTSIZE = 4;
    private static final int SHORTSIZE = 2;
    private static final int DATESIZE = 7;

    public static ResultSet createSingleRow(short[] columnPositions, Object[] columnValues) throws IOException {
        ResultSet rs = new ResultSet();
        ColumnDelineator cd = new ColumnDelineator();
        return ResultSetFactory.createSingleRow(columnPositions, columnValues, false, rs, cd);
    }

    public static ResultSet createSingleRow(short[] columnPositions, Object[] columnValues, boolean utf) throws IOException {
        ResultSet rs = new ResultSet();
        ColumnDelineator cd = new ColumnDelineator();
        return ResultSetFactory.createSingleRow(columnPositions, columnValues, utf, rs, cd);
    }

    public static ResultSet createSingleRow(short[] columnPositions, Object[] columnValues, boolean utf, ResultSet rs, ColumnDelineator cd) throws IOException {
        if (columnPositions == null || columnPositions.length == 0) {
            return null;
        }
        if (columnValues == null || columnValues.length == 0) {
            return null;
        }
        int len = columnPositions.length;
        byte[] lengthInBytes = new byte[1 + 2 * len];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        lengthInBytes[0] = 2;
        int offset = 1;
        int lengthOfColumn = 0;
        int i = 0;
        while (i < columnValues.length) {
            int j;
            if (columnValues[i] instanceof String) {
                int dsize = dos.size();
                if (utf) {
                    dos.writeUTF((String)columnValues[i]);
                } else {
                    dos.writeBytes((String)columnValues[i]);
                }
                lengthOfColumn = dos.size() - dsize;
                offset += LengthinBytes.PutLength(lengthInBytes, offset, lengthOfColumn, (byte)2);
            } else if (columnValues[i] instanceof byte[]) {
                lengthOfColumn = ((byte[])columnValues[i]).length;
                offset += LengthinBytes.PutLength(lengthInBytes, offset, lengthOfColumn, (byte)2);
                dos.write((byte[])columnValues[i], 0, lengthOfColumn);
            } else if (columnValues[i] instanceof int[]) {
                int ilen = ((int[])columnValues[i]).length;
                j = 0;
                while (j < ilen) {
                    offset += LengthinBytes.PutLength(lengthInBytes, offset, 4L, (byte)2);
                    dos.writeInt(((int[])columnValues[i])[j]);
                    ++j;
                }
            } else if (columnValues[i] instanceof short[]) {
                int slen = ((short[])columnValues[i]).length;
                j = 0;
                while (j < slen) {
                    offset += LengthinBytes.PutLength(lengthInBytes, offset, 2L, (byte)2);
                    dos.writeShort(((short[])columnValues[i])[j]);
                    ++j;
                }
            } else if (columnValues[i] instanceof GregorianCalendar) {
                offset += LengthinBytes.PutLength(lengthInBytes, offset, 7L, (byte)2);
                dos.writeByte(((GregorianCalendar)columnValues[i]).get(1) / 100 + 100);
                dos.writeByte(((GregorianCalendar)columnValues[i]).get(1) % 100 + 100);
                dos.writeByte(((GregorianCalendar)columnValues[i]).get(2) + 1);
                dos.writeByte(((GregorianCalendar)columnValues[i]).get(5));
                dos.writeByte(((GregorianCalendar)columnValues[i]).get(11));
                dos.writeByte(((GregorianCalendar)columnValues[i]).get(12));
                dos.writeByte(((GregorianCalendar)columnValues[i]).get(13));
            } else {
                throw new UDException();
            }
            ++i;
        }
        byte[] rowData = baos.toByteArray();
        cd.lobflg = ZLENSHORT;
        cd.pos = columnPositions;
        cd.lob_offset = ZLENLONG;
        cd.len = lengthInBytes;
        rs.snapid = 0;
        rs.tranid = 0;
        rs.flags = 8192;
        rs.numrows = 1;
        rs.rowlen = new int[]{rowData.length};
        rs.cold = cd;
        rs.siz = rowData.length;
        rs.buf = rowData;
        rs.xtensions = ZLENANY;
        return rs;
    }

    public static int[] decodeLengths(int numCols, byte[] len, boolean isNormalized) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(len);
        DataInputStream dis = new DataInputStream(bais);
        int[] columnSize = new int[numCols];
        if (isNormalized) {
            byte numLenBytes = (byte)(dis.readByte() & 0xF);
            int i = 0;
            while (i < numCols) {
                columnSize[i] = (int)LengthinBytes.GetLength(dis, numLenBytes);
                ++i;
            }
        } else {
            Lenobj lobj = null;
            int i = 0;
            while (i < numCols) {
                lobj = LengthinBytes.GetLength(dis);
                if (lobj.colbytes == 0L) {
                    lobj.colbytes = 1L;
                }
                int j = 0;
                while ((long)j < lobj.colbytes) {
                    columnSize[i + j] = (int)lobj.lenbytes;
                    ++j;
                }
                i = (int)((long)i + lobj.colbytes);
            }
        }
        return columnSize;
    }

    public static int[] decodeLengths(ResultSet resultSet, int numCols) throws IOException {
        boolean isNormalized = (resultSet.flags & 0x2000) > 0;
        return ResultSetFactory.decodeLengths(numCols, resultSet.cold.len, isNormalized);
    }

    public static int getIntegerColumn(byte[] buf, int offset) {
        int tmpint = (buf[offset] & 0xFF) << 24;
        tmpint += (buf[offset + 1] & 0xFF) << 16;
        tmpint += (buf[offset + 2] & 0xFF) << 8;
        return tmpint += buf[offset + 3] & 0xFF;
    }

    public static String getStringColumn(DataInputStream dis, int length, boolean utf) throws IOException {
        if (utf) {
            return new String(dis.readUTF());
        }
        byte[] tmp_array = new byte[length];
        dis.readFully(tmp_array);
        return new String(tmp_array);
    }

    public static String getStringColumn(byte[] buf, int offset, int length, boolean utf) throws IOException {
        if (utf) {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf, offset, length);
            DataInputStream dis = new DataInputStream(bis);
            return new String(dis.readUTF());
        }
        return new String(buf, offset, length);
    }

    public static void setIntegerColumn(byte[] buf, int offset, int value) {
        buf[offset] = (byte)(value >> 24);
        buf[offset + 1] = (byte)(value >> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >> 8 & 0xFF);
        buf[offset + 3] = (byte)(value & 0xFF);
    }

    public static void updateSingleRow(ResultSet rs, int columnNumber, Object columnValue) throws IOException {
        ResultSetFactory.updateSingleRow(rs, columnNumber, columnValue, false);
    }

    public static void updateSingleRow(ResultSet rs, int columnNumber, Object columnValue, boolean utfconv) throws IOException {
        int[] columnSize = ResultSetFactory.decodeLengths(rs, rs.numrows * rs.cold.pos.length);
        int numCols = columnSize.length;
        byte[] columnLengths = new byte[5 * numCols];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(rs.buf.length);
        DataOutputStream dos = new DataOutputStream(baos);
        int offset = 0;
        int rowOffset = 0;
        int i = 0;
        while (i < numCols) {
            if (i + 1 == columnNumber) {
                int dsize = dos.size();
                if (columnValue instanceof byte[]) {
                    dos.write((byte[])columnValue);
                } else if (columnValue instanceof String) {
                    if (utfconv) {
                        dos.writeUTF((String)columnValue);
                    } else {
                        dos.writeBytes((String)columnValue);
                    }
                }
                int collen = dos.size() - dsize;
                offset += LengthinBytes.PutLength(columnLengths, offset, collen);
            } else {
                offset += LengthinBytes.PutLength(columnLengths, offset, columnSize[i]);
                dos.write(rs.buf, rowOffset, columnSize[i]);
            }
            rowOffset += columnSize[i];
            ++i;
        }
        rs.flags = 0;
        rs.cold.len = columnLengths;
        rs.buf = baos.toByteArray();
        rs.siz = rs.buf.length;
        rs.rowlen[0] = rs.buf.length;
    }
}

