/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.ca.CAWizardPanel;
import oracle.net.ca.CAWizardUtils;
import oracle.net.ca.NetStrings;

public class CAPanelLDAPinfo
extends EwtContainer
implements CAWizardPanel {
    private boolean guiInitialized = false;
    private Component invalidComponent;
    private static final String DEFAULT_PORT = "389";
    private static final String DEFAULT_PORT_SSL = "636";
    private static final NetStrings netstr = new NetStrings();
    private LWTextField hostField = new LWTextField("");
    private LWTextField portField = new LWTextField("389");
    private LWTextField sslField = new LWTextField("636");

    public String getHost() {
        return this.hostField.getText();
    }

    public String getPort() {
        return this.portField.getText();
    }

    public String getSSLPort() {
        return this.sslField.getText();
    }

    public void disablePort() {
        this.portField.setEnabled(false);
        this.sslField.setEnabled(false);
        this.portField.setText("");
        this.sslField.setText("");
    }

    public void buildGUI() {
        if (this.guiInitialized) {
            return;
        }
        this.guiInitialized = true;
        LWLabel lWLabel = new LWLabel(netstr.getString("LDAPDirLocText"));
        LWLabel lWLabel2 = new LWLabel(netstr.getString("LDAPDirLocHost"));
        LWLabel lWLabel3 = new LWLabel(netstr.getString("LDAPDirLocPort"));
        LWLabel lWLabel4 = new LWLabel(netstr.getString("LDAPDirLocSSLPort"));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 25;
        ((Container)((Object)this)).add((Component)lWLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.right = 5;
        ((Container)((Object)this)).add((Component)lWLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Container)((Object)this)).add((Component)this.hostField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        ((Container)((Object)this)).add((Component)lWLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Container)((Object)this)).add((Component)this.portField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        ((Container)((Object)this)).add((Component)lWLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Container)((Object)this)).add((Component)this.sslField, gridBagConstraints);
    }

    public boolean areDataValid() {
        String string = this.getHost().trim();
        this.getPort().trim();
        this.getSSLPort().trim();
        if (string.equals("")) {
            this.invalidComponent = this.hostField;
            return false;
        }
        return true;
    }

    public void explainError() {
        String string = null;
        if (this.invalidComponent == this.hostField) {
            string = netstr.getString("LDAPhostErr");
        }
        Alert alert = new Alert(CAWizardUtils.getParentFrame((Component)((Object)this)), string, 1, 1);
        alert.setTitle(netstr.getString("Title"));
        alert.runAlert();
        alert.dispose();
    }

    public void explainErrorNaming() {
        String string = netstr.getString("LDAPnamErr");
        Alert alert = new Alert(CAWizardUtils.getParentFrame((Component)((Object)this)), string, 1, 1);
        alert.setTitle(netstr.getString("Title"));
        alert.runAlert();
        alert.dispose();
    }

    public void focusOnInvalidField() {
        if (this.invalidComponent != null) {
            this.invalidComponent.requestFocus();
        }
    }

    public void reset() {
        this.hostField.setText("");
        this.portField.setEnabled(true);
        this.portField.setText(DEFAULT_PORT);
        this.sslField.setEnabled(true);
        this.sslField.setText(DEFAULT_PORT_SSL);
    }

    public boolean isGuiInitialized() {
        return this.guiInitialized;
    }
}

