/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.shuttle.ListPicker;
import oracle.ewt.shuttle.MultiItemPicker;
import oracle.ewt.shuttle.Shuttle;
import oracle.ewt.shuttle.ToMultiItemPicker;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.ca.CAWizardPanel;
import oracle.net.ca.CAWizardUtils;
import oracle.net.ca.NetStrings;

public class CAPanelListenerProtocols
extends EwtContainer
implements CAWizardPanel {
    private boolean guiInitialized = false;
    private Component invalidComponent;
    static final NetStrings netstr = new NetStrings();
    String[] installedProtocolList;
    String[] SelectedProtocols;
    LWList toList;
    LWList fromList;
    String preferredProtocol;

    public CAPanelListenerProtocols(String[] stringArray, String string) {
        this.installedProtocolList = stringArray;
        this.preferredProtocol = string;
    }

    public String[] getSelectedProtocols() {
        return this.toList.getItems();
    }

    public int getSelectedProtocolsNum() {
        return this.toList.getItemCount();
    }

    public void buildGUI() {
        if (this.guiInitialized) {
            return;
        }
        this.guiInitialized = true;
        MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), netstr.getString("LIprtcl"));
        multiLineLabel.setPreferredAspectRatio(6.0f);
        Shuttle shuttle = new Shuttle();
        shuttle.setMoveAllAllowed(false);
        this.buildShuttleFromList(shuttle);
        this.buildShuttleToList(shuttle);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 1, 5, 1);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 0;
        ((Container)((Object)this)).add((Component)shuttle, gridBagConstraints);
    }

    private void buildShuttleFromList(Shuttle shuttle) {
        this.fromList = new LWList(4, true);
        int n = 0;
        while (this.installedProtocolList[n] != null) {
            this.fromList.add(this.installedProtocolList[n]);
            ++n;
        }
        ListPicker listPicker = new ListPicker(this.fromList);
        listPicker.setSortItems(false);
        shuttle.setFromPicker((MultiItemPicker)listPicker);
        shuttle.setFromHeader((Component)new LWLabel(netstr.getString("LIfromHeader")));
    }

    private void buildShuttleToList(Shuttle shuttle) {
        this.toList = new LWList(4, true);
        String string = this.preferredProtocol;
        this.toList.add(string);
        try {
            this.fromList.remove(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        ListPicker listPicker = new ListPicker(this.toList);
        listPicker.setSortItems(false);
        shuttle.setToPicker((ToMultiItemPicker)listPicker);
        shuttle.setToHeader((Component)new LWLabel(netstr.getString("LItoHeader")));
    }

    public boolean areDataValid() {
        return this.toList.getItemCount() != 0;
    }

    public void explainError() {
        String string = netstr.getString("LIprtclErr");
        Alert alert = new Alert(CAWizardUtils.getParentFrame((Component)((Object)this)), string, 1, 1);
        alert.setTitle(netstr.getString("Title"));
        alert.runAlert();
        alert.dispose();
    }

    public void focusOnInvalidField() {
        this.toList.requestFocus();
    }

    public void reset() {
    }

    public boolean isGuiInitialized() {
        return this.guiInitialized;
    }
}

