/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.shuttle.ListPicker;
import oracle.ewt.shuttle.MultiItemPicker;
import oracle.ewt.shuttle.Shuttle;
import oracle.ewt.shuttle.ToMultiItemPicker;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.ca.CAWizardPanel;
import oracle.net.ca.CAWizardUtils;
import oracle.net.ca.NetStrings;

public class CAPanelNamingMethods
extends EwtContainer
implements CAWizardPanel {
    private boolean guiInitialized = false;
    private Component invalidComponent;
    static final NetStrings netstr = new NetStrings();
    String[] SelectedMethods;
    LWList toList;
    LWList fromList;
    Shuttle shuttle = new Shuttle();
    MultiLineLabel varLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), "");

    public CAPanelNamingMethods() {
        this.shuttle.setMoveAllAllowed(false);
        this.buildShuttleFromList(this.shuttle);
        this.buildShuttleToList(this.shuttle);
    }

    public void setLabel(String string) {
        this.varLabel.setText(string);
        this.varLabel.setPreferredAspectRatio(5.0f);
    }

    public String[] getSelectedMethods() {
        return this.toList.getItems();
    }

    public int getSelectedMethodsNum() {
        return this.toList.getItemCount();
    }

    public void addAvailableMethod(boolean bl) {
        String string;
        if (bl && !this.isInList(this.fromList, string = netstr.getString("NAMavLDAP"))) {
            this.fromList.add(string);
        }
    }

    public void addSelectedMethod(String string) {
        if (!this.isInList(this.toList, string)) {
            this.toList.add(string);
        }
        try {
            this.fromList.remove(string);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void addSelectedMethods(String[] stringArray) {
        String string = null;
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (stringArray[n] != null) {
            if (stringArray[n].equals("LDAP")) {
                string = netstr.getString("NAMavLDAP");
            } else if (stringArray[n].equals("TNSNAMES")) {
                string = netstr.getString("NAMavLocal");
            } else if (stringArray[n].equals("ONAMES")) {
                string = netstr.getString("NAMavOraNames");
            } else if (stringArray[n].equals("HOSTNAME")) {
                string = netstr.getString("NAMavHostName");
            } else if (stringArray[n].equals("NOVELL")) {
                string = netstr.getString("NAMavNovell");
            } else if (stringArray[n].equals("NIS")) {
                string = netstr.getString("NAMavSUN");
            } else if (stringArray[n].equals("DCE")) {
                string = netstr.getString("NAMavDCE");
            }
            if (!this.isInList(this.toList, string)) {
                this.toList.add(string);
            }
            try {
                this.fromList.remove(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++n;
        }
    }

    private void buildShuttleFromList(Shuttle shuttle) {
        this.fromList = new LWList(5, true);
        this.fromList.add(netstr.getString("NAMavLocal"));
        this.fromList.add(netstr.getString("NAMavOraNames"));
        this.fromList.add(netstr.getString("NAMavHostName"));
        this.fromList.add(netstr.getString("NAMavNovell"));
        this.fromList.add(netstr.getString("NAMavSUN"));
        this.fromList.add(netstr.getString("NAMavDCE"));
        ListPicker listPicker = new ListPicker(this.fromList);
        listPicker.setSortItems(false);
        shuttle.setFromPicker((MultiItemPicker)listPicker);
        shuttle.setFromHeader((Component)new LWLabel(netstr.getString("NAMfromHeader")));
    }

    private void buildShuttleToList(Shuttle shuttle) {
        this.toList = new LWList(5, true);
        ListPicker listPicker = new ListPicker(this.toList);
        listPicker.setSortItems(false);
        shuttle.setToPicker((ToMultiItemPicker)listPicker);
        shuttle.setToHeader((Component)new LWLabel(netstr.getString("NAMtoHeader")));
    }

    private boolean isInList(LWList lWList, String string) {
        String[] stringArray = lWList.getItems();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void buildGUI() {
        if (this.guiInitialized) {
            return;
        }
        this.guiInitialized = true;
        MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), netstr.getString("NAMmethods1"));
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(WordWrapper.getTextWrapper(), netstr.getString("NAMmethods2"));
        multiLineLabel.setPreferredAspectRatio(5.0f);
        multiLineLabel2.setPreferredAspectRatio(5.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add((Component)this.varLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        ((Container)((Object)this)).add((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add((Component)multiLineLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        ((Container)((Object)this)).add((Component)this.shuttle, gridBagConstraints);
    }

    public boolean areDataValid() {
        return this.toList.getItemCount() != 0;
    }

    public void explainError() {
        String string = netstr.getString("NAMmethods");
        Alert alert = new Alert(CAWizardUtils.getParentFrame((Component)((Object)this)), string, 1, 1);
        alert.setTitle(netstr.getString("Title"));
        alert.runAlert();
        alert.dispose();
    }

    public void focusOnInvalidField() {
        this.toList.requestFocus();
    }

    public void reset() {
    }

    public boolean isGuiInitialized() {
        return this.guiInitialized;
    }
}

