/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.ca.CAWizardPanel;
import oracle.net.ca.CAWizardUtils;
import oracle.net.ca.NetStrings;

public class CAPanelNetServiceNameProtocols
extends EwtContainer
implements CAWizardPanel {
    private boolean guiInitialized = false;
    private Component invalidComponent;
    static final NetStrings netstr = new NetStrings();
    LWList protocolList;
    String[] installedProtocolList;

    public CAPanelNetServiceNameProtocols(String[] stringArray) {
        this.installedProtocolList = stringArray;
    }

    public String getSelectedProtocol() {
        return this.protocolList.getSelectedItem();
    }

    public void buildGUI() {
        if (this.guiInitialized) {
            return;
        }
        this.guiInitialized = true;
        MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), netstr.getString("NAMNetSNprtcl"));
        multiLineLabel.setPreferredAspectRatio(10.0f);
        this.buildProtocolList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(5, 1, 5, 1);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        ((Container)((Object)this)).add((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        ((Container)((Object)this)).add((Component)this.protocolList, gridBagConstraints);
    }

    private void buildProtocolList() {
        this.protocolList = new LWList(4, false);
        int n = 0;
        while (this.installedProtocolList[n] != null) {
            this.protocolList.add(this.installedProtocolList[n]);
            ++n;
        }
        if (this.installedProtocolList[0] != null) {
            this.protocolList.select(0);
        }
    }

    public boolean areDataValid() {
        return this.protocolList.getSelectedIndex() != -1;
    }

    public void explainError() {
        String string = netstr.getString("NAMNetSNprtclErr");
        Alert alert = new Alert(CAWizardUtils.getParentFrame((Component)((Object)this)), string, 1, 1);
        alert.setTitle(netstr.getString("Title"));
        alert.runAlert();
        alert.dispose();
    }

    public void focusOnInvalidField() {
        this.protocolList.requestFocus();
    }

    public void reset() {
    }

    public boolean isGuiInitialized() {
        return this.guiInitialized;
    }
}

