/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.net.ca.IllegalOptionException;
import oracle.net.ca.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.common.NetProperties;

public class CmdlineArgs {
    private Hashtable vars;
    private NetProperties NetProp;
    private final NetStrings netstr = new NetStrings();
    private boolean standAlone;
    private boolean configLDAP;

    public CmdlineArgs() {
        this.vars = new Hashtable(20);
    }

    public void initArgs() {
        this.vars.put("silent", new Boolean(false));
        this.vars.put("responseFile", "NO_VALUE");
        this.vars.put("deinst", new Boolean(false));
        this.vars.put("instype", "NO_VALUE");
        this.vars.put("inscomp", "net8");
        this.vars.put("insprtcl", "NO_VALUE");
        this.vars.put("orahid", "NO_VALUE");
        this.vars.put("orahnam", "NO_VALUE");
        this.vars.put("orahome", "NO_VALUE");
        this.vars.put("cfg", "local");
        this.vars.put("authadp", "NO_VALUE");
    }

    public boolean setOraArgs(String string) {
        String string2;
        String string3 = NetGetEnv.getOracleHome();
        if (this.getStringArgs("orahome").equals("NO_VALUE")) {
            this.vars.put("orahome", string3);
        } else {
            string2 = this.getStringArgs("orahome");
            if (!string2.equalsIgnoreCase(string3)) {
                return false;
            }
        }
        if (this.getStringArgs("orahid").equalsIgnoreCase("NO_VALUE") && string.startsWith("Windows")) {
            string2 = NetGetEnv.getOracleHomeID();
            this.vars.put("orahid", string2);
        }
        if (this.getStringArgs("orahnam").equals("NO_VALUE") && string.startsWith("Windows")) {
            string2 = NetGetEnv.getOracleHomeName();
            this.vars.put("orahnam", string2);
        }
        return true;
    }

    public boolean isSilent() {
        return this.getBooleanArgs("silent");
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public void setStandAlone(boolean bl) {
        this.standAlone = bl;
    }

    public void setConfigType(boolean bl) {
        this.configLDAP = bl;
    }

    public boolean isConfigLocal() {
        return !this.configLDAP;
    }

    public boolean isComponentInstalled(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getStringArgs("inscomp"), ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isProtocolInstalled(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getStringArgs("insprtcl"), ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void addInsComponent(String string) {
        if (!this.isComponentInstalled(string)) {
            String string2 = this.getStringArgs("inscomp");
            String string3 = String.valueOf(string2) + "," + string;
            this.vars.put("inscomp", string3);
        }
    }

    public void removeInsComponent(String string) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isComponentInstalled(string)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.getStringArgs("inscomp"), ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(string)) continue;
            stringBuffer.append(String.valueOf(string2) + ",");
        }
        string2 = stringBuffer.toString();
        String string3 = string2.substring(0, string2.length() - 1);
        this.vars.put("inscomp", string3);
    }

    public String[] getInstalledProtocols(boolean bl) {
        boolean bl2;
        String[] stringArray = new String[10];
        String[] stringArray2 = new String[]{"TCP", "TCPS", "IPC", "NMP", "SPX"};
        String string = this.getStringArgs("insprtcl");
        boolean bl3 = bl2 = this.isComponentInstalled("server") && System.getProperty("os.name").equals("Windows 95");
        if (bl || string.equals("NO_VALUE")) {
            int n = 0;
            int n2 = 0;
            while (n2 < 5) {
                String string2 = this.NetProp.getProperty(stringArray2[n2]);
                if (string2 != null && string2.equalsIgnoreCase("yes") && (bl2 && !stringArray2[n2].equals("NMP") || !bl2)) {
                    stringArray[n++] = stringArray2[n2];
                }
                ++n2;
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if ((!bl2 || string3.equalsIgnoreCase("nmp")) && bl2) continue;
                stringArray[n] = string3.toUpperCase();
                ++n;
            }
        }
        return stringArray;
    }

    public String getPreferredProtocol() {
        String string = null;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getStringArgs("insprtcl"), ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            int n = 1;
            while (this.NetProp.getProperty("p" + n) != null) {
                string = "p" + n;
                if (this.NetProp.getProperty(string).equalsIgnoreCase(string2)) {
                    return string2.toUpperCase();
                }
                ++n;
            }
        }
        return "TCP";
    }

    public void saveParameters() {
        String string = "";
        String string2 = null;
        try {
            this.NetProp = NetProperties.getInstance();
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.netstr.getString("SOCreatePropertiesIO")) + iOException.getMessage());
        }
        string2 = this.NetProp.getProperty("INSTALLEDCOMPONENTS");
        if (string2 != null && string2.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (this.isComponentInstalled(string3)) continue;
                string = String.valueOf(string) + string3 + ",";
            }
        }
        this.NetProp.putProperty("INSTALLEDCOMPONENTS", String.valueOf(string) + this.getStringArgs("inscomp").toUpperCase());
        if (this.isProtocolInstalled("TCP")) {
            this.NetProp.putProperty("TCP", "yes");
        }
        if (this.isProtocolInstalled("TCPS")) {
            this.NetProp.putProperty("TCPS", "yes");
        }
        if (this.isProtocolInstalled("IPC")) {
            this.NetProp.putProperty("IPC", "yes");
        }
        if (this.isProtocolInstalled("NMP")) {
            this.NetProp.putProperty("NMP", "yes");
        }
        if (this.isProtocolInstalled("SPX")) {
            this.NetProp.putProperty("SPX", "yes");
        }
        try {
            this.NetProp.save();
            return;
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.netstr.getString("SOSavePropertiesIO")) + iOException.getMessage());
            return;
        }
    }

    public String getStringArgs(String string) {
        String string2 = (String)this.vars.get(string);
        return string2;
    }

    public int getNumberArgs(String string) {
        return (Integer)this.vars.get(string);
    }

    public boolean getBooleanArgs(String string) {
        return (Boolean)this.vars.get(string);
    }

    public void parseArgs(String[] stringArray) throws IllegalOptionException {
        new CmdlineArgs();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if ((string = stringArray[n++]).charAt(0) != '/') {
                throw new IllegalOptionException(String.valueOf(this.netstr.getString("SOParamMissing")) + string);
            }
            Object v = this.vars.get(string = string.substring(1).toLowerCase());
            if (v instanceof Boolean) {
                System.out.println(String.valueOf(this.netstr.getString("SOParamParam")) + "\"" + string + "\" = " + new Boolean(true));
                this.vars.put(string, new Boolean(true));
                continue;
            }
            if (v instanceof Integer) {
                int n2;
                try {
                    n2 = Integer.parseInt(stringArray[n++]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalOptionException("invalid number argument for " + string);
                }
                System.out.println(String.valueOf(this.netstr.getString("SOParamParam")) + "\"" + string + "\" = " + new Integer(n2));
                this.vars.put(string, new Integer(n2));
                continue;
            }
            System.out.println(String.valueOf(this.netstr.getString("SOParamParam")) + "\"" + string + "\" = " + stringArray[n]);
            this.vars.put(string, stringArray[n++]);
        }
    }

    public void printArgs() {
        System.out.println("silent: " + this.getBooleanArgs("silent"));
        System.out.println("instype: " + this.getStringArgs("instype"));
        System.out.println("inscomp: " + this.getStringArgs("inscomp"));
        System.out.println("insprtcl: " + this.getStringArgs("insprtcl"));
        System.out.println("orahid: " + this.getStringArgs("orahid"));
        System.out.println("orahnam: " + this.getStringArgs("orahnam"));
        System.out.println("orahome: " + this.getStringArgs("orahome"));
        System.out.println("cfg: " + this.getStringArgs("cfg"));
        System.out.println("authadp: " + this.getStringArgs("authadp"));
    }

    private void addStringArgs(String string, String string2) {
        this.vars.put(string, string2);
    }

    private void addNumberArgs(String string, int n) {
        this.vars.put(string, new Integer(n));
    }

    private void addBooleanArgs(String string) {
        this.vars.put(string, new Boolean(false));
    }
}

