/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.File;
import java.util.Vector;
import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.NetStrings;
import oracle.net.ca.OPSUtil;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.ops.config.cluster.ClusterRegister;

public class ConfigureLDAP {
    public Config config;
    private String dsAddr;
    private String dsType;
    private String oracleContext;
    private String[] userCredentials = new String[2];
    private int authMethod;
    String oraHome;
    String os;
    private final NetStrings netstr = new NetStrings();
    private static final int NATIVE = 8;
    private static final int SSL = 7;
    private static final int SIMPLE = 1;
    private CmdlineArgs cmdarg;
    private File fileAdminDir;

    public ConfigureLDAP(CmdlineArgs cmdlineArgs, File file) {
        this.cmdarg = cmdlineArgs;
        this.fileAdminDir = file;
        this.oraHome = this.cmdarg.getStringArgs("orahome");
    }

    public void initConfig(CmdlineArgs cmdlineArgs, String[] stringArray) {
        this.authMethod = 1;
        this.userCredentials[0] = null;
        this.userCredentials[1] = null;
        this.oraHome = cmdlineArgs.getStringArgs("orahome");
        this.os = this.os = System.getProperty("os.name");
        try {
            this.config = new Config(this.oraHome, this.authMethod, this.userCredentials);
        }
        catch (ConfigException configException) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExCreate")) + (Object)((Object)configException));
        }
        this.config.netConfigUsesLDAP(false);
    }

    public boolean isLDAPConfigured() {
        this.dsType = this.config.getDirectoryType();
        return this.dsType != null;
    }

    public String getDirectoryType() {
        return this.dsType;
    }

    public void setDirectoryType(String string) {
        this.dsType = string;
    }

    public void setOracleContext(String string) {
        this.oracleContext = string;
    }

    public int createOracleContext(String string) {
        try {
            if (!this.dsType.equalsIgnoreCase("AD")) {
                this.config.namingContext(string);
            }
            this.config.initLDIF(this.dsAddr, this.dsType, this.authMethod, this.userCredentials);
            this.setOracleContext(this.config.oracleContext());
        }
        catch (ConfigException configException) {
            System.out.println(String.valueOf(this.netstr.getString("LDAPCreateCtxErr")) + (Object)((Object)configException));
            return 1;
        }
        return 0;
    }

    public String[] getDirectoryServers() {
        return this.config.getDirectoryServers();
    }

    public void setDirectoryHost(String string) {
        this.dsAddr = string;
        this.config.setDirectoryServers(new String[]{string});
    }

    public String[] getNamingContextList() {
        String[] stringArray = null;
        stringArray = Config.getNamingContexts((String)this.dsAddr, (String)this.dsType);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public String[] getOracleContextList(String string) {
        Object[] objectArray = Config.getOracleSoftware((String)string, (int)this.authMethod, (String[])this.userCredentials, (String)this.dsAddr, (String)this.dsType);
        if (objectArray != null) {
            int n = new String("cn=OracleContext,").length();
            Vector<Object> vector = new Vector<Object>(objectArray.length);
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] != null) {
                    objectArray[n2] = ((String)objectArray[n2]).substring(n, ((String)objectArray[n2]).length());
                    vector.addElement(objectArray[n2]);
                }
                ++n2;
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return new String[0];
    }

    public String getOracleContextLocation() {
        if (this.oracleContext.toLowerCase().startsWith("cn=oraclecontext,")) {
            return this.oracleContext.substring("cn=oraclecontext,".length(), this.oracleContext.length());
        }
        return this.oracleContext;
    }

    public void setCredentials(String[] stringArray) {
        this.userCredentials = stringArray;
        if (this.userCredentials[0] == "") {
            this.userCredentials[0] = null;
        }
        if (this.userCredentials[1] == "") {
            this.userCredentials[1] = null;
        }
    }

    public void setAuthMethod(int n) {
        this.authMethod = n;
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public boolean schemaExists() {
        boolean bl = false;
        try {
            bl = this.config.schemaExists();
        }
        catch (ConfigException configException) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExSchemaEx")) + (Object)((Object)configException));
        }
        return bl;
    }

    public String createSchema() {
        try {
            Config.initSchemaOnly((String)this.dsAddr, (String)this.dsType, null, (String)this.oraHome, (int)this.authMethod, (String[])this.userCredentials);
            return null;
        }
        catch (ConfigException configException) {
            String string = String.valueOf(this.netstr.getString("SOConfigExSchemaCr")) + (Object)((Object)configException);
            System.err.println(string);
            return string;
        }
    }

    public int testConnection() throws ConfigException {
        try {
            if (this.os.startsWith("Windows") && this.getDirectoryType().equalsIgnoreCase("AD")) {
                this.config.bind(8, this.userCredentials);
                return 8;
            }
        }
        catch (ConfigException configException) {}
        try {
            this.config.bind(7, this.userCredentials);
            return 7;
        }
        catch (ConfigException configException) {
            this.config.bind(1, this.userCredentials);
            return 1;
        }
    }

    public void initLDAP(CmdlineArgs cmdlineArgs) {
        String string = cmdlineArgs.getStringArgs("orahnam");
        String string2 = cmdlineArgs.getStringArgs("orahid");
        if (string == "NO_VALUE") {
            string = null;
        }
        if (string2 == "NO_VALUE") {
            string2 = null;
        }
        try {
            Config.init((String)this.oraHome, (String)string, (String)string2, (boolean)false, (String)this.dsType, (String)this.dsAddr, (boolean)false, (String)this.getOracleContextLocation(), (int)this.authMethod, (String[])this.userCredentials);
            return;
        }
        catch (ConfigException configException) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExInit")) + configException.getMessage());
            return;
        }
    }

    public void initLDAPOPS(String[] stringArray, CmdlineArgs cmdlineArgs) {
        this.initLDAP(cmdlineArgs);
        boolean bl = true;
        while (bl) {
            bl = false;
            String string = this.OPSHelper(0, stringArray);
            if (string.length() <= 0) continue;
            bl = OPSUtil.Alert(string);
        }
    }

    public void reCreateConfig() {
        try {
            this.config = new Config(this.oraHome, this.authMethod, this.userCredentials);
            return;
        }
        catch (ConfigException configException) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExCreate")) + (Object)((Object)configException));
            return;
        }
    }

    public void saveLDAP() {
        try {
            this.config.setDirectoryType(this.dsType);
            this.config.save();
            return;
        }
        catch (ConfigException configException) {
            System.out.println(String.valueOf(this.netstr.getString("SOConfigExSave")) + configException.getMessage());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String OPSHelper(int var1_1, String[] var2_2) {
        var5_3 = this.config.getFilename(5);
        var6_4 = "";
        var8_5 = new String();
        var3_6 = 0;
        while (var3_6 < var2_2.length) {
            var8_5 = String.valueOf(var8_5) + var2_2[var3_6] + "|";
            ++var3_6;
        }
        var3_6 = 0;
        var9_7 = File.separator;
        var11_8 = this.fileAdminDir.getAbsolutePath();
        var10_9 = new String(String.valueOf(var11_8) + var9_7 + "opstmp");
        var12_10 = new File(var10_9);
        if (!var12_10.exists()) {
            var12_10.mkdir();
        }
        var7_11 = new ClusterRegister(var10_9);
        while (var3_6 < var2_2.length) {
            switch (var1_1) {
                default: 
            }
            var4_12 = new String("CopyFileNode|" + var5_3 + "|" + var5_3 + "|" + var2_2[var3_6]);
            var7_11.writeClusterLog(var4_12);
            ++var3_6;
        }
        if (var7_11.finalCluster(var8_5)) ** GOTO lbl37
        return this.netstr.getString("OPSAPI");
lbl-1000:
        // 1 sources

        {
            OPSUtil.print(".");
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v0) {
                var13_13 = 0;
                ** while (var13_13 < 1000)
            }
lbl-1000:
            // 1 sources

            {
                ++var13_13;
                continue;
            }
lbl37:
            // 3 sources

            ** while (!var7_11.doneProcessing())
        }
lbl38:
        // 1 sources

        OPSUtil.println();
        var6_4 = OPSUtil.ClusterErrorMsg(var7_11, var2_2);
        if (var12_10.exists()) {
            var12_10.delete();
        }
        return var6_4;
    }
}

