/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.net.ca.CAWizardPanel;
import oracle.net.ca.NetStrings;

public class OPSPanelListOfActiveNodes
extends EwtContainer
implements CAWizardPanel,
ActionListener {
    private boolean guiInitialized = false;
    private Component invalidComponent;
    private static String SELECT_ALL = "SELECT_ALL";
    private static String DESELECT_ALL = "DESELECT_ALL";
    static final NetStrings netstr = new NetStrings();
    private LWList m_nodeList;
    private MultiLineLabel m_nodeLabel;
    private MultiLineLabel m_nodeListLabel;
    private LWButton m_selectNodeList;
    private LWButton m_deselectNodeList;
    private String[] OPSNodeNames;

    public void buildGUI() {
        if (this.guiInitialized) {
            return;
        }
        this.guiInitialized = true;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(gridBagLayout);
        this.m_nodeLabel = new MultiLineLabel(netstr.getString("activeNodesLabel"));
        gridBagConstraints.insets = new Insets(10, 3, 10, 3);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        ((Container)((Object)this)).add((Component)this.m_nodeLabel, gridBagConstraints);
        this.m_nodeListLabel = new MultiLineLabel(netstr.getString("activeNodesListLabel"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        ((Container)((Object)this)).add((Component)this.m_nodeListLabel, gridBagConstraints);
        this.m_nodeList = new LWList(5, true);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        ((Container)((Object)this)).add((Component)this.m_nodeList, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.m_selectNodeList = new LWButton(netstr.getString("selectAllActiveNodesList"));
        this.m_selectNodeList.addActionListener((ActionListener)this);
        this.m_selectNodeList.setActionCommand(SELECT_ALL);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 3;
        ((Container)((Object)this)).add((Component)this.m_selectNodeList, gridBagConstraints);
        this.m_deselectNodeList = new LWButton(netstr.getString("deselectAllActiveNodesList"));
        this.m_deselectNodeList.addActionListener((ActionListener)this);
        this.m_deselectNodeList.setActionCommand(DESELECT_ALL);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 4;
        ((Container)((Object)this)).add((Component)this.m_deselectNodeList, gridBagConstraints);
        this.m_nodeList.removeAll();
        if (this.OPSNodeNames != null) {
            int n = 0;
            while (n < this.OPSNodeNames.length) {
                if (this.OPSNodeNames[n] != null) {
                    this.m_nodeList.addItem(this.OPSNodeNames[n]);
                }
                ++n;
            }
        }
        this.selectAll();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == DESELECT_ALL) {
            this.deselectAll();
            return;
        }
        if (string == SELECT_ALL) {
            this.selectAll();
        }
    }

    private void deselectAll() {
        if (this.OPSNodeNames != null) {
            int n = 0;
            while (n < this.OPSNodeNames.length) {
                if (this.OPSNodeNames[n] != null) {
                    this.m_nodeList.deselect(n);
                }
                ++n;
            }
        }
    }

    private void selectAll() {
        if (this.OPSNodeNames != null) {
            int n = 0;
            while (n < this.OPSNodeNames.length) {
                if (this.OPSNodeNames[n] != null) {
                    this.m_nodeList.select(n);
                }
                ++n;
            }
        }
    }

    public void addOPSNodeNames(String[] stringArray) {
        this.OPSNodeNames = stringArray;
    }

    public String[] getSelectedNodes() {
        return this.m_nodeList.getSelectedItems();
    }

    public boolean areDataValid() {
        return true;
    }

    public void explainError() {
    }

    public void focusOnInvalidField() {
    }

    public void reset() {
    }

    public boolean isGuiInitialized() {
        return this.guiInitialized;
    }
}

