/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.IOException;
import java.util.StringTokenizer;
import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.ConfigureListener;
import oracle.net.ca.ConfigureProfile;
import oracle.net.ca.ConfigureServiceAlias;
import oracle.net.ca.IniFile;
import oracle.net.ca.NetCA;
import oracle.net.ca.NetStrings;

public class SilentConfigure {
    private boolean done = false;
    private String respFileName;
    private IniFile respFile;
    private Object varList;
    private CmdlineArgs cmdarg;
    private NetCA netca;
    private final NetStrings netstr = new NetStrings();

    public SilentConfigure(NetCA netCA, CmdlineArgs cmdlineArgs) {
        this.cmdarg = cmdlineArgs;
        this.netca = netCA;
        this.respFileName = this.cmdarg.getStringArgs("responsefile");
        if (this.respFileName == null) {
            System.err.println(this.netstr.getString("SOSilentNoRespFile"));
            System.out.println(String.valueOf(this.netstr.getString("SONetConfigFail")) + 1);
            System.exit(1);
            return;
        }
        this.respFile = new IniFile(this.respFileName);
    }

    public boolean performSilentConfigure(ConfigureProfile configureProfile, ConfigureServiceAlias configureServiceAlias, ConfigureListener configureListener) {
        try {
            Object object;
            this.varList = this.respFile.getValue("oracle.net.ca", "INSTALLED_COMPONENTS", "client");
            if (this.varList == null) {
                return false;
            }
            if (this.varList instanceof String[]) {
                object = (String[])this.varList;
                int n = 0;
                while (n < ((String[])object).length) {
                    this.cmdarg.addInsComponent(object[n]);
                    ++n;
                }
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "INSTALL_TYPE", "typical");
            if (this.varList == null) {
                return false;
            }
            if (this.varList instanceof String && (((String)(object = (String)this.varList)).equalsIgnoreCase("typical") || ((String)object).equalsIgnoreCase("minimal"))) {
                configureProfile.typicalConfigure(this.cmdarg);
                if (this.cmdarg.isComponentInstalled("server")) {
                    configureListener.typicalConfigure();
                    configureServiceAlias.typicalConfigure();
                }
                System.out.println(String.valueOf(this.netstr.getString("SONetConfigSuccess")) + 0);
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.netstr.getString("SOSilentReadFailed")) + this.respFile);
            return false;
        }
        this.done = this.silentConfigureListener(configureListener);
        this.done = this.silentConfigureNamingMethods(configureProfile, configureServiceAlias);
        return this.done;
    }

    public boolean silentConfigureListener(ConfigureListener configureListener) {
        String[] stringArray = new String[10];
        String[] stringArray2 = new String[10];
        int n = 0;
        String string = null;
        try {
            String string2;
            int n2;
            String[] stringArray3;
            this.varList = this.respFile.getValue("oracle.net.ca", "LISTENER_NUMBER", "1");
            if (this.varList instanceof Integer) {
                n = (Integer)this.varList;
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "LISTENER_NAMES", "LISTENER");
            if (this.varList instanceof String[]) {
                stringArray3 = (String[])this.varList;
                n2 = 0;
                while (n2 < stringArray3.length) {
                    stringArray[n2] = stringArray3[n2];
                    ++n2;
                }
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "LISTENER_PROTOCOLS", "TCP;1521");
            if (this.varList instanceof String[]) {
                stringArray3 = (String[])this.varList;
                n2 = 0;
                while (n2 < stringArray3.length) {
                    stringArray2[n2] = stringArray3[n2];
                    ++n2;
                }
            }
            int n3 = 0;
            while (n3 < n) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray2[n3], ";");
                String[] stringArray4 = new String[10];
                String[] stringArray5 = new String[10];
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray4[n4] = stringTokenizer.nextToken().toLowerCase();
                    stringArray5[n4] = stringTokenizer.nextToken();
                    ++n4;
                }
                configureListener.setListenerName(stringArray[n3]);
                this.netca.configureListener(stringArray4, stringArray5);
                ++n3;
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "LISTENER_START", "LISTENER");
            if (this.varList instanceof String) {
                string = (String)this.varList;
            }
            if (!(string2 = System.getProperty("os.name")).equals("Windows 95")) {
                configureListener.startListener(string);
            }
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.netstr.getString("SOSilentReadFailed")) + this.respFile);
            return false;
        }
        return true;
    }

    public boolean silentConfigureNamingMethods(ConfigureProfile configureProfile, ConfigureServiceAlias configureServiceAlias) {
        String[] stringArray = new String[10];
        String string = "";
        boolean bl = true;
        try {
            this.varList = this.respFile.getValue("oracle.net.ca", "NAMING_METHODS", "TNSNAMES");
            if (this.varList instanceof String[]) {
                String[] stringArray2 = (String[])this.varList;
                int n = 0;
                while (n < stringArray2.length) {
                    stringArray[n] = stringArray2[n];
                    string = String.valueOf(string) + stringArray2[n] + ",";
                    ++n;
                }
            }
            int n = 0;
            while (stringArray[n] != null) {
                if (stringArray[n].equalsIgnoreCase("NOVELL")) {
                    this.varList = this.respFile.getValue("oracle.net.ca", "NOVELL_NAMECONTEXT", "NAMECONTEXT");
                    if (this.varList instanceof String) {
                        configureProfile.setProfileParam("NAMES.NDS.NAME_CONTEXT", (String)this.varList);
                    }
                }
                if (stringArray[n].equalsIgnoreCase("NIS")) {
                    this.varList = this.respFile.getValue("oracle.net.ca", "SUN_METAMAP", "MAP");
                    if (this.varList instanceof String) {
                        configureProfile.setProfileParam("NAMES.NIS.META_MAP", (String)this.varList);
                    }
                }
                if (stringArray[n].equalsIgnoreCase("DCE")) {
                    this.varList = this.respFile.getValue("oracle.net.ca", "DCE_CELLNAME", "CELL");
                    if (this.varList instanceof String) {
                        configureProfile.setProfileParam("NAMES.NDS.PREFIX", (String)this.varList);
                    }
                }
                if (stringArray[n].equalsIgnoreCase("TNSNAMES")) {
                    bl = this.silentConfigureNetServiceNames(configureServiceAlias);
                }
                ++n;
            }
            configureProfile.setNamesDirPath(string);
            configureProfile.saveProfile();
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.netstr.getString("SOSilentReadFailed")) + this.respFile);
            return false;
        }
        return bl;
    }

    public boolean silentConfigureNetServiceNames(ConfigureServiceAlias configureServiceAlias) {
        String[] stringArray = new String[10];
        String[] stringArray2 = new String[10];
        String[] stringArray3 = new String[10];
        String[] stringArray4 = new String[10];
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            int n2;
            String[] stringArray5;
            this.varList = this.respFile.getValue("oracle.net.ca", "NSN_NUMBER", "1");
            if (this.varList instanceof Integer) {
                n = (Integer)this.varList;
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "NSN_NAMES", "NSN1");
            if (this.varList instanceof String[]) {
                stringArray5 = (String[])this.varList;
                n2 = 0;
                while (n2 < stringArray5.length) {
                    stringArray[n2] = stringArray5[n2];
                    ++n2;
                }
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "NSN_DBVERSION", "81");
            if (this.varList instanceof String[]) {
                stringArray5 = (String[])this.varList;
                n2 = 0;
                while (n2 < stringArray5.length) {
                    stringArray2[n2] = stringArray5[n2];
                    ++n2;
                }
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "NSN_SERVICE_OR_SID", "123");
            if (this.varList instanceof String[]) {
                stringArray5 = (String[])this.varList;
                n2 = 0;
                while (n2 < stringArray5.length) {
                    stringArray3[n2] = stringArray5[n2];
                    ++n2;
                }
            }
            this.varList = this.respFile.getValue("oracle.net.ca", "NSN_PROTOCOLS", "TCP;1521");
            if (this.varList instanceof String[]) {
                stringArray5 = (String[])this.varList;
                n2 = 0;
                while (n2 < stringArray5.length) {
                    stringArray4[n2] = stringArray5[n2];
                    ++n2;
                }
            }
            int n3 = 0;
            while (n3 < n) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray4[n3], ";");
                string = stringTokenizer.nextToken().toLowerCase();
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                configureServiceAlias.buildNSNDescription(stringArray2[n3], stringArray3[n3], string, string2, string3);
                this.netca.configureNetServiceName(stringArray[n3]);
                ++n3;
            }
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.netstr.getString("SOSilentReadFailed")) + this.respFile);
            return false;
        }
        return true;
    }
}

