/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common;

public class WindowsService {
    public static final int START_TYPE_AUTO = 0;
    public static final int START_TYPE_MANUAL = 1;
    public static final int START_TYPE_DISABLED = 2;
    public static final int NO_ERROR = 0;
    public static final int ERROR_GENERAL = 1;
    public static final int ERROR_ACCESS_DENIED = 2;
    public static final int ERROR_SERVICE_DOES_NOT_EXIST = 3;
    public static final int ERROR_SERVICE_MARKED_FOR_DELETE = 4;
    public static final int ERROR_DEPENDENT_SERVICES_RUNNING = 5;

    public static int setStartType(String string, int n) {
        if (System.getProperty("os.name", "DEFAULT").startsWith("Windows NT")) {
            return WindowsService.jniSetStartType(string, n);
        }
        return 0;
    }

    public static int stopService(String string) {
        if (System.getProperty("os.name", "DEFAULT").startsWith("Windows NT")) {
            return WindowsService.jniStopService(string);
        }
        return 0;
    }

    public static int deleteService(String string) {
        if (System.getProperty("os.name", "DEFAULT").startsWith("Windows NT")) {
            return WindowsService.jniDeleteService(string);
        }
        return 0;
    }

    private static native int jniSetStartType(String var0, int var1);

    private static native int jniStopService(String var0);

    private static native int jniDeleteService(String var0);

    static {
        block2: {
            if (!System.getProperty("os.name", "DEFAULT").startsWith("Windows NT")) break block2;
            try {
                System.loadLibrary("oranjni8");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.out.println("Error loading native jni library: oranjni8.dll.");
            }
        }
    }
}

