/*
 * Decompiled with CFR 0.152.
 */
package oracle.plsql.net;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class TCPConnection {
    private Socket m_s;
    private InputStream m_in;
    private OutputStream m_out;
    private static Vector s_conns;
    private static final int E_END_OF_INPUT = -20001;
    private static final int E_NETWORK_ERROR = -20002;
    private static String T_NOT_CONNECTED;
    private static String T_END_OF_INPUT;

    static {
        T_NOT_CONNECTED = "not connected";
        T_END_OF_INPUT = "end of input";
        s_conns = new Vector();
        s_conns.addElement(null);
    }

    public TCPConnection(String string, int n, String string2, int n2, int n3, int n4) throws IOException {
        this.m_s = string2 == null && n2 == -1 ? new Socket(string, n) : (string2 == null && n2 != -1 ? new Socket(string, n, InetAddress.getLocalHost(), n2) : new Socket(string, n, InetAddress.getByName(string2), n2));
        this.m_in = this.m_s.getInputStream();
        this.m_out = this.m_s.getOutputStream();
        if (n4 > 0) {
            this.m_out = new BufferedOutputStream(this.m_out, n4);
        }
    }

    public int available() throws IOException {
        return this.m_in.available();
    }

    public static int available(int n, int[] nArray, String[] stringArray) {
        try {
            TCPConnection tCPConnection = (TCPConnection)s_conns.elementAt(n);
            if (tCPConnection == null) {
                throw new IOException(T_NOT_CONNECTED);
            }
            return tCPConnection.available();
        }
        catch (IOException iOException) {
            nArray[0] = -20002;
            stringArray[0] = iOException.getMessage();
            return 0;
        }
    }

    public void close() throws IOException {
        this.m_in.close();
        this.m_out.close();
        this.m_s.close();
    }

    public static int connect(String string, int n, String[] stringArray, int[] nArray, int n2, int n3, int[] nArray2, String[] stringArray2) {
        int n4 = 1;
        int n5 = s_conns.size();
        while (n4 < n5) {
            if (s_conns.elementAt(n4) == null) break;
            ++n4;
        }
        try {
            TCPConnection tCPConnection = new TCPConnection(string, n, stringArray[0], nArray[0], n2, n3);
            stringArray[0] = tCPConnection.getLocalHost();
            nArray[0] = tCPConnection.getLocalPort();
            if (n4 == n5) {
                s_conns.addElement(tCPConnection);
            } else {
                s_conns.setElementAt(tCPConnection, n4);
            }
            return n4;
        }
        catch (IOException iOException) {
            nArray2[0] = -20002;
            stringArray2[0] = iOException.getMessage();
            return -1;
        }
    }

    public static void disconnect(int n, int[] nArray, String[] stringArray) {
        try {
            TCPConnection tCPConnection = (TCPConnection)s_conns.elementAt(n);
            if (tCPConnection == null) {
                throw new IOException(T_NOT_CONNECTED);
            }
            tCPConnection.close();
            s_conns.setElementAt(null, n);
        }
        catch (IOException iOException) {
            nArray[0] = -20002;
            stringArray[0] = iOException.getMessage();
        }
    }

    public static void disconnectAll() {
        int n = 1;
        while (n < s_conns.size()) {
            try {
                TCPConnection tCPConnection = (TCPConnection)s_conns.elementAt(n);
                if (tCPConnection != null) {
                    tCPConnection.close();
                    s_conns.setElementAt(null, n);
                }
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public void flush() throws IOException {
        this.m_out.flush();
    }

    public static void flush(int n, int[] nArray, String[] stringArray) {
        try {
            TCPConnection tCPConnection = (TCPConnection)s_conns.elementAt(n);
            if (tCPConnection == null) {
                throw new IOException(T_NOT_CONNECTED);
            }
            tCPConnection.flush();
        }
        catch (IOException iOException) {
            nArray[0] = -20002;
            stringArray[0] = iOException.getMessage();
        }
    }

    public String getLocalHost() throws IOException {
        return this.m_s.getLocalAddress().getHostName();
    }

    public int getLocalPort() throws IOException {
        return this.m_s.getLocalPort();
    }

    public byte[] read(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (n == 0) {
            return byArray;
        }
        int n2 = this.m_in.read(byArray);
        if (n2 == -1) {
            throw new EOFException(T_END_OF_INPUT);
        }
        if (byArray.length > n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public static int read(int n, byte[][] byArray, int n2, int[] nArray, String[] stringArray) {
        try {
            TCPConnection tCPConnection = (TCPConnection)s_conns.elementAt(n);
            if (tCPConnection == null) {
                throw new IOException(T_NOT_CONNECTED);
            }
            byArray[0] = tCPConnection.read(n2);
            return byArray[0].length;
        }
        catch (EOFException eOFException) {
            nArray[0] = -20001;
            stringArray[0] = eOFException.getMessage();
        }
        catch (IOException iOException) {
            nArray[0] = -20002;
            stringArray[0] = iOException.getMessage();
        }
        return 0;
    }

    public static int write(int n, byte[] byArray, int n2, int[] nArray, String[] stringArray) {
        try {
            TCPConnection tCPConnection = (TCPConnection)s_conns.elementAt(n);
            if (tCPConnection == null) {
                throw new IOException(T_NOT_CONNECTED);
            }
            tCPConnection.write(byArray, n2);
            return n2;
        }
        catch (IOException iOException) {
            nArray[0] = -20002;
            stringArray[0] = iOException.getMessage();
            return 0;
        }
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.m_out.write(byArray, 0, n);
    }
}

