/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.client;

import java.io.IOException;
import java.util.Stack;
import oracle.repapi.client.ClientConsts;
import oracle.repapi.client.FDSAccess;
import oracle.repapi.client.FDSObject;
import oracle.repapi.client.LOBTracker;
import oracle.repapi.client.PKException;
import oracle.repapi.client.RSTracker;
import oracle.repapi.client.RefGrp;
import oracle.repapi.client.RepAPI;
import oracle.repapi.client.RepAPITest;
import oracle.repapi.client.SnapAccess;
import oracle.repapi.client.TableMetadata;
import oracle.repapi.clientstub._RCImplBase;
import oracle.repapi.joint.ColumnDelineator;
import oracle.repapi.joint.ErrorResult;
import oracle.repapi.joint.GroupResultSet;
import oracle.repapi.joint.RefreshGroup;
import oracle.repapi.joint.RepAPIConditionals;
import oracle.repapi.joint.RepAPIException;
import oracle.repapi.joint.ResultSet;
import oracle.repapi.joint.ResultSetFactory;
import oracle.repapi.serverstub.RS;
import org.omg.CORBA.ShortHolder;

public class AllA
extends _RCImplBase
implements ClientConsts,
RepAPIConditionals {
    LobInfo m_Local_lob_info;
    LocalA m_local;
    RS m_remote;
    volatile RepAPI m_repapi;
    volatile RefGrp m_refgrp;
    volatile boolean m_refgrp_inserted = false;
    volatile String m_refgrp_name = null;
    volatile boolean m_push_only = false;
    volatile boolean m_ack_received = false;
    volatile boolean m_ack_sent = false;
    volatile boolean m_abort_received = false;
    volatile boolean m_abort_processed = false;
    volatile boolean m_fatal_error_received = false;
    volatile boolean m_fatal_error_processed = false;
    volatile ErrorResult m_errres = null;
    Stack m_saccess = new Stack();
    Stack m_errt = new Stack();
    volatile int m_notpushed;
    volatile int m_last_transaction;
    volatile SnapAccess m_last_saccess;
    volatile int m_sentRequestNumber = -1;
    volatile int m_receivedRequestNumber = -1;

    public AllA() {
    }

    public AllA(FDSAccess fdsa) {
        this.m_local = new LocalA(fdsa);
    }

    public void ack(int tranid, int suc_ind) {
        try {
            if (this.m_repapi.m_debug_switch) {
                System.out.println("ack entered with tranid " + tranid + " " + (suc_ind > 0 ? "and failure" : "and success"));
            }
            if (suc_ind != 0) {
                ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(318, null, new String[]{String.valueOf(suc_ind)})}, this.m_refgrp.m_rgid, 0, 0, (short)this.m_refgrp.getRSN(), 8);
                if (this.m_remote != null) {
                    this.m_remote.error(err);
                }
                this.notifyAndClear(err);
                return;
            }
            short[] pos2 = new short[]{1};
            RSTracker rst = new RSTracker();
            ResultSet RepRS = null;
            try {
                RepRS = ResultSetFactory.createSingleRow(pos2, new Object[]{this.m_repapi.m_master_name}, this.m_repapi.m_diffchset);
                ResultSet allRS = this.m_local.m_repapi_tab.fetch(new short[]{1, 2, 3, 4}, RepRS, null, rst);
                ResultSetFactory.setIntegerColumn(allRS.buf, allRS.buf.length - 4, this.m_last_transaction);
                new RepAPITest(this.m_repapi).executeEvent(1);
                if (this.m_abort_received) {
                    this.notifyAndClear(null);
                    return;
                }
                int num = this.m_local.m_repapi_tab.update(allRS);
                this.m_local.m_lob_tab.purgeUptoXaction(this.m_last_transaction);
            }
            catch (Throwable ioe) {
                if (this.m_repapi.m_debug_switch) {
                    ioe.printStackTrace();
                }
                ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(316, null, new String[]{ioe.getMessage()})}, this.m_refgrp.m_rgid, 0, 0, (short)this.m_refgrp.getRSN(), 8);
                if (this.m_remote != null) {
                    this.m_remote.error(err);
                }
                this.notifyAndClear(err);
                return;
            }
            if (!this.m_push_only) {
                pos2 = new short[]{1, 1, 3, 4};
                int[] nArray = new int[3];
                nArray[1] = this.m_last_transaction;
                int[] intarray = nArray;
                FDSObject snap = null;
                SnapAccess snapa = null;
                try {
                    ResultSet RepQRS = ResultSetFactory.createSingleRow(pos2, new Object[]{intarray, new byte[]{73}}, this.m_repapi.m_diffchset, RepRS, RepRS.cold);
                    int i = 0;
                    while (i < this.m_refgrp.getSnaplistSize()) {
                        snapa = this.m_refgrp.getSnaplistElementAt(i);
                        snap = snapa.m_table;
                        ResultSetFactory.setIntegerColumn(RepQRS.buf, 8, snapa.m_snap_id);
                        rst = new RSTracker();
                        ResultSet snapdRS = this.m_local.m_repQ_tab.fetch(ClientConsts.SPK, RepQRS, null, rst);
                        if (snapdRS != null) {
                            new RepAPITest(this.m_repapi).executeEvent(2);
                            if (this.m_abort_received) {
                                this.notifyAndClear(null);
                                return;
                            }
                            short[] tmppos = new short[snapdRS.cold.pos.length / snapdRS.numrows];
                            int j = 0;
                            while (j < tmppos.length) {
                                tmppos[j] = snapdRS.cold.pos[j];
                                ++j;
                            }
                            snapdRS.cold.pos = tmppos;
                            snap.delete(snapdRS);
                            while (rst.m_RSmore) {
                                snapdRS = this.m_local.m_repQ_tab.fetch(ClientConsts.SPK, RepQRS, null, rst);
                                new RepAPITest(this.m_repapi).executeEvent(3);
                                if (this.m_abort_received) {
                                    this.notifyAndClear(null);
                                    return;
                                }
                                tmppos = new short[snapdRS.cold.pos.length / snapdRS.numrows];
                                int j2 = 0;
                                while (j2 < tmppos.length) {
                                    tmppos[j2] = snapdRS.cold.pos[j2];
                                    ++j2;
                                }
                                snapdRS.cold.pos = tmppos;
                                snap.delete(snapdRS);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable ioe) {
                    if (this.m_repapi.m_debug_switch) {
                        ioe.printStackTrace();
                    }
                    ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(320, null, new String[]{ioe.getMessage()})}, this.m_refgrp.m_rgid, 0, 0, (short)this.m_refgrp.getRSN(), 8);
                    if (this.m_remote != null) {
                        this.m_remote.error(err);
                    }
                    this.notifyAndClear(err);
                    return;
                }
            }
            this.m_ack_received = true;
            this.wakeAll();
        }
        catch (Throwable ioe) {
            if (this.m_repapi.m_debug_switch) {
                ioe.printStackTrace();
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(316, null, new String[]{ioe.getMessage()})}, this.m_refgrp.m_rgid, 0, 0, (short)this.m_refgrp.getRSN(), 8);
            if (this.m_remote != null) {
                this.m_remote.error(err);
            }
            this.notifyAndClear(err);
            return;
        }
    }

    protected void clearAccessMembers() {
        this.m_refgrp_inserted = false;
        this.m_refgrp_name = null;
        this.m_push_only = false;
        this.m_saccess = new Stack();
        this.m_notpushed = 0;
        this.m_last_transaction = 0;
        this.m_last_saccess = null;
    }

    protected void clearCompletionStatus() {
        this.m_ack_received = false;
        this.m_ack_sent = false;
        this.m_abort_received = false;
        this.m_abort_processed = false;
        this.m_fatal_error_received = false;
        this.m_fatal_error_processed = false;
        this.m_errt = new Stack();
        this.m_errres = null;
        if (this.m_repapi != null) {
            int ts = this.m_repapi.m_FDSi.size();
            int i = 0;
            while (i < ts) {
                if (this == (AllA)this.m_repapi.m_FDSi.elementAt(i)) {
                    this.m_repapi.m_FDSi.removeElementAt(i);
                    break;
                }
                ++i;
            }
        }
    }

    public int datasize() {
        return 1;
    }

    public void datasize(int datasize) {
    }

    public void error(ErrorResult errdata) {
        try {
            if (this.m_repapi.m_debug_switch) {
                System.out.println("error");
                if (this.m_remote != null) {
                    System.out.println("ErrorResult - " + errdata.toString());
                }
            }
            if (errdata.stk[0].equals("E")) {
                Integer tmpint = this.m_errt.push(new Integer(errdata.trid));
                this.wakeAll();
                return;
            }
            if (errdata.stk[0].equals("F") || errdata.stk[0].equals("N")) {
                this.notifyAndClear(errdata);
            }
            return;
        }
        catch (Throwable throwable) {
            this.notifyAndClear(errdata);
            return;
        }
    }

    private void insertLob(short pos, byte[] buf, LOBTracker lt) {
        try {
            new RepAPITest(this.m_repapi).executeEvent(4);
            this.m_Local_lob_info.m_table.insertLobChunk(pos, buf, lt);
        }
        catch (Throwable ioe) {
            if (this.m_repapi.m_debug_switch) {
                ioe.printStackTrace();
            }
            SnapAccess tmps = this.m_refgrp.getSnaplistElement(this.m_Local_lob_info.m_table.m_name);
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(305, null, new String[]{ioe.getMessage()})}, this.m_refgrp.m_rgid, tmps == null ? 0 : tmps.m_snap_id, 0, (short)this.m_refgrp.getRSN(), 4);
            if (this.m_remote != null) {
                this.m_remote.error(err);
            }
            this.recordErrorAndClear(err);
            return;
        }
    }

    private void insertNullEmptyLob() {
        try {
            while (this.m_Local_lob_info.m_current_lob_number < this.m_Local_lob_info.m_nlob_columns && this.m_Local_lob_info.m_length[this.m_Local_lob_info.m_current_lob_number] == 0L) {
                short pos = this.m_Local_lob_info.m_column_nums[this.m_Local_lob_info.m_current_lob_number];
                this.m_Local_lob_info.m_current_LOBTracker.m_LOB_current_offset = 0L;
                this.m_Local_lob_info.m_current_LOBTracker.m_LOB_beginning_offset = this.m_Local_lob_info.m_lob_offset[this.m_Local_lob_info.m_current_lob_number];
                this.m_Local_lob_info.m_current_LOBTracker.m_LOBchunksize = 0;
                this.m_Local_lob_info.m_current_LOBTracker.m_LOBsize = 0L;
                new RepAPITest(this.m_repapi).executeEvent(5);
                if (this.m_abort_received) {
                    return;
                }
                if ((this.m_Local_lob_info.m_lob_flags[this.m_Local_lob_info.m_current_lob_number] & 2) > 0) {
                    this.m_Local_lob_info.m_table.insertLobChunk(pos, null, this.m_Local_lob_info.m_current_LOBTracker);
                } else {
                    byte[] buf = new byte[]{};
                    this.m_Local_lob_info.m_table.insertLobChunk(pos, buf, this.m_Local_lob_info.m_current_LOBTracker);
                }
                this.m_Local_lob_info.m_current_lob_number = (short)(this.m_Local_lob_info.m_current_lob_number + 1);
            }
        }
        catch (Throwable ioe) {
            if (this.m_repapi.m_debug_switch) {
                ioe.printStackTrace();
            }
            SnapAccess tmps = this.m_refgrp.getSnaplistElement(this.m_Local_lob_info.m_table.m_name);
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(305, null, new String[]{ioe.getMessage()})}, this.m_refgrp.m_rgid, tmps == null ? 0 : tmps.m_snap_id, 0, (short)this.m_refgrp.getRSN(), 4);
            if (this.m_remote != null) {
                this.m_remote.error(err);
            }
            this.recordErrorAndClear(err);
            return;
        }
    }

    public int instantiate(RefreshGroup grp_metadata) {
        return 1;
    }

    public void instantiate_req(RefreshGroup grp_metadata, int requestNumber) {
        block45: {
            try {
                if (this.m_repapi.m_debug_switch) {
                    System.out.println("instantiate_req");
                    if (this.m_remote != null) {
                        System.out.println("refresh group - " + grp_metadata.toString());
                    }
                    System.out.println("request number - " + requestNumber);
                }
                int i = 0;
                new RepAPITest(this.m_repapi).executeEvent(6);
                if (this.m_abort_received) {
                    if ((grp_metadata.flg & 1) > 0) {
                        this.processAbort();
                    }
                    return;
                }
                if (this.m_fatal_error_received) {
                    if ((grp_metadata.flg & 1) > 0) {
                        this.processError(null);
                    }
                    return;
                }
                int[][] intarray = new int[2][];
                ResultSet RefRS = new ResultSet();
                RefRS.cold = new ColumnDelineator();
                if (!this.m_refgrp_inserted) {
                    try {
                        this.m_refgrp_name = grp_metadata.grpname;
                        intarray[0] = new int[]{grp_metadata.grpid};
                        intarray[1] = new int[2];
                        RefRS = ResultSetFactory.createSingleRow(ClientConsts.ALLC, new Object[]{intarray[0], grp_metadata.grpname, this.m_repapi.m_master_name, intarray[1]}, this.m_repapi.m_diffchset, RefRS, RefRS.cold);
                        new RepAPITest(this.m_repapi).executeEvent(7);
                        if (this.m_abort_received) {
                            if ((grp_metadata.flg & 1) > 0) {
                                this.processAbort();
                            }
                            return;
                        }
                        this.m_local.m_refgrp_tab.insert(RefRS);
                    }
                    catch (Throwable ioe) {
                        if (this.m_repapi.m_debug_switch) {
                            System.out.println("CREATE_REFGRP_TAB");
                            ioe.printStackTrace();
                        }
                        ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(202, null, new String[]{ioe.getMessage()})}, grp_metadata.grpid, grp_metadata.snaps[i].snapid, 0, 0, 1);
                        if (this.m_remote != null) {
                            this.m_remote.error(err);
                        }
                        if ((grp_metadata.flg & 1) > 0) {
                            this.processError(err);
                        } else {
                            this.recordErrorAndClear(err);
                        }
                        return;
                    }
                    this.m_refgrp_inserted = true;
                }
                try {
                    intarray[0] = new int[1];
                    intarray[1] = new int[]{grp_metadata.grpid};
                    i = 0;
                    while (i < grp_metadata.numsnaps) {
                        FDSObject tmp_table;
                        intarray[0][0] = grp_metadata.snaps[i].snapid;
                        ResultSet SnapRS = ResultSetFactory.createSingleRow(ClientConsts.SALLC, new Object[]{intarray[0], grp_metadata.snaps[i].snapname, grp_metadata.snaps[i].schemaname, new short[]{grp_metadata.snaps[i].flag}, intarray[1], this.m_repapi.m_master_name}, this.m_repapi.m_diffchset, RefRS, RefRS.cold);
                        new RepAPITest(this.m_repapi).executeEvent(8);
                        if (this.m_abort_received) {
                            if ((grp_metadata.flg & 1) > 0) {
                                this.processAbort();
                            }
                            return;
                        }
                        this.m_local.m_snap_tab.insert(SnapRS);
                        String tmpname = "";
                        String tmpschema = "";
                        tmpname = grp_metadata.snaps[i].snapname;
                        tmpschema = grp_metadata.snaps[i].schemaname;
                        boolean found_table = true;
                        try {
                            tmp_table = this.m_local.m_fdsa.locate(tmpname, tmpschema, null);
                        }
                        catch (IOException iOException) {
                            found_table = false;
                        }
                        if (found_table) {
                            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(203, new String[]{String.valueOf(tmpschema.equals("") ? "" : String.valueOf(tmpschema) + ".") + tmpname}, null)}, grp_metadata.grpid, grp_metadata.snaps[i].snapid, 0, 0, 1);
                            if (this.m_remote != null) {
                                if ((grp_metadata.flg & 1) > 0) {
                                    this.m_remote.ack((short)0, err);
                                } else {
                                    this.m_remote.error(err);
                                }
                            }
                            if ((grp_metadata.flg & 1) > 0) {
                                this.processError(err);
                            } else {
                                this.recordErrorAndClear(err);
                            }
                            return;
                        }
                        tmp_table = this.m_local.m_fdsa.locate(tmpname, tmpschema, new TableMetadata(tmpname, tmpschema, grp_metadata.snaps[i].numcols, grp_metadata.snaps[i].snapcols, grp_metadata.snaps[i].numidx, grp_metadata.snaps[i].hididx, grp_metadata.snaps[i].flag, (short)grp_metadata.snaps[i].snapid, grp_metadata.snaps[i].numcgrp, grp_metadata.snaps[i].snapcgrp, grp_metadata.snaps[i].pkcols));
                        tmp_table.lock();
                        SnapAccess tmp = this.m_saccess.push(new SnapAccess(grp_metadata.grpid, grp_metadata.snaps[i].snapid, tmpname, tmpschema, grp_metadata.snaps[i].flag, tmp_table));
                        ++i;
                    }
                }
                catch (Throwable ioe) {
                    if (this.m_repapi.m_debug_switch) {
                        System.out.println("CREATE_REFGRP_SNAP");
                        ioe.printStackTrace();
                    }
                    ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(204, null, new String[]{ioe.getMessage()})}, grp_metadata.grpid, grp_metadata.snaps[i].snapid, 0, 0, 1);
                    if (this.m_remote != null) {
                        if ((grp_metadata.flg & 1) > 0) {
                            this.m_remote.ack((short)0, err);
                        } else {
                            this.m_remote.error(err);
                        }
                    }
                    if ((grp_metadata.flg & 1) > 0) {
                        this.processError(err);
                    } else {
                        this.recordErrorAndClear(err);
                    }
                    return;
                }
                if ((grp_metadata.flg & 1) <= 0) break block45;
                this.m_refgrp_inserted = false;
                int tsiz = this.m_saccess.size();
                SnapAccess[] tmpsnp = new SnapAccess[tsiz];
                try {
                    new RepAPITest(this.m_repapi).executeEvent(9);
                    this.m_local.m_fdsa.commit();
                }
                catch (Throwable ioe) {
                    if (this.m_repapi.m_debug_switch) {
                        System.out.println("INSTANTIATE_COMMIT");
                        ioe.printStackTrace();
                    }
                    ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(301, null, new String[]{ioe.getMessage()})}, grp_metadata.grpid, grp_metadata.snaps[i].snapid, 0, 0, 1);
                    if (this.m_remote != null) {
                        this.m_remote.ack((short)0, err);
                    }
                    this.notifyAndClear(err);
                    return;
                }
                i = 0;
                while (i < tsiz) {
                    tmpsnp[i] = (SnapAccess)this.m_saccess.elementAt(i);
                    tmpsnp[i].m_table.lock();
                    ++i;
                }
                this.m_saccess = new Stack();
                this.m_refgrp = new RefGrp(this.m_repapi, grp_metadata.grpname, grp_metadata.grpid, tmpsnp);
                this.m_refgrp_name = null;
                this.m_refgrp.setRSN(0);
                new RepAPITest(this.m_repapi).executeEvent(10);
                if (this.m_abort_received) {
                    this.processAbort();
                    return;
                }
                if (this.m_remote != null) {
                    this.m_remote.ack((short)0, ClientConsts.NULERRES);
                }
            }
            catch (Throwable ioe) {
                if (this.m_repapi.m_debug_switch) {
                    System.out.println("CREATE_REFGRP");
                    ioe.printStackTrace();
                }
                ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(208, null, new String[]{ioe.getMessage()})}, grp_metadata.grpid, 0, 0, 0, 1);
                if (this.m_remote != null) {
                    this.m_remote.error(err);
                }
                this.notifyAndClear(err);
                return;
            }
        }
    }

    protected synchronized void notifyAndClear(ErrorResult err) {
        if (err != null) {
            this.m_fatal_error_received = true;
            this.m_fatal_error_processed = true;
            this.m_errres = err;
        }
        this.clearAccessMembers();
        this.notifyAll();
    }

    protected synchronized void processAbort() {
        this.m_abort_processed = true;
        this.notifyAndClear(null);
    }

    protected synchronized void processError(ErrorResult err) {
        this.m_fatal_error_received = true;
        this.m_fatal_error_processed = true;
        if (err != null) {
            this.m_errres = err;
        }
        this.notifyAll();
    }

    void reInit() {
        this.m_sentRequestNumber = -1;
        this.m_receivedRequestNumber = -1;
    }

    protected synchronized void recordErrorAndClear(ErrorResult err) {
        this.m_fatal_error_received = true;
        this.m_errres = err;
        this.clearAccessMembers();
    }

    public int refresh(boolean ref_data, GroupResultSet rowdata, ShortHolder rseqno) {
        return 1;
    }

    public void refresh_req(GroupResultSet rowdata, int requestNumber) {
        block64: {
            try {
                if (this.m_repapi.m_debug_switch) {
                    System.out.println("refresh_req");
                    if (this.m_remote != null) {
                        System.out.println("group result set - " + rowdata.toString());
                    }
                    System.out.println("request number - " + requestNumber);
                }
                new RepAPITest(this.m_repapi).executeEvent(11);
                if (this.m_abort_received) {
                    if ((rowdata.flg & 1) > 0) {
                        this.processAbort();
                    }
                    return;
                }
                if (this.m_fatal_error_received) {
                    if ((rowdata.flg & 1) > 0) {
                        this.processError(null);
                    }
                    return;
                }
                boolean j = false;
                int i = 0;
                FDSObject snap = null;
                try {
                    i = 0;
                    while (i < rowdata.numrslts) {
                        if (this.m_last_saccess == null || this.m_last_saccess.m_snap_id != rowdata.rsltsets[i].snapid) {
                            this.m_last_saccess = this.m_refgrp.getSnaplistElement(rowdata.rsltsets[i].snapid);
                            snap = this.m_last_saccess.m_table;
                            if ((rowdata.rsltsets[i].flags & 0x200) > 0) {
                                new RepAPITest(this.m_repapi).executeEvent(12);
                                if (this.m_abort_received) {
                                    if ((rowdata.flg & 1) > 0) {
                                        this.processAbort();
                                    }
                                    return;
                                }
                                snap.purge();
                            }
                        } else {
                            snap = this.m_last_saccess.m_table;
                        }
                        ResultSet rs = rowdata.rsltsets[i];
                        new RepAPITest(this.m_repapi).executeEvent(13);
                        if (this.m_abort_received) {
                            if ((rowdata.flg & 1) > 0) {
                                this.processAbort();
                            }
                            return;
                        }
                        if ((rs.flags & 2) > 0) {
                            snap.delete(rs);
                        } else if ((rs.flags & 4) > 0) {
                            if ((rs.flags & 0x40) == 0) {
                                snap.insert(rs);
                            } else {
                                try {
                                    snap.insert(rs);
                                }
                                catch (PKException pKException) {}
                            }
                        } else if ((rs.flags & 8) > 0) {
                            snap.upsert(rs);
                        }
                        if ((rs.flags & 1) > 0) {
                            int nlob_columns = 0;
                            long[] length = new long[snap.m_tmd.numcols];
                            short[] column_nums = new short[snap.m_tmd.numcols];
                            short ncols = snap.m_tmd.numcols;
                            int[] positions = ResultSetFactory.decodeLengths(rs, ncols);
                            short n = 1;
                            while (n <= ncols) {
                                if (snap.m_tmd.cols[n - 1].dty == 113 || snap.m_tmd.cols[n - 1].dty == 112) {
                                    short c = 0;
                                    while (c < ncols) {
                                        if (rs.cold.pos[c] == n) {
                                            length[nlob_columns] = positions[c];
                                            column_nums[nlob_columns] = n;
                                            ++nlob_columns;
                                            break;
                                        }
                                        c = (short)(c + 1);
                                    }
                                }
                                n = (short)(n + 1);
                            }
                            this.m_Local_lob_info = new LobInfo(snap, nlob_columns, rs.cold.lobflg, rs.cold.pos, column_nums, rs.cold.lob_offset, length, (rs.flags & 0x2000) != 0);
                        }
                        ++i;
                    }
                }
                catch (Throwable ioe) {
                    if (this.m_repapi.m_debug_switch) {
                        System.out.println("REFRESH");
                        ioe.printStackTrace();
                    }
                    ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(315, null, new String[]{ioe.getMessage()})}, rowdata.groupid, rowdata.rsltsets[i].snapid, 0, (short)this.m_refgrp.getRSN(), 4);
                    if (this.m_remote != null) {
                        if ((rowdata.flg & 1) > 0) {
                            this.m_remote.ack((short)this.m_refgrp.getRSN(), err);
                        } else {
                            this.m_remote.error(err);
                        }
                    }
                    if ((rowdata.flg & 1) > 0) {
                        this.processError(err);
                    } else {
                        this.recordErrorAndClear(err);
                    }
                    return;
                }
                if ((rowdata.flg & 1) <= 0) break block64;
                i = 0;
                try {
                    if (rowdata.seqno != 0) {
                        this.m_refgrp.setRSN(rowdata.seqno);
                    } else {
                        this.m_refgrp.setRSN(this.m_refgrp.getRSN() + 1);
                    }
                    int[] intarray = new int[]{this.m_refgrp.m_rgid};
                    short[] pos1 = new short[]{1};
                    ResultSet RefRS = ResultSetFactory.createSingleRow(pos1, new Object[]{intarray});
                    RSTracker rst = new RSTracker();
                    ResultSet refRS = this.m_local.m_refgrp_tab.fetch(new short[]{1, 2, 3, 4, 5}, RefRS, null, rst);
                    ResultSetFactory.setIntegerColumn(refRS.buf, refRS.buf.length - 8, this.m_last_transaction);
                    int tmprsn = this.m_refgrp.getRSN();
                    ResultSetFactory.setIntegerColumn(refRS.buf, refRS.buf.length - 4, tmprsn);
                    new RepAPITest(this.m_repapi).executeEvent(14);
                    if (this.m_abort_received) {
                        if ((rowdata.flg & 1) > 0) {
                            this.processAbort();
                        }
                        return;
                    }
                    this.m_local.m_refgrp_tab.update(refRS);
                    pos1 = new short[]{1, 1, 3};
                    int[] nArray = new int[3];
                    nArray[1] = this.m_last_transaction;
                    intarray = nArray;
                    ResultSet RepQRS = ResultSetFactory.createSingleRow(pos1, new Object[]{intarray}, this.m_repapi.m_diffchset, RefRS, RefRS.cold);
                    snap = null;
                    i = 0;
                    while (i < this.m_refgrp.getSnaplistSize()) {
                        SnapAccess snapa = this.m_refgrp.getSnaplistElementAt(i);
                        ResultSetFactory.setIntegerColumn(RepQRS.buf, 8, snapa.m_snap_id);
                        rst = new RSTracker();
                        ResultSet RepQdRS = this.m_local.m_repQ_tab.fetch(ClientConsts.RQPK, RepQRS, null, rst);
                        if (RepQdRS != null) {
                            new RepAPITest(this.m_repapi).executeEvent(15);
                            if (this.m_abort_received) {
                                if ((rowdata.flg & 1) > 0) {
                                    this.processAbort();
                                }
                                return;
                            }
                            RepQdRS.cold.pos = ClientConsts.RQPK;
                            this.m_local.m_repQ_tab.delete(RepQdRS);
                            while (rst.m_RSmore) {
                                RepQdRS = this.m_local.m_repQ_tab.fetch(ClientConsts.RQPK, RepQRS, null, rst);
                                new RepAPITest(this.m_repapi).executeEvent(16);
                                if (this.m_abort_received) {
                                    if ((rowdata.flg & 1) > 0) {
                                        this.processAbort();
                                    }
                                    return;
                                }
                                RepQdRS.cold.pos = ClientConsts.RQPK;
                                this.m_local.m_repQ_tab.delete(RepQdRS);
                            }
                        }
                        ++i;
                    }
                    new RepAPITest(this.m_repapi).executeEvent(17);
                    if (this.m_abort_received) {
                        if ((rowdata.flg & 1) > 0) {
                            this.processAbort();
                        }
                        return;
                    }
                    this.m_local.m_fdsa.commit();
                }
                catch (Throwable ioe2) {
                    if (this.m_repapi.m_debug_switch) {
                        System.out.println("REFRESH_COMMIT");
                        ioe2.printStackTrace();
                    }
                    ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(301, null, new String[]{ioe2.getMessage()})}, rowdata.groupid, rowdata.rsltsets[i].snapid, 0, (short)this.m_refgrp.getRSN(), 4);
                    if (this.m_remote != null) {
                        if ((rowdata.flg & 1) > 0) {
                            this.m_remote.ack((short)this.m_refgrp.getRSN(), err);
                        } else {
                            this.m_remote.error(err);
                        }
                    }
                    if ((rowdata.flg & 1) > 0) {
                        this.processError(err);
                    } else {
                        this.recordErrorAndClear(err);
                    }
                    return;
                }
                if (this.m_remote != null) {
                    this.m_remote.ack((short)this.m_refgrp.getRSN(), ClientConsts.NULERRES);
                }
                this.m_ack_sent = true;
                this.wakeAll();
            }
            catch (Throwable ioe) {
                if (this.m_repapi.m_debug_switch) {
                    System.out.println("REFRESH");
                    ioe.printStackTrace();
                }
                ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(315, null, new String[]{ioe.getMessage()})}, rowdata.groupid, 0, 0, (short)this.m_refgrp.getRSN(), 4);
                if (this.m_remote != null) {
                    this.m_remote.error(err);
                }
                if ((rowdata.flg & 1) > 0) {
                    this.processError(err);
                } else {
                    this.recordErrorAndClear(err);
                }
                return;
            }
        }
    }

    public byte refresh_req_result(ResultSet rowdata) {
        FDSObject snap = null;
        boolean j = false;
        if (this.m_repapi.m_debug_switch) {
            System.out.println("refresh_req_result");
            if (this.m_remote != null) {
                System.out.println("result set - " + rowdata.toString());
            }
        }
        try {
            if (this.m_last_saccess.m_snap_id != rowdata.snapid) {
                this.m_last_saccess = this.m_refgrp.getSnaplistElement(rowdata.snapid);
            }
            snap = this.m_last_saccess.m_table;
            this.m_Local_lob_info = new LobInfo(snap, (rowdata.flags & 0x2000) != 0);
            new RepAPITest(this.m_repapi).executeEvent(18);
            if (this.m_abort_received) {
                this.processAbort();
                return 69;
            }
            if (this.m_fatal_error_received) {
                this.processError(null);
                return 69;
            }
            if ((rowdata.flags & 0x40) == 0) {
                snap.update(rowdata);
            } else {
                snap.insert(rowdata);
            }
        }
        catch (Throwable ioe) {
            if (ioe instanceof PKException) {
                if ((rowdata.flags & 0x40) == 0) {
                    try {
                        new RepAPITest(this.m_repapi).executeEvent(19);
                        if (this.m_abort_received) {
                            this.processAbort();
                            return 69;
                        }
                        snap.insert(rowdata);
                    }
                    catch (IOException ioe2) {
                        if (this.m_repapi.m_debug_switch) {
                            ioe2.printStackTrace();
                        }
                        ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(303, new String[]{String.valueOf(snap.m_schema.equals("") ? "" : String.valueOf(snap.m_schema) + ".") + snap.m_name}, new String[]{ioe2.getMessage()})}, this.m_refgrp.m_rgid, rowdata.snapid, 0, (short)this.m_refgrp.getRSN(), 4);
                        if (this.m_remote != null) {
                            this.m_remote.error(err);
                        }
                        this.processError(err);
                        return 69;
                    }
                    return 73;
                }
                return 78;
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg((rowdata.flags & 0x40) == 0 ? 302 : 303, new String[]{String.valueOf(snap.m_schema.equals("") ? "" : String.valueOf(snap.m_schema) + ".") + snap.m_name}, new String[]{ioe.getMessage()})}, this.m_refgrp.m_rgid, rowdata.snapid, 0, (short)this.m_refgrp.getRSN(), 4);
            if (this.m_remote != null) {
                this.m_remote.error(err);
            }
            this.processError(err);
            return 69;
        }
        if ((rowdata.flags & 0x40) == 0) {
            return 85;
        }
        return 73;
    }

    void rollback() throws RepAPIException {
        this.clearAccessMembers();
        this.clearCompletionStatus();
        try {
            new RepAPITest(this.m_repapi).executeEvent(20);
            this.m_local.m_fdsa.rollback();
        }
        catch (Throwable ioe) {
            if (this.m_repapi.m_debug_switch) {
                ioe.printStackTrace();
            }
            this.m_repapi.m_FDSs.push(this);
            this.m_repapi = null;
            throw new RepAPIException(608, null, new String[]{ioe.getMessage()});
        }
        this.m_repapi.m_FDSs.push(this);
        this.m_repapi = null;
    }

    public void send_lob_req(byte[] big_buf, int requestNumber) {
        try {
            if (this.m_repapi.m_debug_switch) {
                System.out.println("send_lob_req");
                System.out.println("big buf - " + big_buf);
                System.out.println("request number - " + requestNumber);
            }
            new RepAPITest(this.m_repapi).executeEvent(21);
            if (this.m_abort_received || this.m_fatal_error_received) {
                return;
            }
            if (this.m_Local_lob_info.m_current_LOBTracker == null) {
                this.m_Local_lob_info.m_current_LOBTracker = new LOBTracker();
                this.m_Local_lob_info.m_current_LOBTracker.m_LOB_current_offset = 0L;
                this.m_Local_lob_info.m_current_LOBTracker.m_LOB_beginning_offset = this.m_Local_lob_info.m_lob_offset[this.m_Local_lob_info.m_current_lob_number];
            }
            this.insertNullEmptyLob();
            if (this.m_Local_lob_info.m_current_lob_number < this.m_Local_lob_info.m_nlob_columns) {
                short pos = this.m_Local_lob_info.m_column_nums[this.m_Local_lob_info.m_current_lob_number];
                this.m_Local_lob_info.m_current_LOBTracker.m_LOBchunksize = big_buf.length;
                this.m_Local_lob_info.m_current_LOBTracker.m_LOBsize = this.m_Local_lob_info.m_length[this.m_Local_lob_info.m_current_lob_number];
                this.insertLob(pos, big_buf, this.m_Local_lob_info.m_current_LOBTracker);
                this.m_Local_lob_info.m_current_LOBTracker.m_LOB_current_offset += (long)this.m_Local_lob_info.m_current_LOBTracker.m_LOBchunksize;
                boolean bl = this.m_Local_lob_info.m_current_LOBTracker.m_end_of_LOB = this.m_Local_lob_info.m_current_LOBTracker.m_LOB_current_offset - this.m_Local_lob_info.m_current_LOBTracker.m_LOB_beginning_offset >= this.m_Local_lob_info.m_current_LOBTracker.m_LOBsize;
                if (this.m_Local_lob_info.m_current_LOBTracker.m_end_of_LOB) {
                    this.m_Local_lob_info.m_current_lob_number = (short)(this.m_Local_lob_info.m_current_lob_number + 1);
                    if (this.m_Local_lob_info.m_current_lob_number < this.m_Local_lob_info.m_nlob_columns) {
                        this.m_Local_lob_info.m_current_LOBTracker.m_LOB_current_offset = 0L;
                        this.m_Local_lob_info.m_current_LOBTracker.m_LOB_beginning_offset = this.m_Local_lob_info.m_lob_offset[this.m_Local_lob_info.m_current_lob_number];
                        this.insertNullEmptyLob();
                    } else {
                        this.m_Local_lob_info.m_current_LOBTracker = null;
                    }
                }
            }
        }
        catch (Throwable ioe) {
            if (this.m_repapi.m_debug_switch) {
                System.out.println("SEND_LOB");
                ioe.printStackTrace();
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(305, null, new String[]{ioe.getMessage()})}, 0, 0, 0, (short)this.m_refgrp.getRSN(), 4);
            if (this.m_remote != null) {
                this.m_remote.error(err);
            }
            this.recordErrorAndClear(err);
            return;
        }
    }

    public void send_lob_req_c(byte[] big_buf, ColumnDelineator cold, int requestNumber) {
        try {
            if (this.m_repapi.m_debug_switch) {
                System.out.println("send_lob_req_c");
                System.out.println("big buf - " + big_buf);
                System.out.println("Column Delineator - " + cold.toString());
                System.out.println("request number - " + requestNumber);
            }
            new RepAPITest(this.m_repapi).executeEvent(22);
            if (this.m_abort_received || this.m_fatal_error_received) {
                return;
            }
            if (cold != null) {
                int nlob_columns = cold.pos.length;
                long[] length = new long[nlob_columns];
                int[] positions = null;
                try {
                    new RepAPITest(this.m_repapi).executeEvent(23);
                    positions = ResultSetFactory.decodeLengths(nlob_columns, cold.len, this.m_Local_lob_info.m_normalized);
                }
                catch (Throwable ioe) {
                    if (this.m_repapi.m_debug_switch) {
                        System.out.println("send_lob_req_c");
                        ioe.printStackTrace();
                    }
                    ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(321, null, new String[]{ioe.getMessage()})}, 0, 0, 0, (short)this.m_refgrp.getRSN(), 4);
                    if (this.m_remote != null) {
                        this.m_remote.error(err);
                    }
                    this.recordErrorAndClear(err);
                    return;
                }
                int n = 0;
                while (n < nlob_columns) {
                    length[n] = positions[n];
                    n = (short)(n + 1);
                }
                this.m_Local_lob_info.setValues(nlob_columns, cold.lobflg, cold.pos, cold.pos, cold.lob_offset, length);
                this.m_Local_lob_info.m_current_LOBTracker = new LOBTracker();
                this.m_Local_lob_info.m_current_LOBTracker.m_LOB_current_offset = 0L;
                this.m_Local_lob_info.m_current_LOBTracker.m_LOB_beginning_offset = this.m_Local_lob_info.m_lob_offset[this.m_Local_lob_info.m_current_lob_number];
            }
            this.send_lob_req(big_buf, requestNumber);
        }
        catch (Throwable ioe) {
            if (this.m_repapi.m_debug_switch) {
                System.out.println("SEND_LOB");
                ioe.printStackTrace();
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(305, null, new String[]{ioe.getMessage()})}, 0, 0, 0, (short)this.m_refgrp.getRSN(), 4);
            if (this.m_remote != null) {
                this.m_remote.error(err);
            }
            this.recordErrorAndClear(err);
            return;
        }
    }

    protected synchronized void waitTilDone() {
        while (!(this.m_abort_processed || this.m_fatal_error_processed || this.m_ack_sent)) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void waitTilPushDone() throws RepAPIException {
        while (!(this.m_abort_received || this.m_fatal_error_received || this.m_ack_received)) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.m_errt.empty()) continue;
            this.m_repapi.errorTransaction(this);
        }
    }

    protected synchronized void wakeAll() {
        this.notifyAll();
    }

    public final class LocalA {
        FDSAccess m_fdsa;
        FDSObject m_repapi_tab;
        FDSObject m_refgrp_tab;
        FDSObject m_repQ_tab;
        FDSObject m_lob_tab;
        FDSObject m_snap_tab;

        public LocalA(FDSAccess fd) {
            this.m_fdsa = fd;
        }
    }

    public final class LobInfo {
        FDSObject m_table;
        int m_nlob_columns;
        short[] m_lob_flags;
        short[] m_pos;
        short[] m_column_nums;
        long[] m_lob_offset;
        long[] m_length;
        boolean m_normalized;
        long m_current_lob_offset = 0L;
        short m_current_lob_number = 0;
        LOBTracker m_current_LOBTracker = null;

        public LobInfo(FDSObject t, int nlob_columns, short[] lob_flags, short[] pos, short[] column_nums, long[] lob_offset, long[] length, boolean normalized) {
            this.m_table = t;
            this.m_nlob_columns = nlob_columns;
            this.m_lob_flags = lob_flags;
            this.m_pos = pos;
            this.m_column_nums = column_nums;
            this.m_lob_offset = lob_offset;
            this.m_length = length;
            this.m_normalized = normalized;
        }

        public LobInfo(FDSObject t, boolean normalized) {
            this.m_table = t;
            this.m_nlob_columns = 0;
            this.m_lob_flags = null;
            this.m_pos = null;
            this.m_column_nums = null;
            this.m_lob_offset = null;
            this.m_length = null;
            this.m_normalized = normalized;
        }

        public void setValues(int nlob_columns, short[] lob_flags, short[] pos, short[] column_nums, long[] lob_offset, long[] length) {
            this.m_nlob_columns = nlob_columns;
            this.m_lob_flags = lob_flags;
            this.m_pos = pos;
            this.m_column_nums = column_nums;
            this.m_lob_offset = lob_offset;
            this.m_length = length;
        }
    }
}

