/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspBeanDictionary;
import oracle.jsp.parse.JspBeanFieldInfo;
import oracle.jsp.parse.JspBeanMethodInfo;
import oracle.jsp.parse.JspBeanPropertyInfo;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;

public class JspBeanInfo
implements Serializable {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public static final int SCOPE_UNDEFINED = 0;
    public static final int SCOPE_PAGE = 1;
    public static final int SCOPE_REQUEST = 2;
    public static final int SCOPE_SESSION = 3;
    public static final int SCOPE_APPLICATION = 4;
    public static final int SCOPE_BLOCK = 10;
    public String name;
    public String className;
    public int scope;
    public Class bean;
    protected JspBeanInfo hides;
    private boolean isPrimitive;
    private Hashtable getMethods;
    private Hashtable setMethods;
    private BeanInfo beanInfo;
    private static final String[] primitives = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static final Class[] primitiveClass = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    static /* synthetic */ Class class$java$lang$String;

    public JspBeanInfo() {
        this.scope = 1;
    }

    public JspBeanInfo(String string, Class clazz) {
        this.scope = 1;
        this.name = string;
        this.className = clazz.getName();
        this.bean = clazz;
        this.isPrimitive = this.bean.isPrimitive();
    }

    public JspBeanInfo(String string, String string2) {
        this.scope = 1;
        this.name = string;
        this.className = string2;
        this.determinePrimitive();
    }

    public JspBeanInfo(String string, String string2, int n) {
        this.scope = n;
        this.name = string;
        this.className = string2;
        this.determinePrimitive();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.name);
        objectOutputStream.writeObject(this.className);
        objectOutputStream.writeInt(this.scope);
        objectOutputStream.writeBoolean(this.isPrimitive);
        objectOutputStream.writeObject(this.hides);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = (String)objectInputStream.readObject();
        this.className = (String)objectInputStream.readObject();
        this.scope = objectInputStream.readInt();
        this.isPrimitive = objectInputStream.readBoolean();
        this.hides = (JspBeanInfo)objectInputStream.readObject();
        this.getMethods = null;
        this.setMethods = null;
        this.beanInfo = null;
        this.bean = null;
        if (this.isPrimitive) {
            int n = 0;
            while (n < primitives.length) {
                if (this.className.equals(primitiveClass[n].getName())) {
                    this.bean = primitiveClass[n];
                    break;
                }
                ++n;
            }
        }
        if (!this.loadBean(null)) {
            throw new ClassNotFoundException(MessageFormat.format(msgs.getString("cannot_load_bean"), this.className));
        }
    }

    private void determinePrimitive() {
        this.isPrimitive = false;
        int n = 0;
        while (n < primitives.length) {
            if (this.className.equals(primitives[n])) {
                this.isPrimitive = true;
                this.bean = primitiveClass[n];
                this.className = this.bean.getName();
                return;
            }
            ++n;
        }
    }

    public boolean loadBean(JspParseState jspParseState) {
        if (this.bean == null) {
            this.bean = JspUtils.loadClass(this.className, jspParseState);
        }
        return this.bean != null;
    }

    private Method findSpecificMethod(String string, Class[] classArray) {
        Method method;
        if (this.isPrimitive) {
            return null;
        }
        try {
            method = this.bean.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        return method;
    }

    private Field findSpecificField(String string) {
        Field field;
        if (this.isPrimitive) {
            return null;
        }
        try {
            field = this.bean.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = null;
        }
        catch (SecurityException securityException) {
            field = null;
        }
        return field;
    }

    private JspBeanPropertyInfo findGetProperty(String string) {
        Class[] classArray;
        if (this.bean == null || this.isPrimitive) {
            return null;
        }
        String string2 = "get" + (string = string.length() > 1 ? String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1) : string.toUpperCase());
        Method method = this.findSpecificMethod(string2, classArray = new Class[]{Integer.TYPE});
        if (method != null && !method.getReturnType().equals(Void.TYPE)) {
            return new JspBeanMethodInfo(method);
        }
        classArray[0] = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JspBeanInfo.class$("java.lang.String"));
        method = this.findSpecificMethod(string2, classArray);
        if (method != null && !method.getReturnType().equals(Void.TYPE)) {
            return new JspBeanMethodInfo(method);
        }
        string2 = "get" + string;
        method = this.findSpecificMethod(string2, classArray = new Class[0]);
        if (method != null && !method.getReturnType().equals(Void.TYPE)) {
            return new JspBeanMethodInfo(method);
        }
        string2 = "is" + string;
        method = this.findSpecificMethod(string2, classArray);
        if (method != null && method.getReturnType().equals(Boolean.TYPE)) {
            return new JspBeanMethodInfo(method);
        }
        return null;
    }

    private Method findArraySetMethod(String string, Method[] methodArray) {
        int n = 0;
        while (n < methodArray.length) {
            Class<?>[] classArray;
            if (methodArray[n].getName().equals(string) && methodArray[n].getReturnType().equals(Void.TYPE) && (classArray = methodArray[n].getParameterTypes()).length == 1 && classArray[0].isArray()) {
                return methodArray[n];
            }
            ++n;
        }
        return null;
    }

    private Method findMultiSetMethod(String string, Method[] methodArray) {
        int n = 0;
        while (n < methodArray.length) {
            Class<?>[] classArray;
            if (methodArray[n].getName().equals(string) && methodArray[n].getReturnType().equals(Void.TYPE) && (classArray = methodArray[n].getParameterTypes()).length == 2 && (classArray[0].equals(Integer.TYPE) || classArray[0].equals(class$java$lang$String != null ? class$java$lang$String : JspBeanInfo.class$("java.lang.String")))) {
                return methodArray[n];
            }
            ++n;
        }
        return null;
    }

    private Method findSingleSetMethod(String string, Method[] methodArray) {
        int n = 0;
        while (n < methodArray.length) {
            Class<?>[] classArray;
            if (methodArray[n].getName().equals(string) && methodArray[n].getReturnType().equals(Void.TYPE) && (classArray = methodArray[n].getParameterTypes()).length == 1) {
                return methodArray[n];
            }
            ++n;
        }
        return null;
    }

    private JspBeanPropertyInfo findSetProperty(String string) {
        if (this.bean == null || this.isPrimitive) {
            return null;
        }
        string = string.length() > 1 ? String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1) : string.toUpperCase();
        Method[] methodArray = this.bean.getMethods();
        String string2 = "set" + string;
        Method method = this.findMultiSetMethod(string2, methodArray);
        if (method != null) {
            return new JspBeanMethodInfo(method);
        }
        method = this.findSingleSetMethod(string2, methodArray);
        if (method != null) {
            return new JspBeanMethodInfo(method);
        }
        return null;
    }

    private JspBeanPropertyInfo createGetPropertyFromBean(PropertyDescriptor propertyDescriptor) {
        JspBeanMethodInfo jspBeanMethodInfo;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            Method method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod();
            if (method == null) {
                return null;
            }
            jspBeanMethodInfo = new JspBeanMethodInfo(method, ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType());
        } else {
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) {
                return null;
            }
            jspBeanMethodInfo = new JspBeanMethodInfo(method, propertyDescriptor.getPropertyType());
            jspBeanMethodInfo.isMultiValue = false;
        }
        return jspBeanMethodInfo;
    }

    private JspBeanPropertyInfo createSetPropertyFromBean(PropertyDescriptor propertyDescriptor) {
        JspBeanMethodInfo jspBeanMethodInfo;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            Method method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
            if (method == null) {
                return null;
            }
            jspBeanMethodInfo = new JspBeanMethodInfo(method, ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType());
        } else {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return null;
            }
            jspBeanMethodInfo = new JspBeanMethodInfo(method, propertyDescriptor.getPropertyType());
            jspBeanMethodInfo.isMultiValue = false;
        }
        return jspBeanMethodInfo;
    }

    private JspBeanPropertyInfo beanGetProperty(String string) {
        this.getBeanInfo();
        if (this.beanInfo == null) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string)) {
                JspBeanPropertyInfo jspBeanPropertyInfo = this.createGetPropertyFromBean(propertyDescriptorArray[n]);
                if (jspBeanPropertyInfo != null) {
                    this.addGet(string, jspBeanPropertyInfo);
                }
                return jspBeanPropertyInfo;
            }
            ++n;
        }
        return null;
    }

    private JspBeanPropertyInfo beanSetProperty(String string) {
        this.getBeanInfo();
        if (this.beanInfo == null) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string)) {
                JspBeanPropertyInfo jspBeanPropertyInfo = this.createSetPropertyFromBean(propertyDescriptorArray[n]);
                if (jspBeanPropertyInfo != null) {
                    this.addSet(string, jspBeanPropertyInfo);
                }
                return jspBeanPropertyInfo;
            }
            ++n;
        }
        return null;
    }

    public Method findMethodByName(String string) {
        int n;
        Object[] objectArray;
        if (this.bean == null || this.isPrimitive) {
            return null;
        }
        this.getBeanInfo();
        if (this.beanInfo != null && (objectArray = this.beanInfo.getMethodDescriptors()) != null && objectArray.length > 0) {
            n = 0;
            while (n < objectArray.length) {
                if (((FeatureDescriptor)objectArray[n]).getName().equals(string)) {
                    return ((MethodDescriptor)objectArray[n]).getMethod();
                }
                ++n;
            }
        }
        objectArray = this.bean.getMethods();
        n = 0;
        while (n < objectArray.length) {
            if (((Method)objectArray[n]).getName().equals(string)) {
                return objectArray[n];
            }
            ++n;
        }
        return null;
    }

    public JspBeanPropertyInfo getGetProperty(String string, boolean bl) {
        if (this.isPrimitive) {
            return null;
        }
        JspBeanPropertyInfo jspBeanPropertyInfo = this.getGetProperty(string);
        if (jspBeanPropertyInfo != null) {
            return jspBeanPropertyInfo;
        }
        if (bl) {
            if (this.bean == null) {
                return null;
            }
            Field field = this.findSpecificField(string);
            if (field != null) {
                jspBeanPropertyInfo = new JspBeanFieldInfo(field);
                this.addGet(string, jspBeanPropertyInfo);
                return jspBeanPropertyInfo;
            }
            return null;
        }
        return null;
    }

    public JspBeanPropertyInfo getSetProperty(String string, boolean bl) {
        if (this.isPrimitive) {
            return null;
        }
        JspBeanPropertyInfo jspBeanPropertyInfo = this.getSetProperty(string);
        if (jspBeanPropertyInfo != null) {
            return jspBeanPropertyInfo;
        }
        if (bl) {
            if (this.bean == null) {
                return null;
            }
            Field field = this.findSpecificField(string);
            if (field != null) {
                jspBeanPropertyInfo = new JspBeanFieldInfo(field);
                this.addSet(string, jspBeanPropertyInfo);
                return jspBeanPropertyInfo;
            }
            return null;
        }
        return null;
    }

    private JspBeanPropertyInfo checkCache(Hashtable hashtable, String string) {
        JspBeanPropertyInfo jspBeanPropertyInfo;
        if (hashtable != null && (jspBeanPropertyInfo = (JspBeanPropertyInfo)hashtable.get(string)) != null) {
            return jspBeanPropertyInfo;
        }
        return null;
    }

    protected void addGet(String string, JspBeanPropertyInfo jspBeanPropertyInfo) {
        if (this.getMethods == null) {
            this.getMethods = new Hashtable();
        }
        this.getMethods.put(string, jspBeanPropertyInfo);
    }

    protected void addSet(String string, JspBeanPropertyInfo jspBeanPropertyInfo) {
        if (this.setMethods == null) {
            this.setMethods = new Hashtable();
        }
        this.setMethods.put(string, jspBeanPropertyInfo);
    }

    public JspBeanPropertyInfo getGetProperty(String string) {
        if (this.isPrimitive) {
            return null;
        }
        JspBeanPropertyInfo jspBeanPropertyInfo = this.checkCache(this.getMethods, string);
        if (jspBeanPropertyInfo != null) {
            return jspBeanPropertyInfo;
        }
        jspBeanPropertyInfo = this.beanGetProperty(string);
        if (jspBeanPropertyInfo != null) {
            return jspBeanPropertyInfo;
        }
        jspBeanPropertyInfo = this.findGetProperty(string);
        if (jspBeanPropertyInfo == null) {
            return null;
        }
        this.addGet(string, jspBeanPropertyInfo);
        return jspBeanPropertyInfo;
    }

    public JspBeanPropertyInfo getSetProperty(String string) {
        if (this.isPrimitive) {
            return null;
        }
        JspBeanPropertyInfo jspBeanPropertyInfo = this.checkCache(this.setMethods, string);
        if (jspBeanPropertyInfo != null) {
            return jspBeanPropertyInfo;
        }
        jspBeanPropertyInfo = this.beanSetProperty(string);
        if (jspBeanPropertyInfo != null) {
            return jspBeanPropertyInfo;
        }
        jspBeanPropertyInfo = this.findSetProperty(string);
        if (jspBeanPropertyInfo == null) {
            return null;
        }
        this.addSet(string, jspBeanPropertyInfo);
        return jspBeanPropertyInfo;
    }

    private void getBeanInfo() {
        if (this.beanInfo == null) {
            if (this.bean == null) {
                this.beanInfo = null;
                return;
            }
            try {
                this.beanInfo = Introspector.getBeanInfo(this.bean);
                return;
            }
            catch (IntrospectionException introspectionException) {
                this.beanInfo = null;
                return;
            }
        }
    }

    public JspBeanPropertyInfo getDefaultGetProperty(JspBeanDictionary jspBeanDictionary, boolean bl) {
        PropertyDescriptor[] propertyDescriptorArray;
        String string;
        if (this.isPrimitive) {
            return null;
        }
        if (this.bean != null && (string = jspBeanDictionary.getDefaultProperty(this.bean.getName())) != null && (propertyDescriptorArray = this.getGetProperty(string, true)) != null) {
            return propertyDescriptorArray;
        }
        this.getBeanInfo();
        if (this.beanInfo == null) {
            return null;
        }
        int n = this.beanInfo.getDefaultPropertyIndex();
        if (n < 0) {
            return null;
        }
        propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null || n >= propertyDescriptorArray.length) {
            return null;
        }
        return this.createGetPropertyFromBean(propertyDescriptorArray[n]);
    }

    public JspBeanPropertyInfo getDefaultSetProperty(JspBeanDictionary jspBeanDictionary, boolean bl) {
        PropertyDescriptor[] propertyDescriptorArray;
        String string;
        if (this.isPrimitive) {
            return null;
        }
        if (this.bean != null && (string = jspBeanDictionary.getDefaultProperty(this.bean.getName())) != null && (propertyDescriptorArray = this.getSetProperty(string, true)) != null) {
            return propertyDescriptorArray;
        }
        this.getBeanInfo();
        if (this.beanInfo == null) {
            return null;
        }
        int n = this.beanInfo.getDefaultPropertyIndex();
        if (n < 0) {
            return null;
        }
        propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null || n >= propertyDescriptorArray.length) {
            return null;
        }
        return this.createSetPropertyFromBean(propertyDescriptorArray[n]);
    }

    protected void removeCachedGet(String string) {
        if (this.getMethods == null) {
            return;
        }
        this.getMethods.remove(string);
    }

    public static int stringToScope(String string) {
        if (string.equals("page")) {
            return 1;
        }
        if (string.equals("request")) {
            return 2;
        }
        if (string.equals("session")) {
            return 3;
        }
        if (string.equals("application")) {
            return 4;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

