/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.jsp.parse.JspDirectiveAttrDesc;
import oracle.jsp.parse.JspDirectiveAttribute;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;

public abstract class JspDirective
implements Cloneable,
Serializable {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    protected JspDirectiveAttribute directive = new JspDirectiveAttribute(this.getDirectiveDescription());
    protected Vector attributes;
    protected JspDirectiveAttrDesc[] descriptions = this.getAttributeDescriptions();

    public abstract JspDirectiveAttrDesc getDirectiveDescription();

    public abstract JspDirectiveAttrDesc[] getAttributeDescriptions();

    protected Object clone() throws CloneNotSupportedException {
        JspDirective jspDirective = (JspDirective)super.clone();
        jspDirective.directive = (JspDirectiveAttribute)this.directive.clone();
        if (this.attributes != null) {
            jspDirective.attributes = new Vector();
            int n = 0;
            while (n < this.attributes.size()) {
                JspDirectiveAttribute jspDirectiveAttribute = (JspDirectiveAttribute)this.attributes.elementAt(n);
                jspDirective.attributes.addElement(jspDirectiveAttribute.clone());
                ++n;
            }
        }
        return jspDirective;
    }

    public void setValue(String string) {
        this.directive.setValue(string);
    }

    public String getValue() {
        return this.directive.getValue();
    }

    public String getName() {
        return this.directive.description.name;
    }

    public String getAttrValue(String string) {
        if (this.attributes == null) {
            return null;
        }
        JspDirectiveAttribute jspDirectiveAttribute = this.findAttribute(string);
        if (jspDirectiveAttribute != null) {
            return jspDirectiveAttribute.getValue();
        }
        return null;
    }

    private JspDirectiveAttribute findAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        int n = 0;
        while (n < this.attributes.size()) {
            JspDirectiveAttribute jspDirectiveAttribute = (JspDirectiveAttribute)this.attributes.elementAt(n);
            if (jspDirectiveAttribute.description.name.equals(string)) {
                return jspDirectiveAttribute;
            }
            ++n;
        }
        return null;
    }

    public void addAttribute(JspParseState jspParseState, String string, String string2) throws JspParseException {
        JspDirectiveAttribute jspDirectiveAttribute = this.findAttribute(string);
        if (jspDirectiveAttribute != null) {
            if (jspDirectiveAttribute.setValue(string2)) {
                return;
            }
            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_attr_value"), string2, string));
        }
        if (this.attributes == null) {
            this.attributes = new Vector();
        }
        int n = 0;
        while (n < this.descriptions.length) {
            if (this.descriptions[n].name.equals(string)) {
                jspDirectiveAttribute = new JspDirectiveAttribute(this.descriptions[n]);
                this.attributes.addElement(jspDirectiveAttribute);
                if (jspDirectiveAttribute.setValue(string2)) {
                    return;
                }
                throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_attr_value"), string2, string));
            }
            ++n;
        }
        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_attr"), string));
    }

    public void validateAttributes(JspParseState jspParseState) throws JspParseException {
        if (this.directive.getValue() == null && this.directive.description.required) {
            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_direct"), this.directive.description.name));
        }
        int n = 0;
        while (n < this.descriptions.length) {
            if (this.descriptions[n].required) {
                JspDirectiveAttribute jspDirectiveAttribute = this.findAttribute(this.descriptions[n].name);
                if (jspDirectiveAttribute == null) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_attr"), this.descriptions[n].name));
                }
                if (jspDirectiveAttribute.getValue() == null) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_attr_value"), this.descriptions[n].name));
                }
            }
            ++n;
        }
    }

    public String toString() {
        String string = MessageFormat.format(msgs.getString("print_direct"), this.directive.description.name, this.directive.getValue());
        string = this.attributes != null ? string.concat("\n\t" + msgs.getString("print_attrs") + this.attributes.toString()) : string.concat("\n");
        return string;
    }
}

