/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspBeanDictionary;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspParseState;

public class JspEmitState {
    public PrintWriter out;
    public OutputStream resOut;
    public Hashtable directives;
    public JspBeanDictionary beans;
    protected Vector declarations;
    protected Vector staticTexts;
    public boolean lastTextEndLine;
    public boolean lastNonTextEndLine;
    public String tabStr;
    public static final String INDENT_STR = "  ";
    public int currentLine;
    public int pageType;
    public JspParseState parseState;
    public Jsp2JavaParms parms;
    protected static int emitCount = 1;
    private String lineInfoFileName = "";
    private int lineInfoType;
    private int lineInfoNeeded;
    private static final int LINEINFO_USER = 1;
    private static final int LINEINFO_GENERATED = 2;
    private static final int LINEINFO_TRANSLATED = 3;
    private int lineInfoLineNum;
    private int lineInfoColNum;
    private String lineInfoStr;

    public JspEmitState(PrintWriter printWriter, OutputStream outputStream, JspParseState jspParseState) {
        this.out = printWriter;
        this.resOut = outputStream;
        this.parseState = jspParseState;
        this.directives = jspParseState.directives;
        this.declarations = jspParseState.declarations;
        this.staticTexts = new Vector();
        this.beans = jspParseState.beans;
        this.parms = jspParseState.parms;
        this.lastTextEndLine = true;
        this.lastNonTextEndLine = false;
        this.tabStr = INDENT_STR;
        this.currentLine = 1;
        this.ClearLineInfo();
    }

    public JspEmitState(PrintWriter printWriter, JspParseState jspParseState) {
        this(printWriter, null, jspParseState);
    }

    private void ClearLineInfo() {
        this.lineInfoLineNum = -1;
        this.lineInfoColNum = -1;
        this.lineInfoType = 0;
        this.lineInfoNeeded = 0;
        this.lineInfoStr = null;
    }

    public JspBeanDictionary getGlobalBeans() {
        if (this.parseState != null) {
            return this.parseState.getGlobalBeans();
        }
        return null;
    }

    public String getDirectiveValue(String string) {
        if (this.directives == null) {
            return null;
        }
        JspDirective jspDirective = (JspDirective)this.directives.get(string);
        if (jspDirective != null) {
            return jspDirective.getValue();
        }
        return null;
    }

    public String getDirectiveAttrValue(String string, String string2) {
        if (this.directives == null) {
            return null;
        }
        JspDirective jspDirective = (JspDirective)this.directives.get(string);
        if (jspDirective != null) {
            return jspDirective.getAttrValue(string2);
        }
        return null;
    }

    public void indent() {
        this.tabStr = this.tabStr.concat(INDENT_STR);
    }

    public void undent() {
        if (this.tabStr.length() > 1) {
            this.tabStr = this.tabStr.substring(INDENT_STR.length());
        }
    }

    public void print(String string) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            this.out.print(this.lineInfoStr);
            this.lineInfoStr = null;
            ++this.currentLine;
        }
        this.out.print(string);
    }

    public void iprint(String string) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            this.out.print(this.lineInfoStr);
            this.out.print(string);
            ++this.currentLine;
            this.lineInfoStr = null;
            return;
        }
        this.out.print(String.valueOf(this.tabStr) + string);
    }

    public void println(String string) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            this.out.print(this.lineInfoStr);
            this.lineInfoStr = null;
            ++this.currentLine;
        }
        this.out.println(string);
        ++this.currentLine;
    }

    public void iprintln(String string) {
        this.printLineInfoNeeded();
        if (this.lineInfoStr != null && this.lineInfoType != 2) {
            this.out.print(this.lineInfoStr);
            this.out.println(string);
            this.lineInfoStr = null;
            ++this.currentLine;
        } else {
            this.out.println(String.valueOf(this.tabStr) + string);
        }
        ++this.currentLine;
    }

    public void setPageType(int n) {
        this.pageType = n;
    }

    public boolean isGlobalsPage() {
        return this.pageType == 1;
    }

    public String getLineInfoFileName() {
        return this.lineInfoFileName;
    }

    public void printLineInfoFile(String string) {
        if (this.parms.genLineInfo && string != null && string.length() > 0 && this.lineInfoFileName != string) {
            this.out.println(String.valueOf(this.tabStr) + "/*@lineinfo:filename=" + string + "*/");
            int n = this.lineInfoNeeded;
            this.ClearLineInfo();
            this.lineInfoNeeded = n;
            ++this.currentLine;
        }
        if (string != null) {
            this.lineInfoFileName = string;
            return;
        }
        this.lineInfoFileName = "";
    }

    private boolean printLineInfoNeeded() {
        boolean bl = true;
        if (this.lineInfoNeeded != 0 && this.lineInfoNeeded != this.lineInfoType) {
            if (this.parms.genLineInfo) {
                if (this.lineInfoNeeded == 1) {
                    this.out.print(String.valueOf(this.tabStr) + "/*@lineinfo:user-code*/");
                    bl = false;
                } else if (this.lineInfoNeeded == 2) {
                    this.out.println(String.valueOf(this.tabStr) + "/*@lineinfo:generated-code*/");
                    bl = false;
                } else if (this.lineInfoNeeded == 3) {
                    this.out.print(String.valueOf(this.tabStr) + "/*@lineinfo:translated-code*/");
                    ++this.currentLine;
                }
            }
            this.lineInfoType = this.lineInfoNeeded;
        }
        return bl;
    }

    public void printLineInfoGenerated() {
        this.printLineInfoGenerated(false);
    }

    public void printLineInfoGenerated(boolean bl) {
        this.lineInfoNeeded = 2;
        if (this.parms.genLineInfo && bl) {
            this.lineInfoType = 0;
            this.printLineInfoNeeded();
        }
    }

    public void printLineInfoUser() {
        this.printLineInfoUser(false);
    }

    public void printLineInfoUser(boolean bl) {
        this.lineInfoNeeded = 1;
        if (this.parms.genLineInfo && bl) {
            this.lineInfoType = 0;
            this.printLineInfoNeeded();
        }
    }

    public void printLineInfoTranslated() {
        this.printLineInfoTranslated(false);
    }

    public void printLineInfoTranslated(boolean bl) {
        this.lineInfoNeeded = 3;
        if (this.parms.genLineInfo && bl) {
            this.lineInfoType = 0;
            this.printLineInfoNeeded();
        }
    }

    public void printLineInfo(int n, int n2) {
        if (n < 1) {
            n = 1;
        }
        if (this.parms.genLineInfo && (n != this.lineInfoLineNum || n2 != this.lineInfoColNum)) {
            this.lineInfoLineNum = n;
            this.lineInfoColNum = n2;
            this.lineInfoStr = "/*@lineinfo:" + Integer.toString(n - 1) + "^" + Integer.toString(n2) + "*/";
        }
    }

    public void dbgPrint(String string) {
        if (this.parms.debugOut != null) {
            this.parms.debugOut.print(string);
        }
    }

    public void dbgPrintln(String string) {
        if (this.parms.debugOut != null) {
            this.parms.debugOut.println(string);
        }
    }

    public int addStaticText(String string) {
        this.staticTexts.addElement(string);
        return this.staticTexts.size() - 1;
    }

    public Vector getStaticTexts() {
        return this.staticTexts;
    }
}

