/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import oracle.jsp.parse.JspBeanPropertyInfo;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagText;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.OpenJspDefineItem;
import oracle.jsp.parse.OpenJspTagHandler;
import oracle.jsp.parse.PropertyUtil;

public class JspRTTag
extends OpenJspTagHandler {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private TagInfo tagInfo;
    private JspParseState parseState;
    private OpenJspAVDesc[] avDesc;
    private String tagClassName;
    private Class tagClass;
    private boolean allowsBodyFlag;
    private boolean bodyTagFlag;
    private int tagVarCount;
    private String tagVarName;
    private String tagStartEvalVarName;
    private JspBeanPropertyInfo[] propsInfo;
    private String pushBodyCondition;
    private TagData tagAttrData;
    private VariableInfo[] tagVars;
    private OpenJspDefineItem[] beforeObjectsList;
    private OpenJspDefineItem[] afterObjectsList;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$BodyTag;

    public JspRTTag(TagInfo tagInfo, JspParseState jspParseState) throws JspParseException {
        this.tagInfo = tagInfo;
        this.parseState = jspParseState;
        this.convertAttrDesc();
        this.htmlTag = String.valueOf(tagInfo.getTagLibrary().getPrefixString()) + ":" + tagInfo.getTagName();
        this.tagClassName = tagInfo.getTagClassName();
        this.tagClass = JspUtils.loadClass(this.tagClassName, jspParseState);
        if (this.tagClass == null) {
            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_tag_class"), this.htmlTag, this.tagClassName));
        }
        this.bodyTagFlag = (class$javax$servlet$jsp$tagext$BodyTag != null ? class$javax$servlet$jsp$tagext$BodyTag : (class$javax$servlet$jsp$tagext$BodyTag = JspRTTag.class$("javax.servlet.jsp.tagext.BodyTag"))).isAssignableFrom(this.tagClass);
        this.allowsBodyFlag = !tagInfo.getBodyContent().equals("EMPTY");
        this.bodyIsText = tagInfo.getBodyContent().equals("TAGDEPENDENT");
        this.tagVarCount = jspParseState.getVarCount();
        this.tagVarName = "__jsp_tagext_taghandler_" + this.tagVarCount;
        this.tagStartEvalVarName = "__jsp_tagext_tag_start_eval_" + this.tagVarCount;
        this.pushBodyCondition = "if (" + this.tagStartEvalVarName + "==javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_TAG)";
    }

    protected boolean getScopeSensitive() {
        return false;
    }

    public boolean allowsBody() {
        return this.allowsBodyFlag;
    }

    public OpenJspAVDesc[] getAVDescriptions() {
        return this.avDesc;
    }

    private void convertAttrDesc() {
        if (this.avDesc == null) {
            TagAttributeInfo[] tagAttributeInfoArray = this.tagInfo.getAttributes();
            if (tagAttributeInfoArray == null) {
                tagAttributeInfoArray = new TagAttributeInfo[]{};
            }
            this.avDesc = new OpenJspAVDesc[tagAttributeInfoArray.length];
            int n = 0;
            while (n < tagAttributeInfoArray.length) {
                int n2 = tagAttributeInfoArray[n].canBeRequestTime() ? 11 : 1;
                this.avDesc[n] = new OpenJspAVDesc(tagAttributeInfoArray[n].getName(), n2, tagAttributeInfoArray[n].isRequired(), true, null);
                ++n;
            }
        }
    }

    private void convertAttrData(OpenJspAVInfo[] openJspAVInfoArray) {
        if (this.tagAttrData == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n = 0;
            while (n < openJspAVInfoArray.length) {
                String string = openJspAVInfoArray[n].desc.name;
                String string2 = openJspAVInfoArray[n].getStringValue();
                if (string2 != null) {
                    if (openJspAVInfoArray[n].isExpression()) {
                        string2 = null;
                    } else if (JspUtils.valueIsQuoted(string2)) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                }
                if (string2 != null) {
                    hashtable.put(string, string2);
                }
                ++n;
            }
            this.tagAttrData = new TagData(hashtable);
        }
    }

    public String validateAttributeList(JspParseState jspParseState, OpenJspAVInfo[] openJspAVInfoArray) {
        this.convertAttrData(openJspAVInfoArray);
        if (!this.tagInfo.isValid(this.tagAttrData)) {
            return MessageFormat.format(msgs.getString("invalid_attr_value"), this.htmlTag, this.tagClassName);
        }
        return null;
    }

    public OpenJspDefineItem[] getDefinedObjects() {
        this.tagVars = this.tagInfo.getVariableInfo(this.tagAttrData);
        Vector<OpenJspDefineItem> vector = new Vector<OpenJspDefineItem>();
        Vector<OpenJspDefineItem> vector2 = new Vector<OpenJspDefineItem>();
        OpenJspDefineItem openJspDefineItem = new OpenJspDefineItem(this.tagVarName, this.tagClassName);
        openJspDefineItem.setScope(10);
        vector.addElement(openJspDefineItem);
        if (this.tagVars != null) {
            int n = 0;
            while (n < this.tagVars.length) {
                if (this.tagVars[n].getDeclare()) {
                    OpenJspDefineItem openJspDefineItem2 = new OpenJspDefineItem(this.tagVars[n].getVarName(), this.tagVars[n].getClassName());
                    switch (this.tagVars[n].getScope()) {
                        case 0: {
                            openJspDefineItem2.setScope(10);
                            vector.addElement(openJspDefineItem2);
                            break;
                        }
                        case 1: {
                            openJspDefineItem2.setScope(1);
                            vector.addElement(openJspDefineItem2);
                            break;
                        }
                        case 2: {
                            openJspDefineItem2.setScope(1);
                            vector2.addElement(openJspDefineItem2);
                        }
                    }
                }
                ++n;
            }
        }
        this.beforeObjectsList = new OpenJspDefineItem[vector.size()];
        vector.copyInto(this.beforeObjectsList);
        this.afterObjectsList = new OpenJspDefineItem[vector2.size()];
        vector2.copyInto(this.afterObjectsList);
        return this.beforeObjectsList;
    }

    public void validateTagParse(JspParseState jspParseState) throws JspParseException {
        this.getSetProperties();
    }

    public void validateTextBody(JspParseState jspParseState, String string) throws JspParseException {
        JspParseTagText jspParseTagText = new JspParseTagText(this);
        jspParseTagText.setEscapeEnabled(false);
        jspParseTagText.addLine(string);
        this.body.addElement(jspParseTagText);
    }

    public OpenJspDefineItem[] getDefinedAfterObjects() {
        return this.afterObjectsList;
    }

    private void emitDeclarationAndSync(JspEmitState jspEmitState, int n, boolean bl, boolean bl2) {
        if (this.tagVars != null) {
            int n2 = 0;
            while (n2 < this.tagVars.length) {
                if (this.tagVars[n2].getScope() == n) {
                    String string = this.tagVars[n2].getClassName();
                    String string2 = this.tagVars[n2].getVarName();
                    if (bl && this.tagVars[n2].getDeclare()) {
                        jspEmitState.iprintln(String.valueOf(string) + " " + string2 + " = null;");
                    }
                    if (bl2) {
                        jspEmitState.iprintln(String.valueOf(string2) + " = (" + string + ") pageContext.findAttribute(" + "\"" + string2 + "\"" + ");");
                    }
                }
                ++n2;
            }
        }
    }

    public void emitStart(JspEmitState jspEmitState) {
        this.emitDeclarationAndSync(jspEmitState, 1, true, false);
        jspEmitState.iprintln("{");
        jspEmitState.indent();
        jspEmitState.iprintln(String.valueOf(this.tagClassName) + " " + this.tagVarName + "=new " + this.tagClassName + "();");
        jspEmitState.iprintln(String.valueOf(this.tagVarName) + ".setPageContext(pageContext);");
        JspRTTag jspRTTag = this.getRTParentTag();
        if (jspRTTag == null) {
            jspEmitState.iprintln(String.valueOf(this.tagVarName) + ".setParent(null);");
        } else {
            jspEmitState.iprintln(String.valueOf(this.tagVarName) + ".setParent(" + jspRTTag.tagVarName + ");");
        }
        int n = 0;
        while (n < this.avDesc.length) {
            OpenJspAVInfo openJspAVInfo = this.getAV(n);
            if (openJspAVInfo.valueExists()) {
                PropertyUtil.emitSetValue(jspEmitState, this.propsInfo[n], openJspAVInfo, this.tagVarName);
            }
            ++n;
        }
        this.emitDeclarationAndSync(jspEmitState, 0, true, false);
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        jspEmitState.iprintln("int " + this.tagStartEvalVarName + "=" + this.tagVarName + ".doStartTag();");
        if (!this.bodyTagFlag) {
            this.emitDeclarationAndSync(jspEmitState, 1, false, true);
            this.emitDeclarationAndSync(jspEmitState, 0, false, true);
        }
        if (this.bodyTagFlag) {
            jspEmitState.iprintln("if (" + this.tagStartEvalVarName + "==javax.servlet.jsp.tagext.Tag.EVAL_BODY_INCLUDE)");
            jspEmitState.indent();
            jspEmitState.iprintln(" throw new JspTagException(oracle.jsp.parse.JspRTTag.getMessage(\"invalid_eval_value\",new Object []{\"EVAL_BODY_INCLUDE\"," + this.tagClassName + ".class.getName()}));");
            jspEmitState.undent();
        } else {
            jspEmitState.iprintln("if (" + this.tagStartEvalVarName + "==javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_TAG)");
            jspEmitState.indent();
            jspEmitState.iprintln(" throw new JspTagException(oracle.jsp.parse.JspRTTag.getMessage(\"invalid_eval_value\",new Object []{\"EVAL_BODY_TAG\"," + this.tagClassName + ".class.getName()}));");
            jspEmitState.undent();
        }
        jspEmitState.iprintln("if (" + this.tagStartEvalVarName + "!=javax.servlet.jsp.tagext.Tag.SKIP_BODY)");
        jspEmitState.iprintln("{");
        jspEmitState.indent();
        jspEmitState.iprintln("try {");
        jspEmitState.indent();
        if (this.bodyTagFlag) {
            jspEmitState.iprintln(this.pushBodyCondition);
            jspEmitState.iprintln("{");
            jspEmitState.indent();
            jspEmitState.iprintln("out=pageContext.pushBody();");
            jspEmitState.iprintln(String.valueOf(this.tagVarName) + ".setBodyContent((javax.servlet.jsp.tagext.BodyContent)out);");
            jspEmitState.undent();
            jspEmitState.iprintln("}");
        }
        if (this.bodyTagFlag && this.hasBody()) {
            jspEmitState.iprintln(String.valueOf(this.tagVarName) + ".doInitBody();");
            jspEmitState.iprintln("do {");
            jspEmitState.indent();
            this.emitDeclarationAndSync(jspEmitState, 1, false, true);
            this.emitDeclarationAndSync(jspEmitState, 0, false, true);
        }
    }

    public void emitEnd(JspEmitState jspEmitState) {
        if (this.bodyTagFlag && this.hasBody()) {
            jspEmitState.undent();
            jspEmitState.iprintln("} while (" + this.tagVarName + ".doAfterBody()==javax.servlet.jsp.tagext.BodyTag.EVAL_BODY_TAG);");
        }
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("finally {");
        jspEmitState.indent();
        if (this.bodyTagFlag) {
            jspEmitState.iprintln(this.pushBodyCondition);
            jspEmitState.iprintln("{");
            jspEmitState.indent();
            jspEmitState.iprintln("out=pageContext.popBody();");
            jspEmitState.undent();
            jspEmitState.iprintln("}");
        }
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("if (" + this.tagVarName + ".doEndTag()==javax.servlet.jsp.tagext.Tag.SKIP_PAGE)");
        jspEmitState.indent();
        jspEmitState.iprintln("return;");
        jspEmitState.undent();
        this.emitDeclarationAndSync(jspEmitState, 1, false, true);
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.iprintln("finally {");
        jspEmitState.indent();
        jspEmitState.iprintln(String.valueOf(this.tagVarName) + ".release();");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        jspEmitState.undent();
        jspEmitState.iprintln("}");
        this.emitDeclarationAndSync(jspEmitState, 2, true, true);
    }

    private void getSetProperties() throws JspParseException {
        this.propsInfo = new JspBeanPropertyInfo[this.avDesc.length];
        int n = 0;
        while (n < this.avDesc.length) {
            OpenJspAVInfo openJspAVInfo = this.getAV(n);
            if (openJspAVInfo.valueExists()) {
                this.propsInfo[n] = this.parseState.beans.getSetPropertyInfo(this.tagVarName, this.avDesc[n].name);
                if (this.propsInfo[n] == null) {
                    throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_bean_prop"), this.avDesc[n].name, this.tagClassName));
                }
                PropertyUtil.checkSetValue(openJspAVInfo, this.propsInfo[n], this.parseState);
            } else {
                this.propsInfo[n] = null;
            }
            ++n;
        }
    }

    private JspRTTag getRTParentTag() {
        JspParseTag jspParseTag = this.parent;
        while (jspParseTag != null) {
            if (jspParseTag instanceof JspRTTag) {
                return (JspRTTag)jspParseTag;
            }
            jspParseTag = jspParseTag.parent;
        }
        return null;
    }

    public static String getMessage(String string, Object[] objectArray) {
        return MessageFormat.format(msgs.getString(string), objectArray);
    }

    public static String getMessage(String string) {
        return msgs.getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

