/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.provider.JspReqResourceException;
import oracle.jsp.provider.JspReqResourceProvider;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.tagext.OracleTagLibraryInfo;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String WEBXML_LOC = "/WEB-INF/web.xml";
    public static final String JARTLD_LOC = "META-INF/taglib.tld";
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private static Hashtable dtdTable = new Hashtable();
    static /* synthetic */ Class class$oracle$jsp$parse$XMLUtil;

    private static InputStream getInternalResourceStream(String string) {
        return (class$oracle$jsp$parse$XMLUtil != null ? class$oracle$jsp$parse$XMLUtil : (class$oracle$jsp$parse$XMLUtil = XMLUtil.class$("oracle.jsp.parse.XMLUtil"))).getResourceAsStream(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized DTD getDTD(String string, String string2) throws IOException, XMLParseException, SAXException {
        DTD dTD;
        DTD dTD2 = (DTD)dtdTable.get(string);
        if (dTD2 != null) {
            return dTD2;
        }
        DOMParser dOMParser = new DOMParser();
        InputStream inputStream = null;
        try {
            inputStream = (class$oracle$jsp$parse$XMLUtil != null ? class$oracle$jsp$parse$XMLUtil : (class$oracle$jsp$parse$XMLUtil = XMLUtil.class$("oracle.jsp.parse.XMLUtil"))).getResourceAsStream(string);
            dOMParser.parseDTD(inputStream, string2);
            dTD2 = dOMParser.getDoctype();
            dtdTable.put(string, dTD2);
            dTD = dTD2;
            Object var7_6 = null;
            if (inputStream == null) return dTD;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return dTD;
    }

    public static InputStream getFromStream(JspParseState jspParseState, String string) throws FileNotFoundException, IOException, JspReqResourceException {
        InputStream inputStream = null;
        JspResourceProvider jspResourceProvider = jspParseState.parms.resourceProvider;
        inputStream = jspResourceProvider instanceof JspReqResourceProvider ? ((JspReqResourceProvider)jspResourceProvider).fromStream(string, jspParseState.parms.compileHttpReq) : jspResourceProvider.fromStream(string);
        return inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Document getWebAppDoc(JspParseState jspParseState) throws FileNotFoundException, IOException, SAXException, XMLParseException, JspReqResourceException {
        XMLDocument xMLDocument;
        DOMParser dOMParser = new DOMParser();
        DTD dTD = XMLUtil.getDTD("web-app_2_2.dtd", "web-app");
        dOMParser.setDoctype(dTD);
        dOMParser.setErrorStream((OutputStream)System.err);
        dOMParser.setValidationMode(true);
        dOMParser.showWarnings(true);
        InputStream inputStream = null;
        try {
            XMLDocument xMLDocument2;
            inputStream = XMLUtil.getFromStream(jspParseState, WEBXML_LOC);
            dOMParser.parse(inputStream);
            xMLDocument = xMLDocument2 = dOMParser.getDocument();
            Object var6_6 = null;
            if (inputStream == null) return xMLDocument;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return xMLDocument;
    }

    public static Hashtable domDocToTaglibTable(Document document) {
        NodeList nodeList = document.getElementsByTagName("taglib");
        int n = nodeList.getLength();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            NodeList nodeList2 = element.getChildNodes();
            Object object = (Element)nodeList2.item(0);
            object = (object.hasChildNodes() ? object.getFirstChild().getNodeValue() : null).trim();
            Object object2 = (Element)nodeList2.item(1);
            object2 = (object2.hasChildNodes() ? object2.getFirstChild().getNodeValue() : null).trim();
            hashtable.put(object, object2);
            ++n2;
        }
        return hashtable;
    }

    public static String getSimpleElemValue(Element element) {
        if (element.hasChildNodes()) {
            return element.getFirstChild().getNodeValue();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Document getTLDDoc(JspParseState jspParseState, String string) throws FileNotFoundException, IOException, SAXException, XMLParseException, ZipException, JspReqResourceException {
        XMLDocument xMLDocument;
        ZipInputStream zipInputStream;
        InputStream inputStream;
        block10: {
            InputStream inputStream2 = null;
            inputStream = null;
            zipInputStream = null;
            try {
                XMLDocument xMLDocument2;
                Object object;
                if (string.endsWith(".jar") || string.endsWith(".JAR")) {
                    inputStream = XMLUtil.getFromStream(jspParseState, string);
                    zipInputStream = new ZipInputStream(inputStream);
                    object = null;
                    do {
                        if ((object = zipInputStream.getNextEntry()) == null) continue;
                        if (((ZipEntry)object).getName().equals(JARTLD_LOC)) {
                            inputStream2 = zipInputStream;
                            continue;
                        }
                        zipInputStream.closeEntry();
                    } while (object != null && inputStream2 == null);
                    if (inputStream2 == null) {
                        throw new FileNotFoundException(msgs.getString("jar_tld_not_found"));
                    }
                } else {
                    inputStream2 = XMLUtil.getFromStream(jspParseState, string);
                }
                object = new DOMParser();
                DTD dTD = XMLUtil.getDTD("web-jsptaglibrary_1_1.dtd", "taglib");
                object.setDoctype(dTD);
                object.setErrorStream((OutputStream)System.err);
                object.setValidationMode(true);
                object.showWarnings(true);
                object.parse(inputStream2);
                xMLDocument = xMLDocument2 = object.getDocument();
                Object var7_9 = null;
                if (inputStream2 == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream2.close();
        }
        if (zipInputStream != null) {
            zipInputStream.close();
        }
        if (inputStream == null) return xMLDocument;
        inputStream.close();
        return xMLDocument;
    }

    public static TagLibraryInfo domDocToTagLib(String string, String string2, Document document, JspParseState jspParseState) throws ClassNotFoundException, IllegalAccessException, InstantiationException, JspParseException {
        TagInfo tagInfo;
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        OracleTagLibraryInfo oracleTagLibraryInfo = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<TagInfo> vector = new Vector<TagInfo>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element) {
                String string3;
                Element element2 = (Element)node;
                String string4 = element2.getNodeName();
                String string5 = string3 = element2.hasChildNodes() ? element2.getFirstChild().getNodeValue() : null;
                if (string4.equals("tag")) {
                    if (oracleTagLibraryInfo == null) {
                        oracleTagLibraryInfo = new OracleTagLibraryInfo(string, string2, (String)hashtable.get("tlibversion"), (String)hashtable.get("jspversion"), (String)hashtable.get("shortname"), (String)hashtable.get("uri"), (String)hashtable.get("info"));
                    }
                    tagInfo = XMLUtil.elemToTagInfo(oracleTagLibraryInfo, element2, jspParseState);
                    vector.addElement(tagInfo);
                } else if (string3 != null) {
                    hashtable.put(string4, string3.trim());
                }
            }
            ++n2;
        }
        tagInfo = new TagInfo[vector.size()];
        vector.copyInto((Object[])tagInfo);
        oracleTagLibraryInfo.setTags((TagInfo[])tagInfo);
        return oracleTagLibraryInfo;
    }

    private static TagInfo elemToTagInfo(TagLibraryInfo tagLibraryInfo, Element element, JspParseState jspParseState) throws ClassNotFoundException, IllegalAccessException, InstantiationException, JspParseException {
        Object object;
        String string;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        TagInfo tagInfo = null;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element) {
                String string2;
                Element element2 = (Element)node;
                String string3 = element2.getNodeName();
                String string4 = string2 = element2.hasChildNodes() ? element2.getFirstChild().getNodeValue() : null;
                if (string3.equals("attribute")) {
                    string = XMLUtil.elemToAttr(element2);
                    vector.addElement(string);
                } else if (string2 != null) {
                    hashtable.put(string3, string2.trim());
                }
            }
            ++n2;
        }
        string = (String)hashtable.get("teiclass");
        TagExtraInfo tagExtraInfo = null;
        if (string != null) {
            object = null;
            object = JspUtils.loadClass(string, jspParseState);
            if (object == null) {
                throw new ClassNotFoundException(string);
            }
            tagExtraInfo = (TagExtraInfo)((Class)object).newInstance();
        }
        if ((object = (String)hashtable.get("bodycontent")) != null) {
            if (!(((String)(object = ((String)object).toUpperCase())).equals("JSP") || ((String)object).equals("TAGDEPENDENT") || ((String)object).equals("EMPTY"))) {
                throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("invalid_tld_body_value"), object));
            }
        } else {
            object = "JSP";
        }
        Object[] objectArray = new TagAttributeInfo[vector.size()];
        vector.copyInto(objectArray);
        tagInfo = new TagInfo((String)hashtable.get("name"), (String)hashtable.get("tagclass"), (String)object, (String)hashtable.get("info"), tagLibraryInfo, tagExtraInfo, (TagAttributeInfo[])objectArray);
        if (tagExtraInfo != null) {
            tagExtraInfo.setTagInfo(tagInfo);
        }
        return tagInfo;
    }

    public static TagAttributeInfo elemToAttr(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element) {
                String string;
                Element element2 = (Element)node;
                String string2 = element2.getNodeName();
                String string3 = string = element2.hasChildNodes() ? element2.getFirstChild().getNodeValue() : null;
                if (string != null) {
                    hashtable.put(string2, string.trim());
                }
            }
            ++n2;
        }
        return new TagAttributeInfo((String)hashtable.get("name"), XMLUtil.convBoolStr((String)hashtable.get("required"), false), null, XMLUtil.convBoolStr((String)hashtable.get("rtexprvalue"), false));
    }

    public static boolean convBoolStr(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if ((string = string.toLowerCase()).equals("yes") || string.equals("true")) {
            return true;
        }
        if (string.equals("no") || string.equals("false")) {
            return false;
        }
        return bl;
    }

    public static boolean jsp11Style(String string) {
        if (string.indexOf("/") != -1) {
            return true;
        }
        return string.endsWith(".tld") || string.endsWith(".TLD") || string.endsWith(".jar") || string.endsWith(".JAR");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

