/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;
import oracle.jsp.event.ApplicationEvent;
import oracle.jsp.event.ApplicationListener;
import oracle.jsp.event.JspScopeEvent;
import oracle.jsp.event.JspScopeListener;
import oracle.jsp.provider.HttpRequestProvider;
import oracle.jsp.runtime.JspHttpRequest;
import oracle.jsp.runtime.JspServletContext;
import oracle.jsp.util.JspVersion;

public abstract class HttpJsp
implements HttpJspPage {
    static final String GLOBALS_CLASSNAME = "_globalsClassName";
    static final String HAS_SESSION_ONSTART = "_has_session_OnStart";
    static final String HAS_SESSION_ONEND = "_has_session_OnEnd";
    static final String HAS_APPLICATION_ONSTART = "_has_application_OnStart";
    static final String HAS_APPLICATION_ONEND = "_has_application_OnEnd";
    static final String REQUEST_PROVIDER = "request_provider";
    static final String DEFAULT_REQUEST_PROVIDER = "oracle.jsp.provider.JspUniversalRequestProvider";
    private HttpRequestProvider requestProvider;
    private Object globalsInst;
    private boolean hasSessionOnStart = false;
    private boolean hasSessionOnEnd = false;
    private boolean hasApplicationOnStart = false;
    private boolean hasApplicationOnEnd = false;
    private boolean translateParams = false;
    private ServletConfig config;
    private static final String MESSAGE_FILE = "oracle.jsp.runtime.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.runtime.LocalStrings");

    public final void init(ServletConfig servletConfig) throws ServletException {
        this.config = servletConfig;
        this.getLifecycleEventHandler();
        String string = servletConfig.getInitParameter("translate_params");
        if (string != null) {
            this.translateParams = Boolean.valueOf(string);
        }
        if (this.hasSessionOnStart || this.hasSessionOnEnd) {
            this.getRequestProvider(servletConfig);
        }
        this.jspInit();
    }

    public final ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "HttpJsp servlet";
    }

    public final void destroy() {
        String string = null;
        ServletContext servletContext = this.config.getServletContext();
        if (this.globalsInst != null && this.hasApplicationOnEnd && (string = (String)servletContext.getAttribute("oracle.jsp.appOnEndNotified")) == null) {
            this.notifyApplicationEvent((ApplicationListener)this.globalsInst, 1, this.config.getServletContext());
            if (JspVersion.getServletVersion(servletContext) == 1) {
                ((JspServletContext)servletContext).setAttribute("oracle.jsp.appOnEndNotified", "true");
            } else {
                servletContext.setAttribute("oracle.jsp.appOnEndNotified", (Object)"true");
            }
        }
        if ((string = (String)servletContext.getAttribute("oracle.jsp.appReleaseNotified")) == null) {
            if (servletContext instanceof JspServletContext) {
                JspServletContext jspServletContext = (JspServletContext)servletContext;
                this.notifyOJSPAppRelease(jspServletContext);
                jspServletContext.setAttribute("oracle.jsp.appReleaseNotified", "true");
            } else {
                this.notifyAppRelease(servletContext);
                servletContext.setAttribute("oracle.jsp.appReleaseNotified", (Object)"true");
            }
        }
        this.jspDestroy();
    }

    public final void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.setContentType("text/html;charset=ISO-8859-1");
        if (!(httpServletRequest instanceof JspHttpRequest) && (this.translateParams || this.globalsInst != null && (this.hasSessionOnStart || this.hasSessionOnEnd))) {
            httpServletRequest = this.requestProvider.getRequest(httpServletRequest, httpServletResponse, this.config.getServletContext(), this.translateParams);
        }
        this._jspService(httpServletRequest, httpServletResponse);
    }

    public void jspInit() {
    }

    public void jspDestroy() {
    }

    private final void getLifecycleEventHandler() throws ServletException {
        Class<?> clazz = this.getClass();
        Field field = null;
        String string = null;
        try {
            field = clazz.getField(GLOBALS_CLASSNAME);
            string = (String)field.get(this);
        }
        catch (Exception exception) {
            return;
        }
        if (string != null) {
            try {
                field = clazz.getField(HAS_APPLICATION_ONSTART);
                this.hasApplicationOnStart = field.getBoolean(this);
            }
            catch (Exception exception) {}
            try {
                field = clazz.getField(HAS_APPLICATION_ONEND);
                this.hasApplicationOnEnd = field.getBoolean(this);
            }
            catch (Exception exception) {}
            try {
                field = clazz.getField(HAS_SESSION_ONSTART);
                this.hasSessionOnStart = field.getBoolean(this);
            }
            catch (Exception exception) {}
            try {
                field = clazz.getField(HAS_SESSION_ONEND);
                this.hasSessionOnEnd = field.getBoolean(this);
            }
            catch (Exception exception) {}
            ServletContext servletContext = this.config.getServletContext();
            this.globalsInst = servletContext.getAttribute("oracle.jsp.jspGlobals");
            if (this.globalsInst == null) {
                this.globalsInst = this.loadGlobals(servletContext, string);
                this.notifyApplicationEvent((ApplicationListener)this.globalsInst, 0, servletContext);
            }
        }
    }

    private void getRequestProvider(ServletConfig servletConfig) throws ServletException {
        Class<?> clazz = null;
        String string = servletConfig.getInitParameter(REQUEST_PROVIDER);
        if (string == null) {
            string = DEFAULT_REQUEST_PROVIDER;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException(classNotFoundException.toString());
        }
        try {
            this.requestProvider = (HttpRequestProvider)clazz.newInstance();
            return;
        }
        catch (Exception exception) {
            throw new ServletException(exception.toString());
        }
    }

    private Object loadGlobals(ServletContext servletContext, String string) throws ServletException {
        Class<?> clazz = null;
        Object var4_4 = null;
        if (JspVersion.getServletVersion(servletContext) == 1) {
            String string2 = msgs.getString("no_events");
            servletContext.log(string2);
            throw new ServletException(string2);
        }
        try {
            clazz = Class.forName(string);
            var4_4 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServletException(exception.toString());
        }
        servletContext.setAttribute("oracle.jsp.jspGlobals", var4_4);
        return var4_4;
    }

    private void notifyApplicationEvent(ApplicationListener applicationListener, int n, ServletContext servletContext) {
        if (n == 0) {
            ApplicationEvent applicationEvent = new ApplicationEvent(this, n, servletContext);
            applicationListener.applicationOnStart(applicationEvent);
            return;
        }
        ApplicationEvent applicationEvent = new ApplicationEvent(this, n, servletContext);
        applicationListener.applicationOnEnd(applicationEvent);
    }

    private void notifyAppRelease(ServletContext servletContext) {
        Enumeration enumeration = servletContext.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = servletContext.getAttribute(string);
            if (object == null || !(object instanceof JspScopeListener)) continue;
            JspScopeListener jspScopeListener = (JspScopeListener)object;
            jspScopeListener.outOfScope(new JspScopeEvent(servletContext, servletContext, string, 4));
        }
    }

    private void notifyOJSPAppRelease(JspServletContext jspServletContext) {
        Enumeration enumeration = jspServletContext.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = jspServletContext.getAttribute(string);
            if (object == null || !(object instanceof JspScopeListener)) continue;
            JspScopeListener jspScopeListener = (JspScopeListener)object;
            jspScopeListener.outOfScope(new JspScopeEvent((ServletContext)jspServletContext, jspServletContext, string, 4));
        }
    }

    public abstract void _jspService(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
}

