/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import oracle.jsp.event.JspScopeEvent;
import oracle.jsp.event.JspScopeListener;
import oracle.jsp.runtime.JspHttpRequest;
import oracle.jsp.runtime.JspServletContext;
import oracle.jsp.runtime.OracleBodyContent;
import oracle.jsp.runtime.OracleJspWriter;
import oracle.jsp.util.JspUtil;
import oracle.jsp.util.JspVersion;

public class OraclePageContext
extends PageContext {
    public static final String JSP_VERSION = "1.1.0.0.0";
    private static final String MSG_FILE = "oracle.jsp.runtime.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.runtime.LocalStrings");
    public static final String JSP_GLOBALS = "oracle.jsp.jspGlobals";
    public static final String JSP_SESSION_MANAGER = "oracle.jsp.jspSessionMgr";
    public static final String JSP_APPLICATION_PATH = "oracle.jsp.jspApplicationPath";
    public static final String JSP_FULL_APPLICATION_PATH = "oracle.jsp.jspFullApplicationPath";
    public static final String JSP_APPONEND_NOTIFIED = "oracle.jsp.appOnEndNotified";
    public static final String JSP_APPRELEASE_NOTIFIED = "oracle.jsp.appReleaseNotified";
    public static final String JSP_VERSION_NUMBER = "oracle.jsp.versionNumber";
    public static final String JSP_REQUEST_REFCOUNT = "oracle.jsp.requestRefCount";
    public static final String JSP_APPLICATION_CLASSES = "/WEB-INF/classes";
    public static final String JSP_APPLICATION_LIBRARIES = "/WEB-INF/lib";
    public static final String JSP_APPLICATION = "oracle.jsp.JspApplication";
    public static final String JSP_SESSION = "oracle.jsp.JspSession";
    public static final String JSP_REQUEST = "oracle.jsp.JspRequest";
    public static final String JSPSQLJ_EXTENSION = ".sqljsp";
    public static final String SQLJ_EXTENSION = ".sqlj";
    public static final String JSP_EXTENSION = ".jsp";
    public static final String[] STATIC_EXTENSION = new String[]{".html", ".htm", ".txt"};
    public static final String JSP_DEFAULT_ENCODING = "ISO-8859-1";
    public static final String JSP_DEFAULT_ENCODING_PARAMETER = "ojsp_defaultEncoding";
    public static final String JSP_TRANSLATE_PARAMS = "translate_params";
    public static final String JSP_SERVLET = "oracle.jsp.JspServlet";
    private boolean needsSession;
    private Hashtable attributes;
    private HttpServletRequest request;
    private ServletResponse response;
    private HttpSession session;
    private ServletContext application;
    private JspWriter out;
    private Servlet servlet;
    private String errorPageURL;
    private boolean autoFlush;
    private int bufferSize = -1;
    private String pagePath;
    private Stack writerStack = new Stack();

    public OraclePageContext(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession) {
        this.needsSession = httpSession != null;
        this.session = httpSession;
        this.application = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.attributes = new Hashtable();
        this.attributes.put("javax.servlet.jsp.jspPageContext", this);
        this.attributes.put("javax.servlet.jsp.jspApplication", servletContext);
        if (httpServletRequest != null) {
            this.attributes.put("javax.servlet.jsp.jspRequest", httpServletRequest);
        }
        if (httpServletResponse != null) {
            this.attributes.put("javax.servlet.jsp.jspResponse", httpServletResponse);
        }
        if (httpSession != null) {
            this.attributes.put("javax.servlet.jsp.jspSession", httpSession);
        }
        this.createOut((ServletResponse)httpServletResponse);
    }

    public OraclePageContext() {
    }

    public Object findAttribute(String string) {
        Object object = this.getAttribute(string);
        if (object != null) {
            return object;
        }
        object = this.getAttribute(string, 2);
        if (object != null) {
            return object;
        }
        if (this.needsSession) {
            object = this.getAttribute(string, 3);
        }
        if (object != null) {
            return object;
        }
        object = this.getAttribute(string, 4);
        return object;
    }

    public void forward(String string) throws ServletException, IOException {
        if (JspVersion.getServletVersion(this.application) == 1) {
            RequestDispatcher requestDispatcher;
            if (!(this.application instanceof JspServletContext) || !(this.request instanceof JspHttpRequest)) {
                throw new ServletException(MessageFormat.format(msgs.getString("forward_failed"), string));
            }
            JspServletContext jspServletContext = (JspServletContext)this.application;
            if (string.charAt(0) != '/') {
                string = this.page2AppPath20(string);
            }
            if ((requestDispatcher = jspServletContext.getRequestDispatcher(string = JspUtil.handleDotsInPath(string, '/'))) == null) {
                throw new ServletException(MessageFormat.format(msgs.getString("bad_forward_url"), string));
            }
            requestDispatcher.forward((ServletRequest)this.request, this.response);
        } else {
            if (string.charAt(0) != '/') {
                string = this.page2AppPath(string);
            }
            string = JspUtil.handleDotsInPath(string, '/');
            RequestDispatcher requestDispatcher = this.application.getRequestDispatcher(string);
            HttpServletRequest httpServletRequest = this.request;
            if (this.request instanceof JspHttpRequest) {
                httpServletRequest = ((JspHttpRequest)this.request).getNativeRequest();
            }
            if (requestDispatcher == null) {
                throw new ServletException(MessageFormat.format(msgs.getString("bad_forward_mime"), string));
            }
            requestDispatcher.forward((ServletRequest)httpServletRequest, this.response);
        }
        this.setAttribute("oracle.jsp.requestRedirected", "true", 2);
    }

    public Object getAttribute(String string) {
        if (this.attributes != null) {
            return this.attributes.get(string);
        }
        return null;
    }

    public Object getAttribute(String string, int n) {
        if (n == 1) {
            return this.getAttribute(string);
        }
        if (n == 2 && this.request != null) {
            return this.request.getAttribute(string);
        }
        if (n == 3 && this.needsSession && this.session != null) {
            return this.session.getValue(string);
        }
        if (n == 4 && this.application != null) {
            return this.application.getAttribute(string);
        }
        return null;
    }

    public Enumeration getAttributeNamesInScope(int n) {
        if (n == 1 && this.attributes != null) {
            return this.attributes.keys();
        }
        if (n == 2 && this.request != null) {
            if (JspVersion.getServletVersion(this.application) == 1) {
                return ((JspHttpRequest)this.request).getAttributeNames();
            }
            return this.request.getAttributeNames();
        }
        if (n == 3 && this.needsSession && this.session != null) {
            String[] stringArray = this.session.getValueNames();
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
            return vector.elements();
        }
        if (n == 4 && this.application != null) {
            if (JspVersion.getServletVersion(this.application) == 1) {
                return ((JspServletContext)this.application).getAttributeNames();
            }
            return this.application.getAttributeNames();
        }
        return null;
    }

    public int getAttributesScope(String string) {
        Object object = this.getAttribute(string);
        if (object != null) {
            return 1;
        }
        object = this.getAttribute(string, 2);
        if (object != null) {
            return 2;
        }
        if (this.needsSession) {
            object = this.getAttribute(string, 3);
        }
        if (object != null) {
            return 3;
        }
        object = this.getAttribute(string, 4);
        if (object != null) {
            return 4;
        }
        return 0;
    }

    public Exception getException() {
        try {
            return (Exception)this.getAttribute("javax.servlet.jsp.jspException", 2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JspWriter getOut() {
        return this.out;
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getServletConfig() {
        if (this.servlet == null) {
            return null;
        }
        return this.servlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void setSession(HttpSession httpSession) {
        this.session = httpSession;
    }

    public void handlePageException(Exception exception) throws ServletException, IOException {
        this.setAttribute("javax.servlet.jsp.jspException", exception, 2);
        if (this.errorPageURL != null && this.errorPageURL.length() > 0) {
            this.forward(this.errorPageURL);
            return;
        }
        if (this.application != null) {
            this.application.log(exception, exception.getMessage());
        }
        if (this.response != null) {
            ((HttpServletResponse)this.response).setStatus(500);
            this.reportException(exception);
        }
    }

    private void reportException(Exception exception) {
        PrintWriter printWriter;
        try {
            printWriter = OracleJspWriter.acquireWriter(this.response);
        }
        catch (Exception exception2) {
            return;
        }
        printWriter.println("<HTML><BODY>");
        printWriter.println("<P> <H2  ALIGN=CENTER>JSP Error</H2> <HR  ALIGN=CENTER> <P>");
        printWriter.println("<BR><H3>" + msgs.getString("exception_hdr") + "</H3><PRE>");
        exception.printStackTrace(printWriter);
        printWriter.println("</PRE>");
        printWriter.println("<P><P><HR ALIGN=CENTER");
        printWriter.println("</HTML></BODY>");
        printWriter.close();
    }

    public void include(String string) throws ServletException, IOException {
        if (JspVersion.getServletVersion(this.application) == 1) {
            RequestDispatcher requestDispatcher;
            if (!(this.application instanceof JspServletContext) || !(this.request instanceof JspHttpRequest)) {
                throw new ServletException(MessageFormat.format(msgs.getString("include_failed"), string));
            }
            JspServletContext jspServletContext = (JspServletContext)this.application;
            if (string.charAt(0) != '/') {
                string = this.page2AppPath20(string);
            }
            if ((requestDispatcher = jspServletContext.getRequestDispatcher(string = JspUtil.handleDotsInPath(string, '/'))) == null) {
                throw new ServletException(MessageFormat.format(msgs.getString("bad_include_url"), string));
            }
            requestDispatcher.include((ServletRequest)this.request, this.response);
            return;
        }
        if (string.charAt(0) != '/') {
            string = this.page2AppPath(string);
        }
        string = JspUtil.handleDotsInPath(string, '/');
        RequestDispatcher requestDispatcher = this.application.getRequestDispatcher(string);
        HttpServletRequest httpServletRequest = this.request;
        if (this.request instanceof JspHttpRequest) {
            httpServletRequest = ((JspHttpRequest)this.request).getNativeRequest();
        }
        if (requestDispatcher == null) {
            throw new ServletException(MessageFormat.format(msgs.getString("bad_include_mime"), string));
        }
        requestDispatcher.include((ServletRequest)httpServletRequest, this.response);
    }

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException, IllegalStateException, IllegalArgumentException {
        this.attributes = new Hashtable();
        this.attributes.put("javax.servlet.jsp.jspPageContext", this);
        this.servlet = servlet;
        this.request = (HttpServletRequest)servletRequest;
        this.response = servletResponse;
        this.errorPageURL = string;
        this.needsSession = bl;
        this.bufferSize = n;
        this.autoFlush = bl2;
        ServletConfig servletConfig = servlet.getServletConfig();
        this.attributes.put("javax.servlet.jsp.jspConfig", servletConfig);
        this.attributes.put("javax.servlet.jsp.jspPage", servlet);
        this.attributes.put("javax.servlet.jsp.jspRequest", this.request);
        this.attributes.put("javax.servlet.jsp.jspResponse", servletResponse);
        this.application = servletConfig.getServletContext();
        this.attributes.put("javax.servlet.jsp.jspApplication", this.application);
        this.createOut(servletResponse);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this, 2);
        if (bl) {
            this.session = this.request.getSession(true);
            this.attributes.put("javax.servlet.jsp.jspSession", this.session);
        } else {
            this.session = null;
        }
        if (servletRequest != null) {
            this.incrementRequestRefCount();
        }
    }

    private void createOut(ServletResponse servletResponse) {
        this.out = null;
        if (servletResponse != null) {
            try {
                this.out = new OracleJspWriter(servletResponse, this.bufferSize, this.autoFlush);
            }
            catch (Exception exception) {
                this.out = null;
            }
        }
        if (this.out == null) {
            this.out = new OracleJspWriter(null, this.bufferSize, this.autoFlush);
        }
        this.attributes.put("javax.servlet.jsp.jspOut", this.out);
    }

    public void release() {
        Object object = this.getAttribute("oracle.jsp.pageDontNotify", 1);
        if (object == null) {
            this.notifyPageRelease();
            if (this.request != null && this.decrementRequestRefCount() <= 0) {
                this.notifyRequestRelease();
            }
        } else {
            this.removeAttribute("oracle.jsp.pageDontNotify", 1);
        }
        this.removeAttribute("javax.servlet.jsp.jspPageContext", 2);
        this.needsSession = false;
        this.attributes = null;
        this.request = null;
        this.response = null;
        this.session = null;
        this.application = null;
        this.out = null;
        this.servlet = null;
        this.errorPageURL = null;
        this.autoFlush = false;
        this.bufferSize = 0;
    }

    public void removeAttribute(String string) {
        int n = this.getAttributesScope(string);
        if (n != 0) {
            this.removeAttribute(string, n);
        }
    }

    public void removeAttribute(String string, int n) {
        if (n == 1 && this.attributes != null) {
            this.attributes.remove(string);
            return;
        }
        if (n != 2 || this.request == null) {
            if (n == 3 && this.session != null) {
                this.session.removeValue(string);
                return;
            }
            if (n == 4 && this.application != null) {
                if (JspVersion.getServletVersion(this.application) == 1) {
                    ((JspServletContext)this.application).removeAttribute(string);
                    return;
                }
                this.application.removeAttribute(string);
            }
        }
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(string, object, 1);
    }

    public void setAttribute(String string, Object object, int n) {
        if (n == 1 && this.attributes != null) {
            this.attributes.put(string, object);
            return;
        }
        if (n == 2 && this.request != null) {
            if (JspVersion.getServletVersion(this.application) == 1) {
                ((JspHttpRequest)this.request).setAttribute(string, object);
                return;
            }
            this.request.setAttribute(string, object);
            return;
        }
        if (n == 3 && this.session != null) {
            this.session.putValue(string, object);
            return;
        }
        if (n == 4 && this.application != null) {
            if (JspVersion.getServletVersion(this.application) == 1) {
                ((JspServletContext)this.application).setAttribute(string, object);
                return;
            }
            this.application.setAttribute(string, object);
        }
    }

    private String page2AppPath(String string) throws ServletException {
        if (this.pagePath == null) {
            this.pagePath = JspUtil.request2AppPath(this.request);
        }
        return String.valueOf(this.pagePath) + string;
    }

    private String page2AppPath20(String string) throws ServletException {
        if (this.pagePath == null) {
            String string2 = JspUtil.getPathInfo(this.request);
            if (string2 == null) {
                string2 = JspUtil.getServletPath(this.request);
            }
            if (string2 == null) {
                throw new ServletException(msgs.getString("no_page_path"));
            }
            int n = string2.lastIndexOf("/");
            if (n == -1) {
                throw new ServletException(msgs.getString("no_page_path"));
            }
            this.pagePath = n != string2.length() - 1 ? string2.substring(0, n + 1) : string2;
        }
        return String.valueOf(this.pagePath) + string;
    }

    private void incrementRequestRefCount() {
        Integer n = (Integer)this.request.getAttribute(JSP_REQUEST_REFCOUNT);
        int n2 = 1;
        if (n != null) {
            n2 += n.intValue();
        }
        if (this.request instanceof JspHttpRequest) {
            ((JspHttpRequest)this.request).setAttribute(JSP_REQUEST_REFCOUNT, new Integer(n2));
            return;
        }
        this.request.setAttribute(JSP_REQUEST_REFCOUNT, (Object)new Integer(n2));
    }

    private int decrementRequestRefCount() {
        int n = 0;
        Integer n2 = (Integer)this.request.getAttribute(JSP_REQUEST_REFCOUNT);
        if (n2 != null) {
            n = n2 - 1;
            if (this.request instanceof JspHttpRequest) {
                ((JspHttpRequest)this.request).setAttribute(JSP_REQUEST_REFCOUNT, new Integer(n));
            } else {
                this.request.setAttribute(JSP_REQUEST_REFCOUNT, (Object)new Integer(n));
            }
        }
        return n;
    }

    private void notifyRequestRelease() {
        if (this.request == null) {
            return;
        }
        Enumeration enumeration = null;
        enumeration = this.request instanceof JspHttpRequest ? ((JspHttpRequest)this.request).getAttributeNames() : this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.request.getAttribute(string);
            if (object == null || !(object instanceof JspScopeListener)) continue;
            JspScopeListener jspScopeListener = (JspScopeListener)object;
            jspScopeListener.outOfScope(new JspScopeEvent(this.application, this.request, string, 2));
        }
    }

    private void notifyPageRelease() {
        if (this.servlet == null || this.attributes == null) {
            return;
        }
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.getAttribute(string);
            if (object == null || !(object instanceof JspScopeListener)) continue;
            JspScopeListener jspScopeListener = (JspScopeListener)object;
            jspScopeListener.outOfScope(new JspScopeEvent(this.application, (Object)this, string, 1));
        }
    }

    public BodyContent pushBody() {
        JspWriter jspWriter = this.out;
        this.writerStack.push(this.out);
        this.out = new OracleBodyContent(jspWriter);
        return (BodyContent)this.out;
    }

    public JspWriter popBody() {
        this.out = (JspWriter)this.writerStack.pop();
        return this.out;
    }
}

