/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;

public class AttrDecl
extends XMLNode
implements XMLConstants,
Serializable {
    public static final int CDATA = 0;
    public static final int ID = 1;
    public static final int IDREF = 2;
    public static final int IDREFS = 3;
    public static final int ENTITY = 4;
    public static final int ENTITIES = 5;
    public static final int NMTOKEN = 6;
    public static final int NMTOKENS = 7;
    public static final int NOTATION = 8;
    public static final int ENUMERATION = 9;
    public static final int DEFAULT = 0;
    public static final int REQUIRED = 1;
    public static final int IMPLIED = 2;
    public static final int FIXED = 3;
    public int atttype;
    public int attpres = 0;
    public String def;
    public Vector values;
    public String prefix;
    public String localname;

    AttrDecl(String string, int n) {
        super(string, (short)14);
        this.atttype = n;
        this.prefix = "";
        this.localname = string;
    }

    public AttrDecl(String string, String string2, String string3, int n) {
        super(string, (short)14);
        this.atttype = n;
        this.prefix = string2;
        this.localname = string3;
    }

    String attPresToString() {
        switch (this.attpres) {
            case 2: {
                return "#IMPLIED";
            }
            case 1: {
                return "#REQUIRED";
            }
            case 3: {
                return "#FIXED";
            }
        }
        return "";
    }

    public int getAttrPresence() {
        return this.attpres;
    }

    public int getAttrType() {
        return this.atttype;
    }

    public String getDefaultValue() {
        return this.def;
    }

    public Vector getEnumerationValues() {
        return this.values;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.external) {
            xMLOutputStream.writeChars("<!ATTLIST ");
            xMLOutputStream.writeChars(String.valueOf(this.parent.tag) + " ");
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " ");
            if (this.atttype != 9) {
                xMLOutputStream.writeChars(String.valueOf(AttrDecl.typeToString(this.atttype)) + " ");
            }
            if (this.atttype == 9 || this.atttype == 8) {
                int n = this.values.size();
                xMLOutputStream.write(40);
                xMLOutputStream.writeChars((String)this.values.elementAt(0));
                int n2 = 1;
                while (n2 < n) {
                    xMLOutputStream.write(124);
                    xMLOutputStream.writeChars((String)this.values.elementAt(n2));
                    ++n2;
                }
                xMLOutputStream.write(41);
                xMLOutputStream.write(32);
            }
            if (this.attpres != 0) {
                xMLOutputStream.writeChars(this.attPresToString());
                xMLOutputStream.write(32);
            }
            if (this.def != null) {
                xMLOutputStream.writeQuotedString(this.def);
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
        }
    }

    public static String typeToString(int n) {
        switch (n) {
            case 1: {
                return "ID";
            }
            case 2: {
                return "IDREF";
            }
            case 3: {
                return "IDREFS";
            }
            case 4: {
                return "ENTITY";
            }
            case 5: {
                return "ENTITIES";
            }
            case 6: {
                return "NMTOKEN";
            }
            case 7: {
                return "NMTOKENS";
            }
            case 8: {
                return "NOTATION";
            }
            case 0: {
                return "CDATA";
            }
        }
        return "";
    }
}

