/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLAttrList
extends Vector
implements NamedNodeMap,
Serializable {
    XMLNode parent;

    public XMLAttrList() {
    }

    public XMLAttrList(int n) {
        super(n);
    }

    XMLAttrList cloneList(boolean bl) {
        XMLAttrList xMLAttrList = new XMLAttrList();
        xMLAttrList.parent = this.parent;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttr xMLAttr = (XMLAttr)((XMLAttr)enumeration.nextElement()).cloneNode(bl);
            xMLAttr.parent = this.parent;
            xMLAttrList.addElement(xMLAttr);
        }
        return xMLAttrList;
    }

    public int getLength() {
        return this.elementCount;
    }

    public Node getNamedItem(String string) {
        int n = 0;
        while (n < this.elementCount) {
            XMLAttr xMLAttr = (XMLAttr)this.elementData[n];
            if (xMLAttr.tag.equals(string)) {
                return xMLAttr;
            }
            ++n;
        }
        return null;
    }

    Node getNamedItem(String string, String string2) {
        int n = 0;
        while (n < this.elementCount) {
            XMLAttr xMLAttr = (XMLAttr)this.elementData[n];
            if (xMLAttr.checkNamespace(string, string2)) {
                return xMLAttr;
            }
            ++n;
        }
        return null;
    }

    boolean isMember(XMLAttr xMLAttr) {
        return this.indexOf(xMLAttr, 0) != -1;
    }

    public Node item(int n) {
        try {
            return (Node)this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        int n = 0;
        while (n < this.elementCount) {
            ((XMLAttr)this.elementData[n]).print(xMLOutputStream, bl);
            ++n;
        }
    }

    void put(String string, String string2) {
        XMLAttr xMLAttr = (XMLAttr)this.getNamedItem(string);
        if (xMLAttr != null) {
            xMLAttr.setNodeValue(string2);
        } else {
            XMLDocument xMLDocument = (XMLDocument)this.parent.getOwnerDocument();
            xMLAttr = xMLDocument != null ? xMLDocument.factory.createAttribute(string, string2) : new XMLAttr(string, string2);
            if (xMLAttr != null) {
                this.addElement(xMLAttr);
            }
        }
        if (xMLAttr != null) {
            xMLAttr.parent = this.parent;
            xMLAttr.inUse = true;
            xMLAttr.specified = true;
        }
    }

    XMLAttr remove(XMLAttr xMLAttr) {
        this.removeElement(xMLAttr);
        xMLAttr.parent = null;
        xMLAttr.inUse = false;
        return xMLAttr;
    }

    public Node removeNamedItem(String string) throws DOMException {
        XMLAttr xMLAttr = (XMLAttr)this.getNamedItem(string);
        if (xMLAttr != null) {
            if (!this.setAttributeDefault(xMLAttr)) {
                this.remove(xMLAttr);
            }
        } else {
            throw new XMLDOMException(8, this.parent.getXMLError());
        }
        xMLAttr.specified = false;
        return xMLAttr;
    }

    boolean setAttributeDefault(XMLAttr xMLAttr) {
        AttrDecl attrDecl;
        ElementDecl elementDecl;
        if (this.parent != null && (elementDecl = ((XMLElement)this.parent).ed) != null && (attrDecl = elementDecl.findAttrDecl(xMLAttr.getName())) != null && attrDecl.def != null) {
            xMLAttr.setValue(attrDecl.def);
            return true;
        }
        return false;
    }

    public Node setNamedItem(Node node) throws DOMException {
        XMLAttr xMLAttr = (XMLAttr)node;
        if (xMLAttr.inUse && xMLAttr.parent != this.parent) {
            throw new XMLDOMException(10, this.parent.getXMLError());
        }
        this.parent.checkDocument(node);
        this.parent.checkReadOnly();
        XMLAttr xMLAttr2 = (XMLAttr)this.getNamedItem(xMLAttr.getName());
        if (xMLAttr2 != null) {
            this.remove(xMLAttr2);
            xMLAttr2.specified = false;
        }
        xMLAttr.parent = this.parent;
        xMLAttr.inUse = true;
        xMLAttr.specified = true;
        this.addElement(xMLAttr);
        return xMLAttr2;
    }
}

