/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.xml.parser.v2.XMLByteReader;
import org.xml.sax.SAXException;

public class XMLCharReader
extends XMLByteReader {
    InputStream in;
    Reader r = null;
    boolean closeReader = false;
    boolean fixedCoords = false;
    XMLByteReader prevReader = null;
    boolean lastCharNewLine = false;
    static final int[] CP037ToUTF8 = new int[]{-1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46, 60, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, -1, -1, -1, 61, 34, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, -1, -1, -1, -1, -1, -1, 106, 107, 108, 109, 110, 111, 112, 113, 114, -1, -1, -1, -1, -1, -1, -1, -1, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, -1, -1, -1, -1, -1, -1, 74, 75, 76, 77, 78, 79, 80, 81, 82, -1, -1, -1, -1, -1, -1, -1, -1, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1};

    public XMLCharReader(InputStream inputStream, String string, String string2) throws IOException {
        this.in = inputStream;
        this.sysId = string;
        this.pubId = string2;
    }

    public XMLCharReader(Reader reader, String string, String string2) throws IOException {
        this.r = reader;
        this.sysId = string;
        this.pubId = string2;
    }

    public XMLCharReader(String string, String string2, String string3) throws IOException {
        super(string.length());
        this.sysId = string2;
        this.pubId = string3;
        string.getChars(0, string.length(), this.currentBuffer, 0);
        this.currentPos = 0;
        this.eofPos = this.endPos = string.length();
        this.fixedCoords = true;
    }

    public void close() throws SAXException {
        try {
            if (this.r != null && this.closeReader) {
                this.r.close();
            }
            if (this.in != null && this.closeInput) {
                this.in.close();
            }
        }
        catch (IOException iOException) {}
    }

    int fillBuffer(int n) throws IOException {
        if (this.fixedCoords) {
            return 0;
        }
        this.endPos = this.currentPos = this.copyPushBack(n);
        int n2 = 0;
        int n3 = this.BUFSIZE - this.endPos;
        int n4 = 0;
        while (n3 > 0 && n2 != -1) {
            char c;
            n2 = this.r.read(this.currentBuffer, this.endPos, n3);
            if (n2 == -1) continue;
            int n5 = this.endPos + n2 - 1;
            n4 = 0;
            if (this.lastCharNewLine) {
                if (this.currentBuffer[this.endPos] == '\n') {
                    ++n4;
                }
                this.lastCharNewLine = false;
            }
            int n6 = this.endPos;
            if (n4 == 0) {
                while (n6 < n5) {
                    c = this.currentBuffer[n6];
                    if (c == '\n' || c == '\r') {
                        this.setLineNumber(n6);
                        if (c == '\r' && this.currentBuffer[n6 + 1] == '\n') {
                            this.currentBuffer[n6] = 10;
                            ++n4;
                            ++n6;
                            break;
                        }
                        this.currentBuffer[n6] = 10;
                    }
                    ++n6;
                }
            }
            while (n6 < n5) {
                c = this.currentBuffer[n6];
                if (c == '\n' || c == '\r') {
                    this.setLineNumber(n6 - n4);
                    if (c == '\r' && this.currentBuffer[n6 + 1] == '\n') {
                        this.currentBuffer[n6 - n4] = 10;
                        ++n4;
                        ++n6;
                    } else {
                        this.currentBuffer[n6 - n4] = 10;
                    }
                } else {
                    this.currentBuffer[n6 - n4] = this.currentBuffer[n6];
                }
                ++n6;
            }
            if (n6 == n5) {
                if (this.currentBuffer[n6] == '\r') {
                    this.lastCharNewLine = true;
                    this.currentBuffer[n6 - n4] = 10;
                } else {
                    this.currentBuffer[n6 - n4] = this.currentBuffer[n6];
                }
            }
            this.endPos += (n2 -= n4);
            n3 -= n2;
        }
        if (n2 == -1) {
            this.setEOF(this.endPos);
        }
        return this.currentPos;
    }

    int fillBuffer(char[] cArray, int n, String string) throws IOException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n < 1) {
            return -1;
        }
        n5 = this.endPos = (this.currentPos = this.copyPushBack(0));
        while (n3 < n) {
            if (n5 >= this.endPos && (n4 = this.in.read()) != -1) {
                n4 = CP037ToUTF8[n4];
                this.currentBuffer[this.endPos] = (char)n4;
                n5 = this.endPos++;
            }
            if (n4 == -1) break;
            n2 = this.currentBuffer[n5];
            if (n2 == cArray[n3]) {
                ++n3;
                ++n5;
                continue;
            }
            if (n3 > 0) {
                n5 = n5 - n3 + 1;
                n3 = 0;
                continue;
            }
            ++n5;
        }
        if (n3 != n) {
            return -1;
        }
        n2 = this.endPos - this.currentPos;
        System.arraycopy(this.currentBuffer, this.currentPos, this.currentBuffer, this.BUFSIZE - n2, n2);
        this.currentPos = this.BUFSIZE - n2;
        this.endPos = this.BUFSIZE;
        return this.currentPos;
    }

    public int getColumnNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    public int getLineNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getLineNumber();
        }
        return super.getLineNumber();
    }

    public void reset() {
        this.currentPos = 0;
        this.eofPos = this.endPos;
    }

    void setEncoding(String string) throws IOException {
        this.r = new InputStreamReader(this.in, string);
    }

    public void setPrevReader(XMLByteReader xMLByteReader) {
        this.prevReader = xMLByteReader;
    }

    void setReader(Reader reader) {
        this.r = reader;
    }
}

