/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import org.xml.sax.SAXException;

class XMLExternalReader
extends XMLReader {
    XMLReader prevReader;
    int startInput;

    XMLExternalReader(XMLReader xMLReader) {
        this.prevReader = xMLReader;
        this.dtd = xMLReader.dtd;
        this.input = xMLReader.input;
        this.input.setParent(this);
        this.currentBuffer = xMLReader.currentBuffer;
        this.currentPos = xMLReader.currentPos;
        this.inputArray = xMLReader.inputArray;
        this.currentInput = xMLReader.currentInput;
        this.startInput = xMLReader.currentInput;
        this.entResolver = xMLReader.entResolver;
        this.err = xMLReader.err;
        this.xmlHandler = xMLReader.xmlHandler;
    }

    void checkEntityEnd() throws SAXException, IOException {
        while (this.popEntityRef()) {
        }
    }

    void checkEntityStart() throws SAXException, IOException {
        while (this.pushEntityRef()) {
        }
    }

    public boolean checkParEntity() throws SAXException, IOException {
        try {
            if (this.currentBuffer[this.currentPos] == '%') {
                ++this.currentPos;
                if (this.skipWhiteSpace()) {
                    return true;
                }
                --this.currentPos;
                this.pushEntityRef();
                boolean bl = this.checkParEntity();
                this.checkEntityEnd();
                return bl;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.currentPos = this.input.fillBuffer(1000);
            return this.checkParEntity();
        }
    }

    XMLEntity getEntity(boolean bl) throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity;
        String string = super.scanQName();
        if (!super.tryRead(59)) {
            this.err.error(this, this.err.getMessage1(100, ";"), 100, 0, false);
        }
        if ((xMLEntity = (XMLEntity)this.dtd.findEntity(string, bl)) == null) {
            this.err.error(this, this.err.getMessage1(250, string), 250, 0, false);
        }
        return xMLEntity;
    }

    XMLExternalReader getExternalReader() {
        return this;
    }

    XMLReader getInternalReader() throws SAXException, IOException {
        this.popXMLReader();
        this.prevReader.input = this.input;
        this.prevReader.currentInput = this.currentInput;
        this.prevReader.currentPos = this.currentPos;
        this.prevReader.currentBuffer = this.currentBuffer;
        this.input.pushChar(32);
        return this.prevReader;
    }

    boolean popEntityRef() throws SAXException, IOException {
        if (this.startInput == this.currentInput) {
            return false;
        }
        boolean bl = this.skipWhiteSpace();
        if (this.isEOF()) {
            this.popXMLReader();
            this.input.pushChar(32);
            return true;
        }
        if (bl) {
            this.input.pushChar(32);
        }
        return false;
    }

    boolean pushEntityRef() throws SAXException, IOException {
        if (super.tryRead(37)) {
            XMLEntity xMLEntity = this.getEntity(true);
            if (xMLEntity == null) {
                return false;
            }
            boolean bl = this.pushEntityRef(xMLEntity);
            this.skipWhiteSpace();
            return bl;
        }
        return false;
    }

    public int read() throws SAXException, IOException {
        this.checkEntityStart();
        int n = super.read();
        this.checkEntityEnd();
        return n;
    }

    public void requireWhiteSpace() throws SAXException, IOException {
        if (!this.skipWhiteSpace() && !this.pushEntityRef()) {
            this.err.error(this, this.err.getMessage0(190), 190, 0, false);
        }
    }

    public int scanCharRef() throws SAXException, IOException {
        this.checkEntityStart();
        int n = super.scanCharRef();
        this.checkEntityEnd();
        return n;
    }

    public String scanComment() throws SAXException, IOException {
        String string = super.scanComment();
        this.checkEntityEnd();
        return string;
    }

    String scanEntityRefValue() throws XMLParseException, SAXException, IOException {
        String string = "";
        String string2 = super.scanQName();
        XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string2, true);
        if (!super.tryRead(59)) {
            this.err.error(this, this.err.getMessage1(100, ";"), 100, 0, false);
        }
        if (xMLEntity == null) {
            this.err.error(this, this.err.getMessage1(151, string2), 151, 1, false);
            return "";
        }
        if (xMLEntity.getLength() == -1) {
            return xMLEntity.getNodeValue();
        }
        if (!this.pushEntityRef(xMLEntity)) {
            return "";
        }
        while (true) {
            string = string.concat(super.scanEntityString(65535));
            if (super.tryRead(37)) {
                string = string.concat(this.scanEntityRefValue());
                continue;
            }
            if (this.isEOF()) break;
        }
        this.popXMLReader();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String scanEntityString(int n) throws SAXException, IOException {
        String string = "";
        while (true) {
            string = string.concat(super.scanEntityString(n));
            if (super.peek() == n) return string;
            if (super.tryRead(37)) {
                string = string.concat(this.scanEntityRefValue());
                continue;
            }
            if (this.isEOF()) return string;
        }
    }

    public String scanName() throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanName();
        this.checkEntityEnd();
        return string;
    }

    public String scanNmToken() throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanNmToken();
        this.checkEntityEnd();
        return string;
    }

    public String scanPI() throws SAXException, IOException {
        String string = super.scanPI();
        this.checkEntityEnd();
        return string;
    }

    public String scanQName() throws SAXException, IOException {
        this.checkEntityStart();
        this.st = this.currentPos;
        this.scanNameChars();
        if (super.tryRead(58)) {
            this.scanNameChars();
        }
        String string = XMLReader.names.create(this.currentBuffer, this.st, this.currentPos - this.st);
        this.checkEntityEnd();
        return string;
    }

    public String scanQName(String[] stringArray) throws SAXException, IOException {
        this.checkEntityStart();
        this.st = this.currentPos;
        this.scanNameChars();
        stringArray[0] = XMLReader.names.create(this.currentBuffer, this.st, this.currentPos - this.st);
        int n = this.currentPos - this.st;
        if (super.tryRead(58)) {
            this.scanNameChars();
            int n2 = this.st + n + 1;
            stringArray[1] = XMLReader.names.create(this.currentBuffer, n2, this.currentPos - n2);
        } else {
            stringArray[1] = stringArray[0];
            stringArray[0] = "";
        }
        String string = XMLReader.names.create(this.currentBuffer, this.st, this.currentPos - this.st);
        this.checkEntityEnd();
        return string;
    }

    public String scanQuotedString() throws SAXException, IOException {
        this.checkEntityStart();
        String string = super.scanQuotedString();
        this.checkEntityEnd();
        return string;
    }

    public char[] scanWhiteSpace(int[] nArray) throws SAXException, IOException {
        this.checkEntityStart();
        char[] cArray = super.scanWhiteSpace(nArray);
        this.checkEntityEnd();
        return cArray;
    }

    public void skipIgnoreSection() throws SAXException, IOException {
        while (!this.isEOF()) {
            if (super.tryRead(XMLConstants.cCDATASTART, 0, 3)) {
                this.skipIgnoreSection();
                continue;
            }
            if (super.tryRead(XMLConstants.cCDATAEND, 0, XMLConstants.cCDATAEND.length)) {
                this.checkEntityEnd();
                return;
            }
            ++this.currentPos;
        }
        this.err.error(this, this.err.getMessage0(115), 115, 0, false);
        this.err.error(this, this.err.getMessage0(193), 193, 0, true);
        this.checkEntityEnd();
    }

    public void skipNSName() throws SAXException, IOException {
        super.skipNSName();
        this.checkEntityEnd();
    }

    void skipQuotedString() throws SAXException, IOException {
        super.skipQuotedString();
        this.checkEntityEnd();
    }

    public void skipUntil(int n) throws SAXException, IOException {
        super.skipUntil(n);
        this.checkEntityEnd();
    }

    void synchronize() {
        this.input = this.prevReader.input;
        this.input.setParent(this);
        this.currentBuffer = this.prevReader.currentBuffer;
        this.currentPos = this.prevReader.currentPos;
        this.currentInput = this.prevReader.currentInput;
        this.startInput = this.prevReader.currentInput;
    }

    public boolean tryRead(int n) throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(n);
        this.checkEntityEnd();
        return bl;
    }

    public boolean tryRead(char[] cArray, int n, int n2) throws SAXException, IOException {
        this.checkEntityStart();
        boolean bl = super.tryRead(cArray, n, n2);
        this.checkEntityEnd();
        return bl;
    }
}

