/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XPathException;
import oracle.xml.parser.v2.XSLDocumentBuilder;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLNodeSetInt;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLNode
implements Node,
XMLConstants,
Cloneable,
Serializable {
    String tag;
    short type;
    String text;
    public XMLNode parent = null;
    XMLNodeList children;
    Document doc;
    NodeFactory factory;
    public boolean external = false;
    int debug_line = 0;
    int debug_col = 0;
    String debug_sysid;
    boolean debug_flag = false;
    public int docOrderId;
    public static final short ELEMENTDECL = 13;
    public static final short ATTRDECL = 14;

    public XMLNode(String string, short s) {
        this(string, s, false);
    }

    XMLNode(String string, short s, boolean bl) {
        this.tag = string;
        this.type = s;
        switch (s) {
            default: {
                if (bl) break;
                this.children = new XMLNodeList();
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
        }
    }

    public XMLNode addText(String string) throws XMLDOMException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        this.addText(cArray, 0, n);
        return (XMLNode)this.getLastChild();
    }

    public void addText(char[] cArray, int n, int n2) throws XMLDOMException {
        boolean bl;
        XMLNode xMLNode = (XMLNode)this.getLastChild();
        boolean bl2 = bl = xMLNode == null || xMLNode.type != 3;
        if (bl) {
            XMLText xMLText = new XMLText(cArray, n, n2);
            this.appendChild(xMLText, true);
        } else {
            xMLNode.addText(cArray, n, n2);
        }
    }

    public Node appendChild(Node node) throws DOMException {
        return this.appendChild(node, false);
    }

    public Node appendChild(Node node, boolean bl) throws DOMException {
        if (node instanceof XMLDocumentFragment) {
            XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)node;
            int n = xMLDocumentFragment.children.getLength();
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)xMLDocumentFragment.children.item(0);
                this.appendChild(xMLNode, bl);
                ++n2;
            }
            return node;
        }
        if (!bl) {
            this.checkChildType(node.getNodeType());
            this.checkDocument(node);
            this.checkAncestry(node);
            this.checkReadOnly();
        }
        if (((XMLNode)node).parent != null) {
            ((XMLNode)node).parent.removeChild(node, bl);
        }
        this.children.addNode(node);
        ((XMLNode)node).parent = this;
        ((XMLNode)node).doc = this.doc;
        return node;
    }

    void checkAncestry(Node node) throws DOMException {
        if (node != null) {
            Node node2 = this;
            while (node2.getParentNode() != null) {
                if ((node2 = node2.getParentNode()) != node) continue;
                throw new XMLDOMException(3, this.getXMLError());
            }
        }
    }

    void checkChildType(int n) throws DOMException {
        throw new XMLDOMException(3, this.getXMLError());
    }

    void checkDocument(Node node) throws DOMException {
        Document document = this.getOwnerDocument();
        Document document2 = node.getOwnerDocument();
        if (document2 != null && (document == null ? document2 != this : document2 != document)) {
            throw new XMLDOMException(4, this.getXMLError());
        }
    }

    void checkReadOnly() throws DOMException {
        XMLNode xMLNode = this;
        do {
            if (xMLNode.type != 6 && xMLNode.type != 5) continue;
            throw new XMLDOMException(7, this.getXMLError());
        } while ((xMLNode = xMLNode.parent) != null);
    }

    public Node cloneNode(boolean bl) {
        if (this.factory == null) {
            this.factory = new NodeFactory();
        }
        XMLNode xMLNode = null;
        switch (this.type) {
            case 1: {
                xMLNode = this.factory.createElement(this.tag);
                break;
            }
            case 11: {
                xMLNode = this.factory.createDocumentFragment();
                break;
            }
            case 10: {
                xMLNode = new DTD(this.tag);
                break;
            }
            case 9: {
                xMLNode = this.factory.createDocument();
                break;
            }
            case 3: {
                xMLNode = this.factory.createTextNode(this.getText());
                break;
            }
            case 4: {
                xMLNode = this.factory.createCDATASection(this.text);
                break;
            }
            case 8: {
                xMLNode = this.factory.createComment(this.text);
                break;
            }
            case 7: {
                xMLNode = this.factory.createProcessingInstruction(this.tag, this.text);
                break;
            }
            case 2: {
                xMLNode = this.factory.createAttribute(this.tag, this.text);
                break;
            }
            default: {
                xMLNode = new XMLNode(this.tag, this.type);
            }
        }
        xMLNode.factory = this.factory;
        xMLNode.doc = null;
        if (!bl || this.children == null) {
            return xMLNode;
        }
        int n = this.children.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode2 = (XMLNode)this.children.item(n2);
            xMLNode.appendChild(xMLNode2.cloneNode(bl), true);
            ++n2;
        }
        return xMLNode;
    }

    void generateSAXEvents(XMLDocumentHandler xMLDocumentHandler) throws SAXException {
        if (this.children != null) {
            int n = this.children.getLength();
            int n2 = 0;
            while (n2 < n) {
                ((XMLNode)this.children.item(n2)).generateSAXEvents(xMLDocumentHandler);
                ++n2;
            }
        }
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    Node getChild(int n) {
        if (this.children != null) {
            return this.children.item(n);
        }
        return null;
    }

    public NodeList getChildNodes() {
        if (this.children != null) {
            return this.children;
        }
        return new XMLNodeList();
    }

    public NodeList getChildren() {
        XMLNodeList xMLNodeList = new XMLNodeList();
        Node node = null;
        int n = this.children.getLength();
        int n2 = 0;
        while (n2 < n) {
            node = this.children.item(n2);
            if (!(node instanceof XMLDeclPI) && !(node instanceof DTD)) {
                xMLNodeList.addNode(node);
            }
            ++n2;
        }
        return xMLNodeList;
    }

    public int getColumnNumber() {
        return this.debug_col;
    }

    public boolean getDebugMode() {
        return this.debug_flag;
    }

    public Node getFirstChild() {
        if (this.children != null) {
            return this.children.item(0);
        }
        return null;
    }

    public Node getLastChild() {
        if (this.children != null) {
            return this.children.item(this.children.getLength() - 1);
        }
        return null;
    }

    public int getLineNumber() {
        return this.debug_line;
    }

    public Node getNextSibling() {
        if (this.parent != null) {
            int n = this.parent.children.indexOf(this);
            return this.parent.children.item(n + 1);
        }
        return null;
    }

    public String getNodeName() {
        return this.tag;
    }

    public short getNodeType() {
        return this.type;
    }

    public String getNodeValue() throws DOMException {
        return this.text;
    }

    public Document getOwnerDocument() {
        XMLNode xMLNode = this;
        while (xMLNode.parent != null) {
            xMLNode = xMLNode.parent;
        }
        if (xMLNode.type == 9) {
            this.doc = (Document)((Object)xMLNode);
        }
        return this.doc;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public Node getPreviousSibling() {
        if (this.parent != null) {
            int n = this.parent.children.indexOf(this);
            return this.parent.children.item(n - 1);
        }
        return null;
    }

    public XMLElement getSrcRoot() throws XPathException {
        XMLNode xMLNode = this.type == 2 ? ((XMLAttr)this).getOwnerElement() : this;
        while (xMLNode.getParentNode() != null) {
            xMLNode = (XMLNode)xMLNode.getParentNode();
        }
        if (!(xMLNode instanceof XMLElement)) {
            return null;
        }
        return (XMLElement)xMLNode;
    }

    public String getSystemId() {
        return this.debug_sysid;
    }

    public String getText() {
        if (!this.hasChildNodes()) {
            return this.text == null ? new String("") : this.text;
        }
        if (this.hasChildNodes()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.children.getLength();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(((XMLNode)this.children.item(n2)).getText());
                ++n2;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    XMLError getXMLError() {
        XMLDocument xMLDocument = (XMLDocument)this.getOwnerDocument();
        if (xMLDocument == null) {
            return new XMLError();
        }
        return xMLDocument.err;
    }

    public boolean hasChildNodes() {
        if (this.children != null) {
            return this.children.getLength() > 0;
        }
        return false;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.insertBefore(node, node2, false);
    }

    Node insertBefore(Node node, Node node2, boolean bl) throws DOMException {
        if (node instanceof XMLDocumentFragment) {
            XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)node;
            int n = xMLDocumentFragment.children.getLength();
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)xMLDocumentFragment.children.item(0);
                this.insertBefore(xMLNode, node2);
                ++n2;
            }
            return node;
        }
        if (!bl) {
            this.checkChildType(node.getNodeType());
            this.checkDocument(node);
            this.checkAncestry(node);
            this.checkReadOnly();
        }
        if (((XMLNode)node).parent != null) {
            ((XMLNode)node).parent.removeChild(node, bl);
        }
        if (node2 == null) {
            this.children.addNode(node);
        } else {
            int n = this.children.indexOf(node2);
            if (!bl && n == -1) {
                throw new XMLDOMException(8, this.getXMLError());
            }
            this.children.insertNode(node, n);
        }
        ((XMLNode)node).parent = this;
        ((XMLNode)node).doc = this.doc;
        return node;
    }

    public void print(OutputStream outputStream) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        XMLDocument xMLDocument = (XMLDocument)this.getOwnerDocument();
        if (xMLDocument != null) {
            xMLOutputStream.setEncoding(xMLDocument.getEncoding(), true, true);
        }
        this.print(xMLOutputStream, false);
    }

    public void print(OutputStream outputStream, String string) throws IOException {
        String string2 = null;
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        XMLDocument xMLDocument = (XMLDocument)this.getOwnerDocument();
        if (xMLDocument != null) {
            string2 = xMLDocument.getEncoding();
            xMLDocument.setEncoding(string);
            xMLOutputStream.err = xMLDocument.err;
        }
        xMLOutputStream.setEncoding(string, true, true);
        this.print(xMLOutputStream, false);
        if (xMLDocument != null) {
            xMLDocument.setEncoding(string2);
        }
    }

    public void print(PrintWriter printWriter) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(printWriter);
        XMLDocument xMLDocument = (XMLDocument)this.getOwnerDocument();
        if (xMLDocument != null) {
            xMLOutputStream.err = xMLDocument.err;
        }
        this.print(xMLOutputStream, false);
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (!bl && this.children != null) {
            this.children.print(xMLOutputStream, false);
        }
        xMLOutputStream.flush();
    }

    public Node removeChild(Node node) throws DOMException {
        return this.removeChild(node, false);
    }

    Node removeChild(Node node, boolean bl) throws DOMException {
        if (!bl) {
            this.checkReadOnly();
            if (this.children == null) {
                throw new XMLDOMException(8, this.getXMLError());
            }
            if (this.children.indexOf(node) == -1) {
                throw new XMLDOMException(8, this.getXMLError());
            }
        }
        this.children.removeNode(node);
        ((XMLNode)node).parent = null;
        ((XMLNode)node).doc = null;
        return node;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.checkChildType(node.getNodeType());
        this.checkDocument(node);
        this.checkAncestry(node);
        this.checkReadOnly();
        int n = this.children.indexOf(node2);
        if (n == -1) {
            throw new XMLDOMException(8, this.getXMLError());
        }
        if (((XMLNode)node).parent != null) {
            ((XMLNode)node).parent.removeChild(node, false);
        }
        this.children.setNode(node, n);
        ((XMLNode)node).parent = this;
        ((XMLNode)node).doc = this.doc;
        ((XMLNode)node2).parent = null;
        ((XMLNode)node2).doc = null;
        return node2;
    }

    public NodeList selectNodes(String string) throws XSLException {
        NSResolver nSResolver = new NSResolver(){

            public String resolveNamespacePrefix(String string) {
                return null;
            }
        };
        return this.selectNodes(string, nSResolver);
    }

    public NodeList selectNodes(String string, NSResolver nSResolver) throws XSLException {
        XSLTContext xSLTContext = new XSLTContext();
        XSLNodeSetInt xSLNodeSetInt = XSLExprBase.createNodeSetExpr(string, nSResolver);
        XMLElement xMLElement = this.getSrcRoot();
        Document document = this.getOwnerDocument();
        NodeList nodeList = null;
        try {
            xSLTContext.init();
            xSLTContext.addSourceContext(xMLElement, (XMLDocument)document);
            XSLNodeList xSLNodeList = new XSLNodeList();
            xSLNodeList.addNode(this);
            xSLTContext.pushCurrentNodeList(xSLNodeList);
            xSLTContext.setCurrentNode(this);
            xSLTContext.pushCurrentNodeList2(xSLNodeList);
            xSLTContext.setCurrentNode2(this);
            nodeList = xSLNodeSetInt.getSelectedNodes(xSLTContext);
            xSLTContext.popCurrentNodeList();
            xSLTContext.reset();
        }
        catch (XSLException xSLException) {
            xSLTContext.popCurrentNodeList();
        }
        return nodeList;
    }

    public Node selectSingleNode(String string) throws XSLException {
        NSResolver nSResolver = new NSResolver(){

            public String resolveNamespacePrefix(String string) {
                return null;
            }
        };
        NodeList nodeList = this.selectNodes("(" + string + ")[1]", nSResolver);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public Node selectSingleNode(String string, NSResolver nSResolver) throws XSLException {
        NodeList nodeList = this.selectNodes("(" + string + ")[1]", nSResolver);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public void setDebugInfo(int n, int n2, String string) {
        this.debug_line = n;
        this.debug_col = n2;
        this.debug_sysid = string;
        this.debug_flag = true;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new XMLDOMException(7, this.getXMLError());
    }

    public DocumentFragment transformNode(XSLStylesheet xSLStylesheet) throws XSLException {
        XSLTContext xSLTContext = new XSLTContext();
        XMLElement xMLElement = this.getSrcRoot();
        Document document = this.getOwnerDocument();
        XSLDocumentBuilder xSLDocumentBuilder = new XSLDocumentBuilder();
        XSLEventHandler xSLEventHandler = new XSLEventHandler(xSLDocumentBuilder, xSLTContext);
        XMLDocumentFragment xMLDocumentFragment = null;
        try {
            XSLNodeList xSLNodeList = new XSLNodeList();
            xSLNodeList.addNode(this);
            xSLTContext.init();
            xSLTContext.addSourceContext(xMLElement, (XMLDocument)document);
            xSLTContext.setEventHandler(xSLEventHandler);
            xSLTContext.pushCurrentNodeList(xSLNodeList);
            xSLTContext.setCurrentNode(this);
            xSLTContext.pushCurrentNodeList2(xSLNodeList);
            xSLTContext.setCurrentNode2(this);
            xSLStylesheet.execute(xSLTContext);
            xSLTContext.reset();
            xMLDocumentFragment = xSLDocumentBuilder.getResultFragment();
        }
        catch (XSLException xSLException) {
            if (xSLException.getMessage().equals("TERMINATE PROCESSING")) {
                xSLTContext.popCurrentNodeList();
            }
            throw xSLException;
        }
        return xMLDocumentFragment;
    }

    public String valueOf(String string) throws XSLException {
        NSResolver nSResolver = new NSResolver(){

            public String resolveNamespacePrefix(String string) {
                return null;
            }
        };
        NodeList nodeList = this.selectNodes(string, nSResolver);
        if (nodeList.getLength() == 0) {
            return "";
        }
        return ((XMLNode)nodeList.item(0)).getText();
    }

    public String valueOf(String string, NSResolver nSResolver) throws XSLException {
        NodeList nodeList = this.selectNodes(string, nSResolver);
        if (nodeList.getLength() == 0) {
            return "";
        }
        return ((XMLNode)nodeList.item(0)).getText();
    }
}

